/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

public final class Base64 {
    private static final byte[] B = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final char[] C = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] I = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static final char[] toCharArray(byte[] text) {
        return Base64.toCharArray(text, 0, text.length);
    }

    public static final char[] toCharArray(byte[] text, int from, int len) {
        int i;
        char[] code;
        int bi = from + len;
        int ci = len / 3 << 2;
        switch (len % 3) {
            case 1: {
                code = new char[ci += 4];
                i = text[--bi] << 4;
                code[--ci] = 61;
                code[--ci] = 61;
                code[--ci] = C[i & 0x3F];
                code[--ci] = C[i >>> 6 & 0x3F];
                break;
            }
            case 2: {
                code = new char[ci += 4];
                i = (text[--bi] & 0xFF) << 2 | text[--bi] << 10;
                code[--ci] = 61;
                code[--ci] = C[i & 0x3F];
                code[--ci] = C[i >>> 6 & 0x3F];
                code[--ci] = C[i >>> 12 & 0x3F];
                break;
            }
            default: {
                code = new char[ci];
            }
        }
        while (ci > 0) {
            i = text[--bi] & 0xFF | (text[--bi] & 0xFF) << 8 | text[--bi] << 16;
            code[--ci] = C[i & 0x3F];
            code[--ci] = C[i >>> 6 & 0x3F];
            code[--ci] = C[i >>> 12 & 0x3F];
            code[--ci] = C[i >>> 18 & 0x3F];
        }
        return code;
    }

    public static final byte[] encode(byte[] text) {
        return Base64.encode(text, 0, text.length);
    }

    public static final byte[] encode(byte[] text, int from, int len) {
        int i;
        byte[] code;
        int bi = from + len;
        int ci = len / 3 << 2;
        switch (len % 3) {
            case 1: {
                code = new byte[ci += 4];
                i = text[--bi] << 4;
                code[--ci] = 61;
                code[--ci] = 61;
                code[--ci] = B[i & 0x3F];
                code[--ci] = B[i >>> 6 & 0x3F];
                break;
            }
            case 2: {
                code = new byte[ci += 4];
                i = (text[--bi] & 0xFF) << 2 | text[--bi] << 10;
                code[--ci] = 61;
                code[--ci] = B[i & 0x3F];
                code[--ci] = B[i >>> 6 & 0x3F];
                code[--ci] = B[i >>> 12 & 0x3F];
                break;
            }
            default: {
                code = new byte[ci];
            }
        }
        while (ci > 0) {
            i = text[--bi] & 0xFF | (text[--bi] & 0xFF) << 8 | text[--bi] << 16;
            code[--ci] = B[i & 0x3F];
            code[--ci] = B[i >>> 6 & 0x3F];
            code[--ci] = B[i >>> 12 & 0x3F];
            code[--ci] = B[i >>> 18 & 0x3F];
        }
        return code;
    }

    public static final int encode(byte[] src, int sstart, int len, byte[] dest, int dstart) {
        int i;
        int dend;
        int bi = sstart + len;
        int ci = (len / 3 << 2) + dstart;
        switch (len % 3) {
            case 1: {
                ci += 4;
                dend = ci--;
                i = src[--bi] << 4;
                dest[ci] = 61;
                dest[--ci] = 61;
                dest[--ci] = B[i & 0x3F];
                dest[--ci] = B[i >>> 6 & 0x3F];
                break;
            }
            case 2: {
                ci += 4;
                dend = ci--;
                i = (src[--bi] & 0xFF) << 2 | src[--bi] << 10;
                dest[ci] = 61;
                dest[--ci] = B[i & 0x3F];
                dest[--ci] = B[i >>> 6 & 0x3F];
                dest[--ci] = B[i >>> 12 & 0x3F];
                break;
            }
            default: {
                dend = ci;
            }
        }
        while (ci > dstart) {
            i = src[--bi] & 0xFF | (src[--bi] & 0xFF) << 8 | src[--bi] << 16;
            dest[--ci] = B[i & 0x3F];
            dest[--ci] = B[i >>> 6 & 0x3F];
            dest[--ci] = B[i >>> 12 & 0x3F];
            dest[--ci] = B[i >>> 18 & 0x3F];
        }
        return dend;
    }

    public static final char[] toCharArray(byte[] text, int llen) {
        int i;
        char[] code;
        int bi = text.length;
        int ci = bi / 3 << 2;
        switch (bi % 3) {
            case 1: {
                ci += 4;
                ci += ci / llen << 1;
                code = new char[ci];
                if (ci % llen == 4) {
                    code[--ci] = 10;
                    code[--ci] = 13;
                }
                i = text[--bi] << 4;
                code[--ci] = 61;
                code[--ci] = 61;
                code[--ci] = C[i & 0x3F];
                code[--ci] = C[i >>> 6 & 0x3F];
                break;
            }
            case 2: {
                ci += 4;
                ci += ci / llen << 1;
                code = new char[ci];
                if (ci % llen == 4) {
                    code[--ci] = 10;
                    code[--ci] = 13;
                }
                i = (text[--bi] & 0xFF) << 2 | text[--bi] << 10;
                code[--ci] = 61;
                code[--ci] = C[i & 0x3F];
                code[--ci] = C[i >>> 6 & 0x3F];
                code[--ci] = C[i >>> 12 & 0x3F];
                break;
            }
            default: {
                ci += ci / llen << 1;
                code = new char[ci];
            }
        }
        int lmax = (llen >>> 2) - 1;
        int li = ci % (llen + 2) >>> 2;
        while (bi > 0) {
            if (li > 0) {
                --li;
            } else {
                code[--ci] = 10;
                code[--ci] = 13;
                li = lmax;
            }
            i = text[--bi] & 0xFF | (text[--bi] & 0xFF) << 8 | text[--bi] << 16;
            code[--ci] = C[i & 0x3F];
            code[--ci] = C[i >>> 6 & 0x3F];
            code[--ci] = C[i >>> 12 & 0x3F];
            code[--ci] = C[i >>> 18 & 0x3F];
        }
        return code;
    }

    public static final byte[] encode(byte[] text, int llen) {
        int i;
        byte[] code;
        int bi = text.length;
        int ci = bi / 3 << 2;
        switch (bi % 3) {
            case 1: {
                ci += 4;
                ci += ci / llen << 1;
                code = new byte[ci];
                if (ci % llen == 4) {
                    code[--ci] = 10;
                    code[--ci] = 13;
                }
                i = text[--bi] << 4;
                code[--ci] = 61;
                code[--ci] = 61;
                code[--ci] = B[i & 0x3F];
                code[--ci] = B[i >>> 6 & 0x3F];
                break;
            }
            case 2: {
                ci += 4;
                ci += ci / llen << 1;
                code = new byte[ci];
                if (ci % llen == 4) {
                    code[--ci] = 10;
                    code[--ci] = 13;
                }
                i = (text[--bi] & 0xFF) << 2 | text[--bi] << 10;
                code[--ci] = 61;
                code[--ci] = B[i & 0x3F];
                code[--ci] = B[i >>> 6 & 0x3F];
                code[--ci] = B[i >>> 12 & 0x3F];
                break;
            }
            default: {
                ci += ci / llen << 1;
                code = new byte[ci];
            }
        }
        int lmax = (llen >>> 2) - 1;
        int li = ci % (llen + 2) >>> 2;
        while (ci > 0) {
            if (li > 0) {
                --li;
            } else {
                code[--ci] = 10;
                code[--ci] = 13;
                li = lmax;
            }
            i = text[--bi] & 0xFF | (text[--bi] & 0xFF) << 8 | text[--bi] << 16;
            code[--ci] = B[i & 0x3F];
            code[--ci] = B[i >>> 6 & 0x3F];
            code[--ci] = B[i >>> 12 & 0x3F];
            code[--ci] = B[i >>> 18 & 0x3F];
        }
        return code;
    }

    public static final byte[] decode(char[] code) {
        return Base64.decode(code, 0, code.length);
    }

    public static final byte[] decode(char[] code, int from, int len) {
        int i;
        byte[] text;
        int bi = (len >>> 2) * 3;
        int ci = from + len;
        if (code[ci - 1] == '=') {
            if (code[ci - 2] == '=') {
                text = new byte[bi -= 2];
                text[--bi] = (byte)((I[code[ci -= 3]] | I[code[--ci]] << 6) >> 4);
            } else {
                text = new byte[--bi];
                i = I[code[ci -= 2]] | I[code[--ci]] << 6 | I[code[--ci]] << 12;
                text[--bi] = (byte)(i >>> 2);
                text[--bi] = (byte)(i >>> 10);
            }
        } else {
            text = new byte[bi];
        }
        while (bi > 0) {
            i = I[code[--ci]] | I[code[--ci]] << 6 | I[code[--ci]] << 12 | I[code[--ci]] << 18;
            text[--bi] = (byte)i;
            text[--bi] = (byte)(i >>> 8);
            text[--bi] = (byte)(i >>> 16);
        }
        return text;
    }

    public static final byte[] decode(byte[] code) {
        return Base64.decode(code, 0, code.length);
    }

    public static final byte[] decode(byte[] src, int from, int len) {
        int i;
        byte[] text;
        int bi = (len >>> 2) * 3;
        int ci = from + len;
        if (src[ci - 1] == 61) {
            if (src[ci - 2] == 61) {
                text = new byte[bi -= 2];
                text[--bi] = (byte)((I[src[ci -= 3]] | I[src[--ci]] << 6) >> 4);
            } else {
                text = new byte[--bi];
                i = I[src[ci -= 2]] | I[src[--ci]] << 6 | I[src[--ci]] << 12;
                text[--bi] = (byte)(i >>> 2);
                text[--bi] = (byte)(i >>> 10);
            }
        } else {
            text = new byte[bi];
        }
        while (bi > 0) {
            i = I[src[--ci]] | I[src[--ci]] << 6 | I[src[--ci]] << 12 | I[src[--ci]] << 18;
            text[--bi] = (byte)i;
            text[--bi] = (byte)(i >>> 8);
            text[--bi] = (byte)(i >>> 16);
        }
        return text;
    }

    public static final byte[] decode76(char[] code) {
        return Base64.decodeCRLF(code, 0, code.length, 76);
    }

    public static final byte[] decodeCRLF(char[] code, int from, int len, int llen) {
        int i;
        byte[] text;
        int bi = (len - (len / (llen + 2) << 1) >>> 2) * 3;
        int ci = from + len;
        int lmax = llen >>> 2;
        int li = ci % (llen + 2) >>> 2;
        if (li == 0) {
            ci -= 2;
            li = lmax;
        }
        if (code[ci - 1] == '=') {
            if (code[ci - 2] == '=') {
                text = new byte[bi -= 2];
                text[--bi] = (byte)((I[code[ci -= 3]] | I[code[--ci]] << 6) >> 4);
                --li;
            } else {
                text = new byte[--bi];
                i = I[code[ci -= 2]] | I[code[--ci]] << 6 | I[code[--ci]] << 12;
                text[--bi] = (byte)(i >>> 2);
                text[--bi] = (byte)(i >>> 10);
                --li;
            }
        } else {
            text = new byte[bi];
        }
        while (bi > 0) {
            if (li == 0) {
                ci -= 2;
                li = lmax;
            }
            i = I[code[--ci]] | I[code[--ci]] << 6 | I[code[--ci]] << 12 | I[code[--ci]] << 18;
            text[--bi] = (byte)i;
            text[--bi] = (byte)(i >>> 8);
            text[--bi] = (byte)(i >>> 16);
            --li;
        }
        return text;
    }

    public static final byte[] decodeCRLF(char[] code, int from, int len) {
        int bi = len;
        int ci = from + len;
        while (ci > from) {
            if (I[code[--ci]] >= 0) continue;
            --bi;
        }
        bi = (bi >>> 2) * 3;
        byte[] text = new byte[bi];
        ci = from + len;
        while (bi > 0) {
            int i;
            while ((i = I[code[--ci]]) < 0) {
            }
            int n = I[code[--ci]] << 6 | I[code[--ci]] << 12;
            text[--bi] = (byte)(i |= n | I[code[--ci]] << 18);
            text[--bi] = (byte)(i >>> 8);
            text[--bi] = (byte)(i >>> 16);
        }
        return text;
    }

    public static final byte[] decodeFailSafe(char[] code) {
        return Base64.decodeFailSafe(code, 0, code.length);
    }

    public static final byte[] decodeFailSafe(char[] code, int from, int len) {
        char c;
        int cj = from;
        int ce = from + len;
        for (int ci = from; ci < ce && (c = code[ci]) != '='; ++ci) {
            try {
                if (I[c] < 0) continue;
                code[cj++] = c;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        switch (cj - from & 3) {
            case 1: {
                code[cj++] = C[0];
            }
            case 2: {
                code[cj++] = 61;
            }
            case 3: {
                code[cj++] = 61;
            }
        }
        return Base64.decode(code, from, cj - from);
    }
}

