/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IBelief;
import jadex.runtime.IBeliefSet;
import jadex.runtime.ICondition;
import jadex.runtime.IEvent;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IWaitqueue;
import jadex.runtime.externalaccesswrapper.BeliefSetWrapper;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.Waitqueue;
import jadex.runtime.planwrapper.BeliefWrapper;
import jadex.runtime.planwrapper.ConditionWrapper;
import jadex.runtime.planwrapper.EventbaseWrapper;
import jadex.runtime.planwrapper.GoalWrapper;
import jadex.runtime.planwrapper.MessageEventWrapper;

public class WaitqueueWrapper
implements IWaitqueue {
    protected Waitqueue waitqueue;
    private RPlan plan;

    public WaitqueueWrapper(Waitqueue waitqueue, RPlan plan) {
        this.waitqueue = waitqueue;
        this.plan = plan;
    }

    public IEvent[] getEvents() {
        this.checkThreadAccess();
        IREvent[] evs = this.waitqueue.getEvents();
        IEvent[] ret = new IEvent[evs.length];
        for (int i = 0; i < evs.length; ++i) {
            ret[i] = EventbaseWrapper.wrap(evs[i], this.plan);
        }
        return ret;
    }

    public IEvent[] getEvents(IFilter filter) {
        this.checkThreadAccess();
        IREvent[] evs = this.waitqueue.getEvents(filter);
        IEvent[] ret = new IEvent[evs.length];
        for (int i = 0; i < evs.length; ++i) {
            ret[i] = EventbaseWrapper.wrap(evs[i], this.plan);
        }
        return ret;
    }

    public void addMessageEvent(String type) {
        this.checkThreadAccess();
        this.waitqueue.addMessageEvent(type, null);
    }

    public void addReply(IMessageEvent me) {
        this.checkThreadAccess();
        IRMessageEvent ime = (IRMessageEvent)((MessageEventWrapper)me).unwrap();
        this.waitqueue.addMessageEvent(ime);
    }

    public void addInternalEvent(String type) {
        this.checkThreadAccess();
        this.waitqueue.addInternalEvent(type, null);
    }

    public void addGoal(String type) {
        this.checkThreadAccess();
        this.waitqueue.addGoal(type, null);
    }

    public void addSubgoal(IGoal subgoal) {
        this.checkThreadAccess();
        this.waitqueue.addGoal((IRGoal)((GoalWrapper)subgoal).unwrap());
    }

    public void addBelief(String type) {
        this.checkThreadAccess();
        this.waitqueue.addBelief(type);
    }

    public void addBelief(IBelief bel) {
        this.checkThreadAccess();
        this.waitqueue.addBelief((IRBelief)((BeliefWrapper)bel).unwrap());
    }

    public void addBeliefSet(String type, String[] eventtype) {
        this.checkThreadAccess();
        this.waitqueue.addBeliefSet(type, eventtype);
    }

    public void addBeliefSet(IBeliefSet belset, String[] eventtype) {
        this.checkThreadAccess();
        this.waitqueue.addBeliefSet((IRBeliefSet)((BeliefSetWrapper)belset).unwrap(), eventtype);
    }

    public void addFilter(IFilter filter) {
        this.checkThreadAccess();
        this.waitqueue.addFilter(filter);
    }

    public void addCondition(String condition) {
        this.checkThreadAccess();
        this.waitqueue.addCondition(condition);
    }

    public void addCondition(ICondition condition) {
        this.checkThreadAccess();
        this.waitqueue.addCondition((IRCondition)((ConditionWrapper)condition).unwrap());
    }

    public void removeMessageEvent(String type) {
        this.checkThreadAccess();
        this.waitqueue.removeMessageEvent(type);
    }

    public void removeReply(IMessageEvent me) {
        this.checkThreadAccess();
        IRMessageEvent ime = (IRMessageEvent)((MessageEventWrapper)me).unwrap();
        this.waitqueue.removeMessageEvent(ime);
    }

    public void removeInternalEvent(String type) {
        this.checkThreadAccess();
        this.waitqueue.removeInternalEvent(type);
    }

    public void removeGoal(String type) {
        this.checkThreadAccess();
        this.waitqueue.removeGoal(type);
    }

    public void removeGoal(IGoal goal) {
        this.checkThreadAccess();
        this.waitqueue.removeGoal((IRGoal)((GoalWrapper)goal).unwrap());
    }

    public void removeBelief(String type) {
        this.checkThreadAccess();
        this.waitqueue.removeBelief(type);
    }

    public void removeBelief(IRBelief bel) {
        this.checkThreadAccess();
        this.waitqueue.removeBelief(bel);
    }

    public void removeBeliefSet(String type) {
        this.checkThreadAccess();
        this.waitqueue.removeBeliefSet(type);
    }

    public void removeBeliefSet(IRBeliefSet belset) {
        this.checkThreadAccess();
        this.waitqueue.removeBeliefSet(belset);
    }

    public void removeFilter(IFilter filter) {
        this.checkThreadAccess();
        this.waitqueue.removeFilter(filter);
    }

    public void removeCondition(String condition) {
        this.checkThreadAccess();
        this.waitqueue.removeCondition(condition);
    }

    public void removeCondition(ICondition condition) {
        this.checkThreadAccess();
        this.waitqueue.removeCondition((IRCondition)((ConditionWrapper)condition).unwrap());
    }

    public int size() {
        this.checkThreadAccess();
        return this.waitqueue.size();
    }

    public boolean isEmpty() {
        this.checkThreadAccess();
        return this.waitqueue.isEmpty();
    }

    public boolean checkThreadAccess0() {
        return this.plan.getThread() == Thread.currentThread();
    }

    public void checkThreadAccess() {
        if (!this.checkThreadAccess0()) {
            throw new RuntimeException("Wrong thread calling plan interface: " + Thread.currentThread());
        }
    }
}

