/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IParameter;
import jadex.runtime.IProcessGoal;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.planwrapper.ParameterElementWrapper;
import jadex.runtime.planwrapper.ParameterWrapper;

public class ProcessGoalWrapper
extends ParameterElementWrapper
implements IProcessGoal {
    protected RProcessGoal goal;

    public ProcessGoalWrapper(RProcessGoal goal, RPlan plan) {
        super(goal, plan);
        this.goal = goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goal.abort(false);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public boolean isAbortedOnSuccess() {
        this.checkThreadAccess();
        return this.goal.isAbortedOnSuccess();
    }

    public String getType() {
        this.checkThreadAccess();
        return this.goal.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object result) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goal.setResult(result);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public IParameter getResultParameter() {
        this.checkThreadAccess();
        IRParameter res = this.goal.findResultParemeter();
        return res == null ? null : new ParameterWrapper(res, this.getPlan());
    }

    public RProcessGoal getGoal() {
        return this.goal;
    }
}

