/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMPlan;
import jadex.runtime.IPlan;
import jadex.runtime.IPlanListener;
import jadex.runtime.IPlanbase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.runtime.planwrapper.PlanWrapper;
import jadex.util.Tuple;

public class PlanbaseWrapper
extends ElementWrapper
implements IPlanbase {
    protected RPlanbase planbase;

    protected PlanbaseWrapper(RPlanbase planbase, RPlan plan) {
        super(planbase, plan);
        this.planbase = planbase;
    }

    public IPlan[] getPlans() {
        this.checkThreadAccess();
        RPlan[] rplans = this.planbase.getPlans();
        IPlan[] plans = new IPlan[rplans.length];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = new PlanWrapper(rplans[i], this.getPlan());
        }
        return plans;
    }

    public IPlan[] getPlans(String type) {
        this.checkThreadAccess();
        RPlan[] rplans = this.planbase.getPlans(type);
        IPlan[] plans = new IPlan[rplans.length];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = new PlanWrapper(rplans[i], this.getPlan());
        }
        return plans;
    }

    public IPlan getPlan(String name) {
        this.checkThreadAccess();
        RPlan plan = this.planbase.getPlan(name);
        return plan == null ? null : new PlanWrapper(plan, this.getPlan());
    }

    public void registerPlan(IMPlan mplan) {
        this.checkThreadAccess();
        this.planbase.registerPlan(mplan);
    }

    public void deregisterPlan(IMPlan mplan) {
        this.checkThreadAccess();
        this.planbase.deregisterPlan(mplan);
    }

    public void addPlanListener(String type, IPlanListener userlistener, boolean async) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_planAdded", "BDI_planRemoved"}, type);
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, this.planbase, type}));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removePlanListener(String type, IPlanListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(new Object[]{userlistener, this.planbase, type});
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

