/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IPlan;
import jadex.runtime.IPlanListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.IWaitqueue;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ParameterElementWrapper;
import jadex.runtime.planwrapper.WaitqueueWrapper;
import jadex.util.Tuple;

public class PlanWrapper
extends ParameterElementWrapper
implements IPlan {
    protected WaitqueueWrapper waitqueue;
    protected RPlan original;

    public PlanWrapper(RPlan original, RPlan plan) {
        super(original, plan);
        this.original = original;
    }

    public IWaitqueue getWaitqueue() {
        if (this.waitqueue == null) {
            this.waitqueue = new WaitqueueWrapper(this.original.getWaitqueue(), this.getPlan());
        }
        return this.waitqueue;
    }

    public Object getBody() {
        return this.original.getBody();
    }

    public Object createBody() throws Exception {
        return this.original.createBody();
    }

    public void addPlanListener(IPlanListener userlistener, boolean async) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_planAdded", "BDI_planRemoved"}, this.unwrap());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.original));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removePlanListener(IPlanListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.original);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

