/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IParameter;
import jadex.runtime.IParameterSet;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RPlan;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.runtime.planwrapper.ParameterSetWrapper;
import jadex.runtime.planwrapper.ParameterWrapper;

public abstract class ParameterElementWrapper
extends ElementWrapper {
    protected IRParameterElement parelem;

    public ParameterElementWrapper(IRParameterElement element, RPlan plan) {
        super(element, plan);
        this.parelem = element;
    }

    public IParameter[] getParameters() {
        this.checkThreadAccess();
        IRParameter[] params = this.parelem.getParameters();
        IParameter[] ret = new IParameter[params.length];
        for (int i = 0; i < params.length; ++i) {
            ret[i] = new ParameterWrapper(params[i], this.getPlan());
        }
        return ret;
    }

    public IParameterSet[] getParameterSets() {
        this.checkThreadAccess();
        IRParameterSet[] paramsets = this.parelem.getParameterSets();
        IParameterSet[] ret = new IParameterSet[paramsets.length];
        for (int i = 0; i < paramsets.length; ++i) {
            ret[i] = new ParameterSetWrapper(paramsets[i], this.getPlan());
        }
        return ret;
    }

    public IParameter getParameter(String name) {
        return new ParameterWrapper(this.parelem.getParameter(name), this.getPlan());
    }

    public IParameterSet getParameterSet(String name) {
        return new ParameterSetWrapper(this.parelem.getParameterSet(name), this.getPlan());
    }

    public boolean hasParameter(String name) {
        this.checkThreadAccess();
        return this.parelem.hasParameter(name);
    }

    public boolean hasParameterSet(String name) {
        this.checkThreadAccess();
        return this.parelem.hasParameterSet(name);
    }
}

