/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IFilter;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IMessageEventListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventMessageFilter;
import jadex.runtime.planwrapper.EventWrapper;
import jadex.util.Tuple;

public class MessageEventWrapper
extends EventWrapper
implements IMessageEvent {
    protected IRMessageEvent event;

    protected MessageEventWrapper(IRMessageEvent event, RPlan plan) {
        super(event, plan);
        this.event = event;
    }

    public Object getMessage() {
        this.checkThreadAccess();
        return this.event.getMessage();
    }

    public Object getContent() {
        this.checkThreadAccess();
        return this.event.getContent();
    }

    public void setContent(Object content) {
        this.checkThreadAccess();
        this.event.setContent(content);
    }

    public IMessageEvent createReply(String type) {
        this.checkThreadAccess();
        return new MessageEventWrapper(this.event.createReply(type), this.getPlan());
    }

    public IMessageEvent createReply(String type, Object content) {
        this.checkThreadAccess();
        return new MessageEventWrapper(this.event.createReply(type, content), this.getPlan());
    }

    public IFilter getFilter() {
        this.checkThreadAccess();
        return this.event.getFilter();
    }

    public void addMessageEventListener(IMessageEventListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventMessageFilter filter = new SystemEventMessageFilter((IRMessageEvent)this.unwrap());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.event));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeMessageEventListener(IMessageEventListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.event);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

