/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.runtime.IGoalbase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RGoalbase;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.runtime.planwrapper.GoalWrapper;
import jadex.util.Tuple;

public class GoalbaseWrapper
extends ElementWrapper
implements IGoalbase {
    protected RGoalbase goalbase;

    protected GoalbaseWrapper(RGoalbase goalbase, RPlan plan) {
        super(goalbase, plan);
        this.goalbase = goalbase;
    }

    public IGoal getGoal(String name) {
        this.checkThreadAccess();
        IRGoal goal = this.goalbase.getGoal(name);
        return goal == null ? null : new GoalWrapper(goal, this.getPlan());
    }

    public boolean containsGoal(IGoal goal) {
        this.checkThreadAccess();
        return goal == null ? false : this.goalbase.containsGoal((IRGoal)((GoalWrapper)goal).unwrap());
    }

    public IGoal[] getGoals(String type) {
        this.checkThreadAccess();
        IRGoal[] rgoals = this.goalbase.getGoals(type);
        IGoal[] goals = new IGoal[rgoals.length];
        for (int i = 0; i < goals.length; ++i) {
            goals[i] = new GoalWrapper(rgoals[i], this.getPlan());
        }
        return goals;
    }

    public IGoal[] getGoals() {
        this.checkThreadAccess();
        IRGoal[] rgoals = this.goalbase.getGoals();
        IGoal[] goals = new IGoal[rgoals.length];
        for (int i = 0; i < goals.length; ++i) {
            goals[i] = new GoalWrapper(rgoals[i], this.getPlan());
        }
        return goals;
    }

    public IGoal createGoal(String type) {
        this.checkThreadAccess();
        return new GoalWrapper(this.goalbase.createGoal(type), this.getPlan());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFilter dispatchTopLevelGoal(IGoal goal) {
        IFilter ret = null;
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            ret = this.goalbase.dispatchTopLevelGoal((IRGoal)((GoalWrapper)goal).unwrap());
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGoal(IMGoal mgoal) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goalbase.registerGoal(mgoal);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterGoal(IMGoal mgoal) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goalbase.deregisterGoal(mgoal);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGoalReference(IMGoalReference mgoalref) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goalbase.registerGoalReference(mgoalref);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterGoalReference(IMGoalReference mgoalref) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goalbase.deregisterGoalReference(mgoalref);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public void addGoalListener(String type, IGoalListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_goalAdded", "BDI_goalRemoved"}, type);
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, this.goalbase, type}));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeGoalListener(String type, IGoalListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(new Object[]{userlistener, this.goalbase, type});
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

