/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ParameterElementWrapper;
import jadex.util.Tuple;

public class GoalWrapper
extends ParameterElementWrapper
implements IGoal {
    protected IRGoal goal;

    public GoalWrapper(IRGoal goal, RPlan plan) {
        super(goal, plan);
        this.goal = goal;
    }

    public boolean isPostToAll() {
        this.checkThreadAccess();
        return this.goal.isPostToAll();
    }

    public boolean isRandomSelection() {
        this.checkThreadAccess();
        return this.goal.isRandomSelection();
    }

    public void setPostToAll(boolean flag) {
        this.checkThreadAccess();
        this.goal.setPostToAll(flag);
    }

    public void setRandomSelection(boolean flag) {
        this.checkThreadAccess();
        this.goal.setRandomSelection(flag);
    }

    public boolean isRetry() {
        this.checkThreadAccess();
        return this.goal.isRetry();
    }

    public long getRetryDelay() {
        this.checkThreadAccess();
        return this.goal.getRetryDelay();
    }

    public String getExcludeMode() {
        this.checkThreadAccess();
        return this.goal.getExcludeMode();
    }

    public void setRetry(boolean flag) {
        this.checkThreadAccess();
        this.goal.setRetry(flag);
    }

    public void setRetryDelay(long delay) {
        this.checkThreadAccess();
        this.goal.setRetryDelay(delay);
    }

    public void setExcludeMode(String exclude) {
        this.checkThreadAccess();
        this.goal.setExcludeMode(exclude);
    }

    public boolean isRecur() {
        this.checkThreadAccess();
        return this.goal.isRecur();
    }

    public long getRecurDelay() {
        this.checkThreadAccess();
        return this.goal.getRecurDelay();
    }

    public void setRecur(boolean flag) {
        this.checkThreadAccess();
        this.goal.setRecur(flag);
    }

    public void setRecurDelay(long delay) {
        this.checkThreadAccess();
        this.goal.setRecurDelay(delay);
    }

    public boolean isActive() {
        this.checkThreadAccess();
        return this.goal.isActive();
    }

    public boolean isAdopted() {
        this.checkThreadAccess();
        return this.goal.isAdopted();
    }

    public String getLifecycleState() {
        this.checkThreadAccess();
        return this.goal.getLifecycleState();
    }

    public boolean isFinished() {
        this.checkThreadAccess();
        return this.goal.isFinished();
    }

    public boolean isSucceeded() {
        this.checkThreadAccess();
        return this.goal.isSucceeded();
    }

    public boolean isFailed() {
        this.checkThreadAccess();
        return this.goal.isFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goal.drop();
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public Exception getException() {
        this.checkThreadAccess();
        return this.goal.getException();
    }

    public Object getResult() {
        this.checkThreadAccess();
        return this.goal.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object result) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.goal.setResult(result);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public IFilter getFilter() {
        this.checkThreadAccess();
        return this.goal.getFilter();
    }

    public String getType() {
        this.checkThreadAccess();
        return this.goal.getType();
    }

    public void addGoalListener(IGoalListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_goalRemoved"}, this.unwrap());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.goal));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeGoalListener(IGoalListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.goal);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

