/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMCondition;
import jadex.model.IMConditionReference;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.runtime.ICondition;
import jadex.runtime.IConditionListener;
import jadex.runtime.IExpression;
import jadex.runtime.IExpressionbase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RExpressionbase;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ConditionWrapper;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.runtime.planwrapper.ExpressionWrapper;
import jadex.util.Tuple;

public class ExpressionbaseWrapper
extends ElementWrapper
implements IExpressionbase {
    protected RExpressionbase expressionbase;

    protected ExpressionbaseWrapper(RExpressionbase expressionbase, RPlan plan) {
        super(expressionbase, plan);
        this.expressionbase = expressionbase;
    }

    public IExpression getExpression(String name) {
        this.checkThreadAccess();
        return new ExpressionWrapper(this.expressionbase.getExpression(name), this.getPlan());
    }

    public IExpression createExpression(String query) {
        return this.createExpression(query, null, null);
    }

    public IExpression createExpression(String expression, String[] paramnames, Class[] paramtypes) {
        this.checkThreadAccess();
        return new ExpressionWrapper(this.expressionbase.createExpression(expression, paramnames, paramtypes), this.getPlan());
    }

    public ICondition getCondition(String name) {
        this.checkThreadAccess();
        return new ConditionWrapper(this.expressionbase.getCondition(name), this.getPlan());
    }

    public ICondition createCondition(String expression) {
        this.checkThreadAccess();
        return new ConditionWrapper(this.expressionbase.createCondition(expression), this.getPlan());
    }

    public ICondition createCondition(String expression, String trigger, String[] paramnames, Class[] paramtypes) {
        this.checkThreadAccess();
        return new ConditionWrapper(this.expressionbase.createCondition(expression, trigger, paramnames, paramtypes), this.getPlan());
    }

    public void registerExpression(IMExpression mexpression) {
        this.checkThreadAccess();
        this.expressionbase.registerExpression(mexpression);
    }

    public void registerExpressionReference(IMExpressionReference mexpressionref) {
        this.checkThreadAccess();
        this.expressionbase.registerExpressionReference(mexpressionref);
    }

    public void registerCondition(IMCondition mcondition) {
        this.checkThreadAccess();
        this.expressionbase.registerCondition(mcondition);
    }

    public void registerConditionReference(IMConditionReference mconditionref) {
        this.checkThreadAccess();
        this.expressionbase.registerConditionReference(mconditionref);
    }

    public void deregisterExpression(IMExpression mexpression) {
        this.checkThreadAccess();
        this.expressionbase.deregisterExpression(mexpression);
    }

    public void deregisterExpressionReference(IMExpressionReference mexpressionref) {
        this.checkThreadAccess();
        this.expressionbase.deregisterExpressionReference(mexpressionref);
    }

    public void deregisterCondition(IMCondition mcondition) {
        this.checkThreadAccess();
        this.expressionbase.deregisterExpression(mcondition);
    }

    public void deregisterConditionReference(IMConditionReference mconditionref) {
        this.checkThreadAccess();
        this.expressionbase.deregisterConditionReference(mconditionref);
    }

    public void addConditionListener(String type, IConditionListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"condition_triggered"}, type);
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, this.expressionbase, type}));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeConditionListener(String type, IConditionListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(new Object[]{userlistener, this.expressionbase, type});
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

