/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMEvent;
import jadex.model.IMEventReference;
import jadex.runtime.IEvent;
import jadex.runtime.IEventbase;
import jadex.runtime.IFilter;
import jadex.runtime.IInternalEvent;
import jadex.runtime.IInternalEventListener;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IMessageEventListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.IRInternalEvent;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.REventbase;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.runtime.planwrapper.EventWrapper;
import jadex.runtime.planwrapper.GoalEventWrapper;
import jadex.runtime.planwrapper.InternalEventWrapper;
import jadex.runtime.planwrapper.MessageEventWrapper;
import jadex.util.Tuple;

public class EventbaseWrapper
extends ElementWrapper
implements IEventbase {
    protected REventbase eventbase;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected EventbaseWrapper(REventbase eventbase, RPlan plan) {
        super(eventbase, plan);
        this.eventbase = eventbase;
    }

    public IFilter sendMessage(IMessageEvent me) {
        this.checkThreadAccess();
        return this.eventbase.sendMessage((IRMessageEvent)((EventWrapper)((Object)me)).unwrap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchInternalEvent(IInternalEvent event) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.eventbase.dispatchInternalEvent((IRInternalEvent)((ElementWrapper)((Object)event)).unwrap());
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public IMessageEvent createMessageEvent(String type) {
        this.checkThreadAccess();
        return new MessageEventWrapper(this.eventbase.createMessageEvent(type), this.getPlan());
    }

    public IInternalEvent createInternalEvent(String type) {
        this.checkThreadAccess();
        return new InternalEventWrapper(this.eventbase.createInternalEvent(type), this.getPlan());
    }

    public IInternalEvent createInternalEvent(String type, Object content) {
        this.checkThreadAccess();
        return new InternalEventWrapper(this.eventbase.createInternalEvent(type, content), this.getPlan());
    }

    public void registerEvent(IMEvent mevent) {
        this.checkThreadAccess();
        this.eventbase.registerEvent(mevent);
    }

    public void registerEventReference(IMEventReference meventref) {
        this.checkThreadAccess();
        this.eventbase.registerEventReference(meventref);
    }

    public void deregisterEvent(IMEvent mevent) {
        this.checkThreadAccess();
        this.eventbase.deregisterEvent(mevent);
    }

    public void deregisterEventReference(IMEventReference meventref) {
        this.checkThreadAccess();
        this.eventbase.deregisterEventReference(meventref);
    }

    public void addInternalEventListener(String type, IInternalEventListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"internalevent_occurred"}, type);
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, this.eventbase, type, IInternalEventListener.class}));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeInternalEventListener(String type, IInternalEventListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(new Object[]{userlistener, this.eventbase, type, IInternalEventListener.class});
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }

    public void addMessageEventListener(String type, IMessageEventListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"message_received", "message_sent"}, type);
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, this.eventbase, type, IMessageEventListener.class}));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeMessageEventListener(String type, IMessageEventListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(new Object[]{userlistener, this.eventbase, type, IInternalEventListener.class});
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }

    public static IEvent wrap(IREvent event, RPlan plan) {
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError((Object)plan.getName());
        }
        EventWrapper ret = event instanceof IRInternalEvent ? new InternalEventWrapper((IRInternalEvent)event, plan) : (event instanceof IRMessageEvent ? new MessageEventWrapper((IRMessageEvent)event, plan) : new GoalEventWrapper((IRGoalEvent)event, plan));
        return ret;
    }

    static {
        $assertionsDisabled = !EventbaseWrapper.class.desiredAssertionStatus();
    }
}

