/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMElement;
import jadex.runtime.impl.IRElement;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import java.io.Serializable;
import java.util.Map;

public class ElementWrapper
implements Serializable {
    private IRElement element;
    private RPlan plan;
    private Map listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ElementWrapper(IRElement element, RPlan plan) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError((Object)plan.getName());
        }
        this.element = element;
        this.plan = plan;
    }

    public String getName() {
        this.checkThreadAccess();
        return this.element.getName();
    }

    public IMElement getModelElement() {
        this.checkThreadAccess();
        return this.element.getModelElement();
    }

    public IRElement unwrap() {
        return this.element;
    }

    protected RPlan getPlan() {
        return this.plan;
    }

    protected RCapability getCapability() {
        return this.element.getScope();
    }

    protected RBDIAgent getAgent() {
        return this.element.getScope().getAgent();
    }

    public boolean equals(Object o) {
        if (o instanceof ElementWrapper) {
            o = ((ElementWrapper)o).unwrap();
        }
        return this.element.equals(o);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        return this.element.toString();
    }

    public boolean checkThreadAccess0() {
        return this.plan.getThread() == Thread.currentThread();
    }

    public void checkThreadAccess() {
        if (!this.checkThreadAccess0()) {
            throw new RuntimeException("Wrong thread calling plan interface. Only the plan thread is allowed to call methods on the plan directly. Other threads, e.g. GUI listeners, need to use the external access interface: " + Thread.currentThread());
        }
    }

    static {
        $assertionsDisabled = !ElementWrapper.class.desiredAssertionStatus();
    }
}

