/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.ICondition;
import jadex.runtime.IConditionListener;
import jadex.runtime.IFilter;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ExpressionWrapper;
import jadex.util.Tuple;

public class ConditionWrapper
extends ExpressionWrapper
implements ICondition {
    protected IRCondition condition;

    protected ConditionWrapper(IRCondition condition, RPlan plan) {
        super(condition, plan);
        this.condition = condition;
    }

    public String getTraceMode() {
        this.checkThreadAccess();
        return this.condition.getTraceMode();
    }

    public void setTraceMode(String trace) {
        this.checkThreadAccess();
        this.condition.setTraceMode(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceOnce() {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.condition.traceOnce();
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceAlways() {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.condition.traceAlways();
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public IFilter getFilter() {
        this.checkThreadAccess();
        return this.condition.getFilter();
    }

    public IRCondition getOriginalCondition() {
        return this.condition;
    }

    public void addConditionListener(IConditionListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"condition_triggered"}, this.unwrap());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.condition));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeConditionListener(IConditionListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.condition);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

