/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMCapabilityReference;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.IAgentListener;
import jadex.runtime.IBeliefbase;
import jadex.runtime.ICapability;
import jadex.runtime.IEventbase;
import jadex.runtime.IExpressionbase;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoalbase;
import jadex.runtime.IPlanbase;
import jadex.runtime.IPropertybase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.BeliefbaseWrapper;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.runtime.planwrapper.EventbaseWrapper;
import jadex.runtime.planwrapper.ExpressionbaseWrapper;
import jadex.runtime.planwrapper.GoalbaseWrapper;
import jadex.runtime.planwrapper.PlanbaseWrapper;
import jadex.runtime.planwrapper.PropertybaseWrapper;
import jadex.util.Tuple;
import java.util.logging.Logger;

public class CapabilityWrapper
extends ElementWrapper
implements ICapability {
    protected RCapability cap;
    protected BeliefbaseWrapper beliefbase;
    protected GoalbaseWrapper goalbase;
    protected PlanbaseWrapper planbase;
    protected EventbaseWrapper eventbase;
    protected ExpressionbaseWrapper expressionbase;
    protected PropertybaseWrapper propertybase;

    public CapabilityWrapper(RCapability cap, RPlan plan) {
        super(cap, plan);
        this.cap = cap;
    }

    public IExternalAccess getExternalAccess() {
        return this.cap.getExternalAccess();
    }

    public Logger getLogger() {
        return this.cap.getLogger();
    }

    public IBeliefbase getBeliefbase() {
        this.checkThreadAccess();
        return this.beliefbase != null ? this.beliefbase : (this.beliefbase = new BeliefbaseWrapper(this.cap.getBeliefbase(), this.getPlan()));
    }

    public IGoalbase getGoalbase() {
        this.checkThreadAccess();
        return this.goalbase != null ? this.goalbase : (this.goalbase = new GoalbaseWrapper(this.cap.getGoalbase(), this.getPlan()));
    }

    public IPlanbase getPlanbase() {
        this.checkThreadAccess();
        return this.planbase != null ? this.planbase : (this.planbase = new PlanbaseWrapper(this.cap.getPlanbase(), this.getPlan()));
    }

    public IEventbase getEventbase() {
        this.checkThreadAccess();
        return this.eventbase != null ? this.eventbase : (this.eventbase = new EventbaseWrapper(this.cap.getEventbase(), this.getPlan()));
    }

    public IExpressionbase getExpressionbase() {
        this.checkThreadAccess();
        return this.expressionbase != null ? this.expressionbase : (this.expressionbase = new ExpressionbaseWrapper(this.cap.getExpressionbase(), this.getPlan()));
    }

    public IPropertybase getPropertybase() {
        this.checkThreadAccess();
        return this.propertybase != null ? this.propertybase : (this.propertybase = new PropertybaseWrapper(this.cap.getPropertybase(), this.getPlan()));
    }

    public String getAgentName() {
        this.checkThreadAccess();
        return this.cap.getAgentName();
    }

    public String getInitialStateName() {
        this.checkThreadAccess();
        return this.cap.getInitialStateName();
    }

    public BasicAgentIdentifier getAgentIdentifier() {
        this.checkThreadAccess();
        return this.cap.getAgent().getAgentIdentifier();
    }

    public Object getPlatformAgent() {
        this.checkThreadAccess();
        return this.cap.getPlatformAgent();
    }

    public String getPlatformType() {
        this.checkThreadAccess();
        return this.cap.getAgent().getPlatformType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubcapability(String name, String capafile) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.cap.addSubcapability(name, capafile);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubcapability(String name) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.cap.removeSubcapability(name);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubcapability(IMCapabilityReference subcap) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.cap.registerSubcapability(subcap);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubcapability(IMCapabilityReference subcap) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.cap.deregisterSubcapability(subcap);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAgent() {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.cap.getAgent().getInterpreter().killAgent();
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public void addAgentListener(IAgentListener userlistener, boolean async) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"agentDied"}, this.unwrap());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.cap));
        this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeAgentListener(IAgentListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.cap);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

