/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMBeliefSet;
import jadex.model.IMBeliefSetReference;
import jadex.runtime.IBelief;
import jadex.runtime.IBeliefSet;
import jadex.runtime.IBeliefbase;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.RBeliefbase;
import jadex.runtime.impl.RPlan;
import jadex.runtime.planwrapper.BeliefSetWrapper;
import jadex.runtime.planwrapper.BeliefWrapper;
import jadex.runtime.planwrapper.ElementWrapper;
import java.util.Map;
import java.util.WeakHashMap;

public class BeliefbaseWrapper
extends ElementWrapper
implements IBeliefbase {
    protected RBeliefbase beliefbase;
    protected transient Map wrappers;

    protected BeliefbaseWrapper(RBeliefbase beliefbase, RPlan plan) {
        super(beliefbase, plan);
        this.beliefbase = beliefbase;
    }

    public IBelief getBelief(String name) {
        IBelief belief;
        this.checkThreadAccess();
        IRBelief rbelief = this.beliefbase.getBelief(name);
        if (this.wrappers == null) {
            this.wrappers = new WeakHashMap();
        }
        if ((belief = (IBelief)this.wrappers.get(rbelief)) == null) {
            belief = new BeliefWrapper(rbelief, this.getPlan());
            this.wrappers.put(rbelief, belief);
        }
        return belief;
    }

    public IBeliefSet getBeliefSet(String name) {
        IBeliefSet beliefset;
        this.checkThreadAccess();
        IRBeliefSet rbeliefset = this.beliefbase.getBeliefSet(name);
        if (this.wrappers == null) {
            this.wrappers = new WeakHashMap();
        }
        if ((beliefset = (IBeliefSet)this.wrappers.get(rbeliefset)) == null) {
            beliefset = new BeliefSetWrapper(rbeliefset, this.getPlan());
            this.wrappers.put(rbeliefset, beliefset);
        }
        return beliefset;
    }

    public boolean containsBelief(String name) {
        this.checkThreadAccess();
        return this.beliefbase.containsBelief(name);
    }

    public boolean containsBeliefSet(String name) {
        this.checkThreadAccess();
        return this.beliefbase.containsBeliefSet(name);
    }

    public String[] getBeliefNames() {
        this.checkThreadAccess();
        return this.beliefbase.getBeliefNames();
    }

    public String[] getBeliefSetNames() {
        this.checkThreadAccess();
        return this.beliefbase.getBeliefSetNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBelief(String key, Class clazz, int update) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.createBelief(key, clazz, update);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBeliefSet(String key, Class clazz, int update) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.createBeliefSet(key, clazz, update);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBelief(String key) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.deleteBelief(key);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBeliefSet(String key) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.deleteBeliefSet(key);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBelief(IMBelief mbelief) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.registerBelief(mbelief);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeliefSet(IMBeliefSet mbeliefset) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.registerBeliefSet(mbeliefset);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeliefReference(IMBeliefReference mbeliefref) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.registerBeliefReference(mbeliefref);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeliefSetReference(IMBeliefSetReference mbeliefsetref) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.registerBeliefSetReference(mbeliefsetref);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterBelief(IMBelief mbelief) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.deregisterBelief(mbelief);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterBeliefSet(IMBeliefSet mbeliefset) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.deregisterBeliefSet(mbeliefset);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterBeliefReference(IMBeliefReference mbeliefref) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.deregisterBeliefReference(mbeliefref);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterBeliefSetReference(IMBeliefSetReference mbeliefsetref) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefbase.deregisterBeliefSetReference(mbeliefsetref);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }
}

