/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IBelief;
import jadex.runtime.IBeliefListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.util.Tuple;

public class BeliefWrapper
extends ElementWrapper
implements IBelief {
    protected IRBelief belief;

    protected BeliefWrapper(IRBelief belief, RPlan plan) {
        super(belief, plan);
        this.belief = belief;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFact(Object fact) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.belief.setFact(fact);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public Object getFact() {
        this.checkThreadAccess();
        return this.belief.getFact();
    }

    public void modified() {
        this.checkThreadAccess();
        this.belief.getOriginalElement().throwSystemEvent("BDI_factChanged");
    }

    public Class getClazz() {
        this.checkThreadAccess();
        return this.belief.getClazz();
    }

    public boolean isAccessible() {
        this.checkThreadAccess();
        return this.belief.isAccessible();
    }

    public void addBeliefListener(IBeliefListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_factChanged"}, this.unwrap());
        WaitAbstraction wa = new WaitAbstraction(this.getCapability());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.belief));
        this.getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeBeliefListener(IBeliefListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.belief);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

