/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.planwrapper;

import jadex.runtime.IBeliefSet;
import jadex.runtime.IBeliefSetListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.ElementWrapper;
import jadex.util.Tuple;

public class BeliefSetWrapper
extends ElementWrapper
implements IBeliefSet {
    protected IRBeliefSet beliefset;

    protected BeliefSetWrapper(IRBeliefSet beliefset, RPlan plan) {
        super(beliefset, plan);
        this.beliefset = beliefset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFact(Object fact) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefset.addFact(fact);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFact(Object fact) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefset.removeFact(fact);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFacts(Object[] facts) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefset.addFacts(facts);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFacts() {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefset.removeFacts();
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public Object getFact(Object oldval) {
        this.checkThreadAccess();
        Object value = this.beliefset.getFact(oldval);
        return value;
    }

    public boolean containsFact(Object fact) {
        this.checkThreadAccess();
        return this.beliefset.containsFact(fact);
    }

    public Object[] getFacts() {
        this.checkThreadAccess();
        Object[] facts = this.beliefset.getFacts();
        return facts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFact(Object newfact) {
        this.checkThreadAccess();
        this.getPlan().startMonitorConsequences();
        try {
            this.beliefset.updateFact(newfact);
        }
        finally {
            this.getPlan().endMonitorConsequences();
        }
    }

    public int size() {
        this.checkThreadAccess();
        return this.beliefset.size();
    }

    public Class getClazz() {
        this.checkThreadAccess();
        return this.beliefset.getClazz();
    }

    public void modified() {
        this.checkThreadAccess();
        this.beliefset.getOriginalElement().throwSystemEvent("BDI_bsfactsChanged");
    }

    public boolean isAccessible() {
        this.checkThreadAccess();
        return this.beliefset.isAccessible();
    }

    public void addBeliefSetListener(IBeliefSetListener userlistener, boolean async) {
        this.checkThreadAccess();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved", "BDI_bsfactsChanged"});
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this.beliefset));
        this.getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removeBeliefSetListener(IBeliefSetListener userlistener) {
        this.checkThreadAccess();
        Tuple identifier = new Tuple(userlistener, this.beliefset);
        ISystemEventListener[] listeners = this.getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

