/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.treeimpl;

import jadex.runtime.impl.IEncodable;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaEntry;
import jadex.runtime.impl.agenda.treeimpl.TreeAgenda;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeAgendaEntry
implements IEncodable,
Serializable,
IAgendaEntry {
    protected IAgendaAction action;
    protected TreeAgenda agenda;
    protected Object cause;
    protected boolean processed;
    protected boolean executed;
    protected List children;
    protected TreeAgendaEntry parent;
    List cs;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected TreeAgendaEntry(IAgendaAction action, TreeAgenda agenda, Object cause) {
        this.action = action;
        this.agenda = agenda;
        this.cause = cause;
    }

    public void execute() {
        if (this.action.isValid()) {
            this.action.execute();
            this.executed = true;
        }
    }

    public IAgendaAction getAction() {
        return this.action;
    }

    public Object getCause() {
        return this.cause;
    }

    protected void setProcessed(boolean processed) {
        if (!$assertionsDisabled && !processed) {
            throw new AssertionError();
        }
        this.processed = processed;
    }

    protected boolean isExecuted() {
        return this.executed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public boolean isCompleted() {
        boolean ret = this.isProcessed();
        if (this.children != null) {
            for (int i = 0; i < this.children.size() && ret; ++i) {
                ret = ((TreeAgendaEntry)this.children.get(i)).isCompleted();
            }
        }
        return ret;
    }

    protected void addChild(TreeAgendaEntry entry) {
        if (this.children == null) {
            this.children = SCollection.createArrayList();
        }
        this.children.add(entry);
    }

    public void removeChild(TreeAgendaEntry entry) {
        if (this.children != null) {
            this.children.remove(entry);
        }
    }

    protected void setParent(TreeAgendaEntry parent) {
        this.parent = parent;
    }

    public TreeAgendaEntry getParent() {
        return this.parent;
    }

    public List getExecutableEntries() {
        List<Object> ret;
        if (this.children != null) {
            ret = SCollection.createArrayList();
            if (this.cs == null) {
                this.cs = SCollection.createArrayList();
            } else {
                this.cs.clear();
            }
            this.cs.add(this.children);
            for (int i = 0; i < this.cs.size(); ++i) {
                List list = (List)this.cs.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    TreeAgendaEntry tmp = (TreeAgendaEntry)list.get(j);
                    if (!tmp.isProcessed()) {
                        ret.add(tmp);
                    }
                    if (tmp.children == null) continue;
                    this.cs.add(tmp.children);
                }
            }
        } else {
            ret = !this.isProcessed() ? Collections.singletonList(this) : Collections.EMPTY_LIST;
        }
        return ret;
    }

    public TreeAgendaEntry getNextExecutableEntry() {
        TreeAgendaEntry ret;
        TreeAgendaEntry treeAgendaEntry = ret = !this.isProcessed() ? this : null;
        if (ret == null && this.children != null) {
            if (this.cs == null) {
                this.cs = SCollection.createArrayList();
            } else {
                this.cs.clear();
            }
            this.cs.add(this.children);
            for (int i = 0; ret == null && i < this.cs.size(); ++i) {
                List list = (List)this.cs.get(i);
                for (int j = 0; ret == null && j < list.size(); ++j) {
                    TreeAgendaEntry tmp = (TreeAgendaEntry)list.get(j);
                    if (!tmp.isProcessed()) {
                        ret = tmp;
                        continue;
                    }
                    if (tmp.children == null) continue;
                    this.cs.add(tmp.children);
                }
            }
        }
        return ret;
    }

    public TreeAgendaEntry getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public List getChildren() {
        if (this.children != null) {
            return Collections.unmodifiableList(this.children);
        }
        return Collections.EMPTY_LIST;
    }

    public List getAllChildren() {
        List ret;
        if (this.children != null) {
            ret = SCollection.createArrayList();
            ret.addAll(this.children);
            for (int i = 0; i < this.children.size(); ++i) {
                ret.addAll(((TreeAgendaEntry)this.children.get(i)).getAllChildren());
            }
        } else {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    public String toString() {
        return "" + this.getAction();
    }

    public Map getEncodableRepresentation() {
        HashMap rep = SCollection.createHashMap();
        rep.put("isencodeablepresentation", "true");
        if (this.getAction() instanceof IEncodable) {
            rep.put("action", ((IEncodable)((Object)this.getAction())).getEncodableRepresentation());
        }
        rep.put("hashcode", "" + this.hashCode());
        rep.put("processed", "" + this.isProcessed());
        rep.put("executed", "" + this.isExecuted());
        rep.put("valid", "" + this.action.isValid());
        rep.put("actionclass", SReflect.getInnerClassName(this.getAction().getClass()));
        rep.put("text", "" + this.getAction());
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                rep.put("" + i, ((TreeAgendaEntry)this.children.get(i)).getEncodableRepresentation());
            }
        }
        return rep;
    }

    static {
        $assertionsDisabled = !TreeAgendaEntry.class.desiredAssertionStatus();
    }
}

