/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.treeimpl;

import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RMetaGoal;
import jadex.runtime.impl.agenda.IAgenda;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaEntry;
import jadex.runtime.impl.agenda.plans.ExecutePlanStepAction;
import jadex.runtime.impl.agenda.treeimpl.TreeAgendaEntry;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeAgenda
implements IAgenda,
Serializable {
    protected RBDIAgent agent;
    protected List entries;
    protected final List ext_entries;
    protected int state;
    protected TreeAgendaEntry current;
    protected boolean keep_processed_entries;
    protected long max_time = 20000L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TreeAgenda(RBDIAgent agent) {
        this.agent = agent;
        this.entries = SCollection.createLinkedList();
        this.ext_entries = SCollection.createVector();
    }

    public boolean isEmpty() {
        boolean empty;
        boolean bl = empty = this.entries.isEmpty() && this.ext_entries.isEmpty();
        if (!empty) {
            int i;
            empty = true;
            for (i = 0; empty && i < this.ext_entries.size(); ++i) {
                empty = !((IAgendaAction)this.ext_entries.get(i)).isValid();
            }
            for (i = 0; empty && i < this.entries.size(); ++i) {
                empty = ((TreeAgendaEntry)this.entries.get(i)).getNextExecutableEntry() == null;
            }
        }
        return empty;
    }

    public int size() {
        return this.entries.isEmpty() && this.ext_entries.isEmpty() ? 0 : this.getUnprocessedEntries().size();
    }

    public IAgendaEntry executeAction() {
        if (!$assertionsDisabled && this.current != null) {
            throw new AssertionError();
        }
        this.copyExternalEntries();
        TreeAgendaEntry ae = this.select();
        if (ae != null) {
            this.current = ae;
            ae.execute();
            this.processed();
        }
        return ae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyExternalEntries() {
        List list = this.ext_entries;
        synchronized (list) {
            while (this.ext_entries.size() > 0) {
                this.add((IAgendaAction)this.ext_entries.get(0), null);
                this.ext_entries.remove(0);
            }
        }
    }

    public TreeAgendaEntry select() {
        TreeAgendaEntry ret = null;
        for (int i = 0; i < this.entries.size() && ret == null; ++i) {
            TreeAgendaEntry tmp = (TreeAgendaEntry)this.entries.get(i);
            ret = tmp.getNextExecutableEntry();
        }
        return ret;
    }

    protected void processed() {
        if (!$assertionsDisabled && this.current == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.current.isProcessed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.entries.contains(this.current.getRoot())) {
            throw new AssertionError();
        }
        this.current.setProcessed(true);
        TreeAgendaEntry root = this.current.getRoot();
        if (root.isCompleted() && !this.keep_processed_entries) {
            this.entries.remove(root);
        }
        this.current = null;
    }

    protected void add(TreeAgendaEntry entry) {
        if (!$assertionsDisabled && this.contains(entry)) {
            throw new AssertionError();
        }
        if (this.current != null && (!(entry.getAction() instanceof ExecutePlanStepAction) || ((ExecutePlanStepAction)entry.getAction()).getPlan().getRootGoal().getProprietaryGoal() instanceof RMetaGoal)) {
            this.current.addChild(entry);
            entry.setParent(this.current);
        } else {
            this.entries.add(entry);
        }
        ++this.state;
        if (!this.agent.getLifecycleState().equals("creating") && !this.agent.getLifecycleState().equals("terminated")) {
            this.agent.getAgentAdapter().wakeup();
        }
    }

    public void add(IAgendaAction action, Object cause) {
        this.add(new TreeAgendaEntry(action, this, cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternal(IAgendaAction action) {
        List list = this.ext_entries;
        synchronized (list) {
            this.ext_entries.add(action);
        }
        this.agent.getAgentAdapter().wakeup();
    }

    public int getState() {
        return this.state;
    }

    public List getUnprocessedEntries() {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.entries.size(); ++i) {
            ret.addAll(((TreeAgendaEntry)this.entries.get(i)).getExecutableEntries());
        }
        if (this.current != null) {
            ret.remove(this.current);
        }
        return ret;
    }

    protected List asList() {
        ArrayList ret = SCollection.createArrayList();
        ret.addAll(this.entries);
        for (int i = 0; i < this.entries.size(); ++i) {
            ret.addAll(((TreeAgendaEntry)this.entries.get(i)).getAllChildren());
        }
        return ret;
    }

    protected boolean contains(TreeAgendaEntry entry) {
        boolean ret = this.entries.contains(entry);
        for (int i = 0; i < this.entries.size() && !ret; ++i) {
            TreeAgendaEntry tmp = (TreeAgendaEntry)this.entries.get(i);
            ret = tmp.getAllChildren().contains(entry);
        }
        return ret;
    }

    public IAgendaEntry getCurrentEntry() {
        return this.current;
    }

    public List getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    protected RBDIAgent getAgent() {
        return this.agent;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + "(current=" + this.current + ", unprocessed=" + this.getUnprocessedEntries() + ")";
    }

    static {
        $assertionsDisabled = !TreeAgenda.class.desiredAssertionStatus();
    }
}

