/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.plans;

import jadex.model.IMCapability;
import jadex.model.IMInternalEvent;
import jadex.model.IMPlan;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.PlanInfo;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RInternalEvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.agenda.BindingAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.util.SReflect;

public class PlanCreationAction
extends BindingAction {
    protected RPlanbase planbase;
    protected IMPlan plan;

    public PlanCreationAction(RPlanbase planbase, IAgendaActionPrecondition precond, IMPlan plan) {
        super(precond);
        this.planbase = planbase;
        this.plan = plan;
    }

    public void execute() {
        RCapability scope = this.planbase.getScope();
        IMInternalEvent mevent = ((IMCapability)scope.getModelElement()).getEventbase().getInternalEvent("InternalEvent_execute_plan");
        RInternalEvent event = scope.getEventbase().createInternalEvent(mevent);
        PlanInfo cand = new PlanInfo(null, event, this.plan, this.getBinding());
        event.getParameter("candidate").setValue(cand);
        if (this.planbase.checkPlanApplicability(cand, event, null)) {
            RPlan rplan = RPlanbase.scheduleCandidate(cand);
            Object cause = scope.getAgent().getInterpreter().getCurrentAgendaEntry().getCause();
            if (cause instanceof SystemEvent) {
                SystemEvent se = (SystemEvent)cause;
                if (se.getType().equals("BDI_bsfactAdded")) {
                    rplan.setExpressionParameter("$addedfact", cause);
                } else if (se.getType().equals("BDI_bsfactRemoved")) {
                    rplan.setExpressionParameter("$removedfact", cause);
                }
            }
        }
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " (plan=" + this.plan.getName() + ")";
    }
}

