/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.eventprocessing;

import jadex.model.IMMetaGoal;
import jadex.runtime.ICandidateInfo;
import jadex.runtime.impl.CandidateInfo;
import jadex.runtime.impl.DefaultMetaLevelReasoner;
import jadex.runtime.impl.GoalCreator;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RGoalEvent;
import jadex.runtime.impl.RMetaGoal;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.agenda.AbstractElementAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.eventprocessing.FindApplicableCandidatesAction;
import jadex.runtime.impl.agenda.eventprocessing.ScheduleCandidatesAction;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ProcessEventAction
extends AbstractElementAgendaAction
implements Serializable {
    protected RBDIAgent agent;
    protected IREvent event;
    protected DefaultMetaLevelReasoner reasoner;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProcessEventAction(IAgendaActionPrecondition precond, RBDIAgent agent, IREvent event) {
        super(event, precond);
        this.agent = agent;
        this.event = event;
        this.reasoner = DefaultMetaLevelReasoner.getInstance();
    }

    public void execute() {
        if (this.event instanceof RGoalEvent && ((RGoalEvent)this.event).isInfo() && ((RGoalEvent)this.event).getGoal() instanceof RMetaGoal) {
            List candidates;
            IRGoal goal = ((RGoalEvent)this.event).getGoal();
            this.event = ((CandidateInfo)goal.getParameterSet("applicables").getValues()[0]).getEventInstance();
            if (goal.isSucceeded()) {
                ICandidateInfo[] cs = (ICandidateInfo[])goal.getParameterSet("result").getValues();
                if (cs.length == 0) {
                    this.agent.getLogger().severe("Meta-level reasoning did not return a non-empty candidate list: " + SUtil.arrayToString(cs));
                }
                candidates = SUtil.arrayToList(cs);
            } else {
                String msg = "";
                Exception ex = goal.getException();
                if (ex != null) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    msg = "\n" + sw.toString();
                }
                this.agent.getLogger().log(Level.SEVERE, " meta goal failed: " + this.agent.getName() + " " + goal + " " + this.event + msg);
                candidates = SCollection.createArrayList();
                Object[] cands = goal.getParameterSet("applicables").getValues();
                for (int i = 0; i < cands.length; ++i) {
                    candidates.add(cands[i]);
                }
                candidates = this.reasoner.reason(this.event, candidates);
            }
            this.agent.getInterpreter().addAgendaEntry(new ScheduleCandidatesAction(this.getPrecondition(), this.agent, this.event, candidates), this);
        } else if (this.agent.getInterpreter().getExecutionMode().equals("step")) {
            this.agent.getInterpreter().addAgendaEntry(new FindApplicableCandidatesAction(this.getPrecondition(), this.agent, this.event), this);
        } else {
            List applicables = this.event.getApplicableCandidatesList().getCandidates();
            if (applicables.size() != 0) {
                boolean ml = false;
                if (applicables.size() > 1) {
                    ml = this.initiateMetaLevelReasoning(this.event, applicables);
                }
                if (!ml) {
                    List candidates = this.selectCandidates(this.event, applicables);
                    this.scheduleCandidates(this.event, candidates);
                }
            } else {
                this.eventNotHandled(this.event);
            }
        }
    }

    public IREvent getEvent() {
        return this.event;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + "( event=" + (this.event == null ? "null" : this.event.getName()) + ")";
    }

    protected boolean initiateMetaLevelReasoning(IREvent event, List applicables) {
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && applicables == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && applicables.size() <= 1) {
            throw new AssertionError();
        }
        IMMetaGoal metagoal = null;
        List occs = event.getAllOccurrences();
        for (int i = 0; i < occs.size(); ++i) {
            IREvent occ = (IREvent)occs.get(i);
            IMMetaGoal metagoal2 = occ.getScope().getGoalbase().getMetaGoals(occ);
            if (metagoal != null && metagoal2 != null) {
                throw new RuntimeException("Multiple meta goals matching event: " + event + ", " + metagoal + ", " + metagoal2);
            }
            if (metagoal2 == null) continue;
            metagoal = metagoal2;
        }
        if (metagoal != null) {
            RReferenceableElement orig = event.getOriginalElement();
            RCapability scope = orig.getScope();
            IRGoal mlgoal = (IRGoal)((Object)scope.getEventbase().createElementStructure(orig, new GoalCreator(scope.getGoalbase(), metagoal)));
            for (int i = 0; i < applicables.size(); ++i) {
                mlgoal.getParameterSet("applicables").addValue(applicables.get(i));
            }
            scope.getGoalbase().dispatchTopLevelGoal(mlgoal);
        }
        return metagoal != null;
    }

    protected List selectCandidates(IREvent event, List list) {
        return this.reasoner.reason(event, list);
    }

    protected void scheduleCandidates(IREvent event, List candidates) {
        ArrayList procgoals = SCollection.createArrayList();
        for (int i = 0; i < candidates.size(); ++i) {
            CandidateInfo cand = (CandidateInfo)candidates.get(i);
            this.agent.getPlanbase();
            procgoals.add(RPlanbase.scheduleCandidate(cand).getRootGoal());
        }
        if (event instanceof RGoalEvent && !((IRGoalEvent)event).isInfo()) {
            ((RGoal)((IRGoalEvent)event).getGoal().getOriginalElement()).processGoalsCreated(procgoals);
        }
    }

    protected void eventNotHandled(IREvent event) {
        boolean warn = true;
        if (event instanceof IRGoalEvent) {
            IRGoalEvent ge = (IRGoalEvent)event;
            if (ge.isInfo() && ge.getGoal().isSucceeded() && !ge.getGoal().isSubgoal()) {
                warn = false;
            }
            if (ge.isInfo() && this.agent.isCleanedup()) {
                warn = false;
            } else if (!ge.isInfo() && ge.getGoal().wasProcessed()) {
                warn = false;
            }
        }
        if (event instanceof RGoalEvent && !((IRGoalEvent)event).isInfo()) {
            ((RGoal)((IRGoalEvent)event).getGoal().getOriginalElement()).processGoalsCreated(SCollection.createArrayList());
        }
        if (warn) {
            this.agent.getLogger().warning("Event not handled: " + this.agent.getName() + " " + event);
        }
        event.cleanup();
    }

    static {
        $assertionsDisabled = !ProcessEventAction.class.desiredAssertionStatus();
    }
}

