/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.easydeliberation;

import jadex.model.IMDeliberation;
import jadex.model.IMElement;
import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.model.IMInhibits;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RExpression;
import jadex.util.Tuple;
import jadex.util.collection.SCollection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;

public class SEasyDeliberation {
    protected static final Map lookup = SCollection.createWeakHashMap();

    public static boolean inhibits(IRGoal source, IRGoal target, boolean when_active, boolean when_process) {
        Tuple inhibition;
        boolean inhibits = false;
        if (source != target && (inhibition = SEasyDeliberation.getInhibition(source, target)) != null) {
            String when = (String)inhibition.get(0);
            boolean bl = inhibits = when_active && when.equals("when_active") || when_process && when.equals("when_in_process");
            if (inhibits && inhibition.get(1) != null) {
                try {
                    RExpression exp = (RExpression)inhibition.get(1);
                    exp.setExpressionParameter("$ref", target);
                    inhibits = (Boolean)exp.getValue();
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    source.getScope().getLogger().severe("Inhibition expression threw exception: " + inhibition.get(1) + "\n" + sw);
                }
            }
        }
        return inhibits;
    }

    protected static Tuple getInhibition(IRGoal source, IRGoal target) {
        Map inhibitions = (Map)lookup.get(source);
        if (inhibitions == null) {
            IMElement goal = source.getModelElement();
            IMDeliberation deliberation = null;
            if (goal instanceof IMGoal) {
                deliberation = ((IMGoal)goal).getDeliberation();
            } else if (goal instanceof IMGoalReference) {
                deliberation = ((IMGoalReference)goal).getDeliberation();
            }
            if (deliberation != null) {
                inhibitions = SCollection.createHashMap();
                IMInhibits[] inhibits = deliberation.getInhibits();
                for (int i = 0; i < inhibits.length; ++i) {
                    RExpression exp = null;
                    if (inhibits[i].getInhibitingExpression() != null) {
                        exp = source.getScope().getExpressionbase().createInternalExpression(inhibits[i].getInhibitingExpression(), (RElement)((Object)source), null);
                    }
                    inhibitions.put(inhibits[i].getInhibitedGoal(), new Tuple(inhibits[i].getInhibit(), exp));
                }
            } else {
                inhibitions = Collections.EMPTY_MAP;
            }
            lookup.put(source, inhibitions);
        }
        return (Tuple)inhibitions.get(target.getModelElement());
    }
}

