/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.easydeliberation;

import jadex.model.IMDeliberation;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RElementReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.agenda.AbstractAgendaAction;
import jadex.runtime.impl.agenda.ComposedPrecondition;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.easydeliberation.DeliberateGoalActivationAction;
import jadex.runtime.impl.agenda.easydeliberation.SEasyDeliberation;
import jadex.runtime.impl.agenda.goals.GoalLifecycleStatePrecondition;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DeliberateInhibitedGoalsReactivationAction
extends AbstractAgendaAction
implements Serializable {
    public static long timer;
    protected IRGoal goal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DeliberateInhibitedGoalsReactivationAction(IAgendaActionPrecondition precond, final IRGoal goal) {
        super(new ComposedPrecondition(new IAgendaActionPrecondition(){

            public boolean check() {
                return !goal.getScope().getAgent().isCleanedup();
            }
        }, precond));
        this.goal = goal;
    }

    public void execute() {
        long starttime = System.currentTimeMillis();
        if (!($assertionsDisabled || this.goal.getLifecycleState().equals("suspended") || this.goal.getLifecycleState().equals("dropped") || this.goal.getLifecycleState().equals("active") && !this.goal.isInProcess())) {
            throw new AssertionError((Object)(this.goal.getName() + ", " + this.goal.getLifecycleState()));
        }
        HashSet options = SCollection.createHashSet();
        this.computeReactivatableOptions(this.goal, null, options);
        Iterator it = options.iterator();
        while (it.hasNext()) {
            IRGoal tmp = (IRGoal)it.next();
            tmp.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateGoalActivationAction(new GoalLifecycleStatePrecondition(tmp, "option"), tmp), this.goal);
        }
        timer += System.currentTimeMillis() - starttime;
    }

    protected void computeReactivatableOptions(IRGoal goal, IRGoal source, Set options) {
        RReferenceableElement reffed;
        int i;
        if (!$assertionsDisabled && goal.isInProcess()) {
            throw new AssertionError((Object)goal.getName());
        }
        IMDeliberation delib = goal.getDeliberationInfo();
        if (delib != null) {
            if (delib.getCardinality() != -1) {
                IRGoal[] siblings = goal.getScope().getGoalbase().getOptions(goal.getType());
                for (i = 0; i < siblings.length; ++i) {
                    options.add(siblings[i]);
                }
            }
            IRGoal[] goals = goal.getScope().getGoalbase().getOptions();
            for (i = 0; i < goals.length; ++i) {
                if (!SEasyDeliberation.inhibits(goal, goals[i], !goal.isActive(), true)) continue;
                options.add(goals[i]);
            }
        }
        List refs = ((RReferenceableElement)((Object)goal)).getReferences();
        for (i = 0; i < refs.size(); ++i) {
            if (refs.get(i) == source) continue;
            this.computeReactivatableOptions((IRGoal)refs.get(i), goal, options);
        }
        if (goal instanceof RElementReference && (reffed = ((RElementReference)((Object)goal)).getReferencedElement()) != source) {
            this.computeReactivatableOptions((IRGoal)((Object)reffed), goal, options);
        }
    }

    protected IRGoal getGoal() {
        return this.goal;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " (goal=" + this.goal.getName() + ")";
    }

    static {
        $assertionsDisabled = !DeliberateInhibitedGoalsReactivationAction.class.desiredAssertionStatus();
    }
}

