/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.easydeliberation;

import jadex.model.IMDeliberation;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.agenda.AbstractElementAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.easydeliberation.SEasyDeliberation;
import jadex.util.SReflect;
import java.io.Serializable;
import java.util.List;

public class DeliberateGoalActivationAction
extends AbstractElementAgendaAction
implements Serializable {
    public static long timer;
    protected IRGoal goal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DeliberateGoalActivationAction(IAgendaActionPrecondition precondition, IRGoal goal) {
        super(goal, precondition);
        this.goal = goal;
    }

    public void execute() {
        long starttime = System.currentTimeMillis();
        if (!$assertionsDisabled && !this.goal.getLifecycleState().equals("option")) {
            throw new AssertionError((Object)(this.goal.getName() + ", " + this.goal.getLifecycleState()));
        }
        this.deliberateNewOption();
        timer += System.currentTimeMillis() - starttime;
    }

    protected void deliberateNewOption() {
        boolean activate = true;
        List occs = this.goal.getAllOccurrences();
        for (int i = 0; i < occs.size() && activate; ++i) {
            IRGoal occ = (IRGoal)occs.get(i);
            activate = this.checkCardinality(occ) && this.checkInhibitingGoals(occ);
        }
        if (activate) {
            this.goal.changeLifecycleState("active");
        }
    }

    protected boolean checkCardinality(IRGoal goal) {
        boolean ret = true;
        IMDeliberation delib = goal.getDeliberationInfo();
        if (delib != null && delib.getCardinality() != -1) {
            IRGoal[] samegoals = goal.getScope().getGoalbase().getActiveGoals(goal.getType());
            boolean bl = ret = samegoals.length < delib.getCardinality();
            if (!ret) {
                int exactgoalcnt = 0;
                for (int j = 0; j < samegoals.length; ++j) {
                    if (SEasyDeliberation.inhibits(goal, samegoals[j], true, false)) continue;
                    ++exactgoalcnt;
                }
                ret = exactgoalcnt < delib.getCardinality();
            }
        }
        return ret;
    }

    protected boolean checkInhibitingGoals(IRGoal goal) {
        boolean ret = true;
        IRGoal[] allgoals = goal.getScope().getGoalbase().getActiveGoals();
        for (int j = 0; j < allgoals.length && ret; ++j) {
            ret = !SEasyDeliberation.inhibits(allgoals[j], goal, allgoals[j].isActive(), allgoals[j].isInProcess());
        }
        return ret;
    }

    protected IRGoal getGoal() {
        return this.goal;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " (goal=" + this.goal.getName() + ")";
    }

    static {
        $assertionsDisabled = !DeliberateGoalActivationAction.class.desiredAssertionStatus();
    }
}

