/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.agent;

import jadex.runtime.SystemEvent;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.AbstractAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.agent.CleanupAgentAction;
import jadex.util.SReflect;

public class TerminateAgentAction
extends AbstractAgendaAction {
    protected RBDIAgent agent;

    public TerminateAgentAction(RBDIAgent agent) {
        super(null);
        this.agent = agent;
    }

    public void execute() {
        this.agent.setLifecycleState("terminating");
        this.agent.exitRunningState();
        this.agent.throwSystemEvent(new SystemEvent("agentTerminating", this.agent));
        this.agent.activateEndState();
        int timeout = 10000;
        try {
            Integer itimeout = (Integer)this.agent.getPropertybase().getProperty("termination.timeout");
            if (itimeout == null) {
                itimeout = (Integer)this.agent.getPropertybase().getProperty("standard.timeout");
            }
            timeout = itimeout;
        }
        catch (RuntimeException e) {
            this.agent.getLogger().warning("Agent cannot determine timeout: " + e);
        }
        this.agent.addTimetableEntry(new TimetableData(timeout, new CleanupAgentAction(this.agent, new IAgendaActionPrecondition(){

            public boolean check() {
                return "terminating".equals(TerminateAgentAction.this.agent.getLifecycleState());
            }
        })));
    }

    public boolean isValid() {
        return super.isValid() && "alive".equals(this.agent.getLifecycleState());
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " (agent=" + this.agent.getName() + ")";
    }
}

