/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda.agent;

import jadex.adapter.IMessageAdapter;
import jadex.model.IMEventbase;
import jadex.model.IMMessageEvent;
import jadex.model.IMMessageEventReference;
import jadex.model.IMReferenceableElement;
import jadex.runtime.impl.IRElement;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.agenda.AbstractElementAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class MessageArrivalAction
extends AbstractElementAgendaAction
implements Serializable {
    protected RBDIAgent agent;
    protected IMessageAdapter message;

    public MessageArrivalAction(RBDIAgent agent, IAgendaActionPrecondition precond, IMessageAdapter message) {
        super(agent, precond);
        this.agent = agent;
        this.message = message;
    }

    public void execute() {
        IRElement original = null;
        List capas = this.agent.getAllCapabilities();
        for (int i = 0; i < capas.size(); ++i) {
            IRMessageEvent rep = ((RCapability)capas.get(i)).getEventbase().getInReplyMessageEvent(this.message);
            if (rep != null && original != null) {
                this.agent.getLogger().severe("Cannot match reply message (multiple capabilities " + rep.getScope().getName() + ", " + original.getScope().getName() + ") for: " + this.message);
                return;
            }
            if (rep == null) continue;
            original = rep;
        }
        ArrayList events = SCollection.createArrayList();
        ArrayList matched = SCollection.createArrayList();
        int degree = 0;
        if (original == null) {
            for (int i = 0; i < capas.size(); ++i) {
                RCapability capa = (RCapability)capas.get(i);
                IMEventbase eb = (IMEventbase)capa.getEventbase().getModelElement();
                degree = this.matchMessageEvents(this.message, eb.getMessageEvents(), matched, events, degree);
            }
        } else {
            RCapability capa = original.getScope();
            IMEventbase eb = (IMEventbase)capa.getEventbase().getModelElement();
            degree = this.matchMessageEvents(this.message, eb.getMessageEvents(), matched, events, degree);
            degree = this.matchMessageEventReferences(this.message, eb.getMessageEventReferences(), matched, events, degree);
        }
        if (events.size() == 0) {
            this.agent.getLogger().warning(this.agent.getAgentName() + " cannot process message, no message event matches: " + this.message.getMessage());
        } else {
            if (events.size() > 1) {
                this.agent.getLogger().severe("Cannot decide which event matches message, using first: " + this.message.getMessage() + ", " + events);
            } else if (matched.size() > 1) {
                this.agent.getLogger().info("Multiple events matching message, using message event with highest specialization degree: " + this.message + " (" + degree + "), " + events.get(0) + ", " + matched);
            }
            IMReferenceableElement mevent = (IMReferenceableElement)events.get(0);
            RCapability scope = this.agent.lookupCapability(mevent.getScope());
            scope.getEventbase().dispatchIncomingMessageEvent(mevent, this.message, (IRMessageEvent)original);
        }
    }

    protected int matchMessageEvents(IMessageAdapter message, IMMessageEvent[] mevents, List matched, List events, int degree) {
        for (int i = 0; i < mevents.length; ++i) {
            String dir = mevents[i].getDirection();
            try {
                if (!dir.equals("receive") && !dir.equals("send_receive") || !message.match(mevents[i])) continue;
                matched.add(mevents[i]);
                if (mevents[i].getSpecializationDegree() > degree) {
                    degree = mevents[i].getSpecializationDegree();
                    events.clear();
                    events.add(mevents[i]);
                    continue;
                }
                if (mevents[i].getSpecializationDegree() != degree) continue;
                events.add(mevents[i]);
                continue;
            }
            catch (RuntimeException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.agent.getLogger().severe(sw.toString());
            }
        }
        return degree;
    }

    protected int matchMessageEventReferences(IMessageAdapter message, IMMessageEventReference[] meventrefs, List matched, List events, int degree) {
        for (int i = 0; i < meventrefs.length; ++i) {
            IMMessageEvent morig = (IMMessageEvent)meventrefs[i].getOriginalElement();
            String dir = morig.getDirection();
            try {
                if (!dir.equals("receive") && !dir.equals("send_receive") || !message.match(morig)) continue;
                matched.add(meventrefs[i]);
                if (morig.getSpecializationDegree() > degree) {
                    degree = morig.getSpecializationDegree();
                    events.clear();
                    events.add(meventrefs[i]);
                    continue;
                }
                if (morig.getSpecializationDegree() != degree) continue;
                events.add(meventrefs[i]);
                continue;
            }
            catch (RuntimeException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.agent.getLogger().severe(sw.toString());
            }
        }
        return degree;
    }

    public String toString() {
        return SReflect.getInnerClassName(this.getClass()) + " (agent=" + this.agent.getName() + ")";
    }
}

