/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl.agenda;

import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComposedPrecondition
implements IAgendaActionPrecondition {
    protected ArrayList subconditions = SCollection.createArrayList();

    public ComposedPrecondition(IAgendaActionPrecondition subcond) {
        if (subcond != null) {
            this.subconditions.add(subcond);
        }
    }

    public ComposedPrecondition(IAgendaActionPrecondition conda, IAgendaActionPrecondition condb) {
        if (conda != null) {
            this.subconditions.add(conda);
        }
        if (condb != null) {
            this.subconditions.add(condb);
        }
    }

    public boolean check() {
        boolean ret = true;
        for (int i = 0; i < this.subconditions.size() && ret; ++i) {
            IAgendaActionPrecondition pc = (IAgendaActionPrecondition)this.subconditions.get(i);
            if (pc.check()) continue;
            ret = false;
        }
        return ret;
    }

    public void addPrecondition(IAgendaActionPrecondition precondition) {
        if (precondition != null && !this.subconditions.contains(precondition)) {
            this.subconditions.add(precondition);
        }
    }

    protected List getPreconditions() {
        return Collections.unmodifiableList(this.subconditions);
    }
}

