/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.runtime.IFilter;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.WaitAbstraction;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.List;

public class Waitqueue
extends WaitAbstraction {
    protected RPlan plan;
    protected List events;

    public Waitqueue(RPlan plan) {
        super(plan.getScope());
        this.plan = plan;
        this.events = SCollection.createArrayList();
    }

    public void addEvent(IREvent event) {
        this.events.add(event);
    }

    public void removeEvent(IREvent event) {
        if (!this.events.remove(event)) {
            throw new RuntimeException("Waitqueue entry could not be deleted: " + event);
        }
    }

    public IREvent getNextEvent() {
        IREvent ret = null;
        if (this.events.size() > 0) {
            ret = (IREvent)this.events.get(0);
            this.events.remove(0);
        }
        return ret;
    }

    public IREvent[] getEvents() {
        return this.events.toArray(new IREvent[this.events.size()]);
    }

    public IREvent[] getEvents(IFilter filter) {
        ArrayList tmp = SCollection.createArrayList();
        for (int i = 0; i < this.events.size(); ++i) {
            if (!this.getCapability().getAgent().applyFilter(filter, this.events.get(i))) continue;
            tmp.add(this.events.get(i));
        }
        return tmp.toArray(new IREvent[tmp.size()]);
    }

    public int size() {
        return this.events.size();
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }
}

