/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCapability;
import jadex.model.IMEvent;
import jadex.model.IMEventReference;
import jadex.model.IMEventbase;
import jadex.model.IMExpression;
import jadex.model.IMGoalbase;
import jadex.model.IMInternalEvent;
import jadex.model.IMMetaGoalTrigger;
import jadex.model.IMPlanTrigger;
import jadex.model.IMReference;
import jadex.model.IMTrigger;
import jadex.runtime.ComposedFilter;
import jadex.runtime.GoalEventFilter;
import jadex.runtime.IFilter;
import jadex.runtime.InternalEventFilter;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.TimeoutException;
import jadex.runtime.impl.BeliefChangeCondition;
import jadex.runtime.impl.BeliefSetChangeCondition;
import jadex.runtime.impl.ICleanable;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.PlanInstanceInfo;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RInternalEvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.ComposedPrecondition;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.eventprocessing.ScheduleCandidatesAction;
import jadex.runtime.impl.agenda.plans.DefaultPlanActionPrecondition;
import jadex.util.Tuple;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WaitAbstraction
implements Serializable,
ICleanable {
    private static String CONDITION;
    private static String INTERNALEVENT;
    private static String MESSAGEEVENT;
    private static String GOAL;
    private static String GOALPROCESSING;
    private static String BELIEF;
    private static String BELIEFSET;
    private static String FILTER;
    private RCapability capability;
    private long timeout;
    private TimetableData td;
    private IFilter filter;
    private Map filters;
    private List cleanup_conditions;
    private List turnoff_conditions;
    private boolean cleanedup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WaitAbstraction(RCapability capability) {
        this.capability = capability;
        this.cleanup_conditions = SCollection.createArrayList();
        this.turnoff_conditions = SCollection.createArrayList();
        this.filters = SCollection.createHashMap();
        this.timeout = -1L;
    }

    public void cleanup() {
        if (!this.cleanedup) {
            int i;
            this.cleanedup = true;
            this.capability.getAgent().removeTimetableEntry(this.td);
            for (i = 0; i < this.turnoff_conditions.size(); ++i) {
                ((IRCondition)this.turnoff_conditions.get(i)).setTraceMode("never");
            }
            for (i = 0; i < this.cleanup_conditions.size(); ++i) {
                ((ICleanable)this.cleanup_conditions.get(i)).cleanup();
            }
            this.cleanup_conditions = null;
            this.turnoff_conditions = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.cleanedup) {
            this.capability.getAgent().scheduleGarbageCollection(this);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isTimeoutWait() {
        return this.timeout != -1L && this.getFilter() != null;
    }

    public IFilter getFilter() {
        if (this.filter == null && this.filters.size() > 0) {
            this.filter = this.filters.size() == 1 ? (IFilter)this.filters.values().toArray()[0] : new ComposedFilter(this.filters.values().toArray(new IFilter[this.filters.size()]), 2);
        }
        return this.filter;
    }

    public IFilter getDynamicFilter() {
        return new WaitAbstractionFilter();
    }

    public void addMessageEvent(String type, IMExpression match) {
        MessageEventFilter mef = new MessageEventFilter(type);
        if (match != null) {
            mef.setMatchExpression(match);
        }
        this.addFilter(new Tuple(MESSAGEEVENT, type), mef);
    }

    public void addMessageEvent(IRMessageEvent mevent) {
        this.addFilter(new Tuple(new Object[]{MESSAGEEVENT, mevent}), mevent.getFilter());
    }

    public void addInternalEvent(String type, IMExpression match) {
        InternalEventFilter ief = new InternalEventFilter(type);
        if (match != null) {
            ief.setMatchExpression(match);
        }
        this.addFilter(new Tuple(INTERNALEVENT, type), ief);
    }

    public void addGoalProcess(String type, IMExpression match) {
        GoalEventFilter gef = new GoalEventFilter(type, false);
        if (match != null) {
            gef.setMatchExpression(match);
        }
        this.addFilter(new Tuple(GOALPROCESSING, type), gef);
    }

    public void addGoal(String type, IMExpression match) {
        GoalEventFilter gef = new GoalEventFilter(type, true);
        if (match != null) {
            gef.setMatchExpression(match);
        }
        this.addFilter(new Tuple(GOAL, type), gef);
    }

    public void addGoal(IRGoal goal) {
        this.addFilter(new Tuple(GOAL, goal), goal.getFilter());
    }

    public void addBelief(String type) {
        IRBelief bel = this.capability.getBeliefbase().getBelief(type);
        if (bel == null) {
            throw new RuntimeException("Belief not found: " + type);
        }
        BeliefChangeCondition cond = new BeliefChangeCondition(bel, bel.getFact(), null);
        cond.setTraceMode("once");
        this.cleanup_conditions.add(cond);
        this.addFilter(new Tuple(BELIEF, type), cond.getFilter());
    }

    public void addBelief(IRBelief bel) {
        BeliefChangeCondition cond = new BeliefChangeCondition(bel, bel.getFact(), null);
        cond.setTraceMode("once");
        this.cleanup_conditions.add(cond);
        this.addFilter(new Tuple(BELIEF, bel), cond.getFilter());
    }

    public void addBeliefSet(String type, String[] eventtypes) {
        IRBeliefSet belset = this.capability.getBeliefbase().getBeliefSet(type);
        if (belset == null) {
            throw new RuntimeException("Belief set not found: " + type);
        }
        Object[] oldvals = null;
        for (int i = 0; i < eventtypes.length; ++i) {
            if (!eventtypes[i].equals("BDI_bsfactsChanged")) continue;
            oldvals = belset.getFacts();
            break;
        }
        BeliefSetChangeCondition cond = new BeliefSetChangeCondition(belset, oldvals, eventtypes, null);
        cond.setTraceMode("once");
        this.cleanup_conditions.add(cond);
        this.addFilter(new Tuple(BELIEFSET, type), cond.getFilter());
    }

    public void addBeliefSet(IRBeliefSet belset, String[] eventtypes) {
        Object[] oldvals = null;
        for (int i = 0; i < eventtypes.length; ++i) {
            if (!eventtypes[i].equals("BDI_bsfactsChanged")) continue;
            oldvals = belset.getFacts();
            break;
        }
        BeliefSetChangeCondition cond = new BeliefSetChangeCondition(belset, oldvals, eventtypes, null);
        cond.setTraceMode("once");
        this.cleanup_conditions.add(cond);
        this.addFilter(new Tuple(BELIEFSET, belset), cond.getFilter());
    }

    public void addFilter(IFilter filter) {
        this.addFilter(new Tuple(FILTER, filter), filter);
    }

    public void addCondition(String condition) {
        IRCondition cond = this.capability.getExpressionbase().createCondition(condition);
        if (cond.getTraceMode().equals("never")) {
            cond.traceOnce();
        }
        this.cleanup_conditions.add(cond);
        this.addFilter(new Tuple(CONDITION, condition), cond.getFilter());
    }

    public void addCondition(IRCondition condition) {
        if (condition.getTraceMode().equals("never")) {
            condition.traceOnce();
            this.turnoff_conditions.add(condition);
        }
        this.addFilter(new Tuple(CONDITION, condition), condition.getFilter());
    }

    public void setTimeout(long timeout, final RPlan plan) {
        if (!$assertionsDisabled && this.timeout != -1L) {
            throw new AssertionError();
        }
        if (timeout == -1L) {
            return;
        }
        this.timeout = timeout;
        IMInternalEvent mevent = ((IMCapability)this.capability.getModelElement()).getEventbase().getInternalEvent("InternalEvent_timeout");
        RInternalEvent event = this.capability.getEventbase().createInternalEvent(mevent);
        if (this.isTimeoutWait()) {
            event.getParameter("exception").setValue(new TimeoutException());
        }
        ArrayList cands = SCollection.createArrayList();
        cands.add(new PlanInstanceInfo(event, plan));
        this.td = new TimetableData(this.getTimeout(), new ScheduleCandidatesAction(new ComposedPrecondition(new IAgendaActionPrecondition(){

            public boolean check() {
                return !plan.isScheduled();
            }
        }, new DefaultPlanActionPrecondition(plan)), this.capability.getAgent(), event, cands));
        this.capability.getAgent().addTimetableEntry(this.td);
    }

    public void removeMessageEvent(String type) {
        this.removeFilter(new Tuple(MESSAGEEVENT, type));
    }

    public void removeMessageEvent(IRMessageEvent mevent) {
        this.removeFilter(new Tuple(new Object[]{MESSAGEEVENT, mevent}));
    }

    public void removeInternalEvent(String type) {
        this.removeFilter(new Tuple(INTERNALEVENT, type));
    }

    public void removeGoalProcess(String type) {
        this.removeFilter(new Tuple(GOALPROCESSING, type));
    }

    public void removeGoal(String type) {
        this.removeFilter(new Tuple(GOAL, type));
    }

    public void removeGoal(IRGoal goal) {
        this.removeFilter(new Tuple(GOAL, goal));
    }

    public void removeBelief(String type) {
        this.removeFilter(new Tuple(BELIEF, type));
    }

    public void removeBelief(IRBelief bel) {
        this.removeFilter(new Tuple(BELIEF, bel));
    }

    public void removeBeliefSet(String type) {
        this.removeFilter(new Tuple(BELIEFSET, type));
    }

    public void removeBeliefSet(IRBeliefSet belset) {
        this.removeFilter(new Tuple(BELIEFSET, belset));
    }

    public void removeFilter(IFilter filter) {
        this.removeFilter(new Tuple(FILTER, filter));
    }

    public void removeCondition(String condition) {
        this.removeFilter(new Tuple(CONDITION, condition));
    }

    public void removeCondition(IRCondition condition) {
        if (this.turnoff_conditions.remove(condition)) {
            condition.setTraceMode("never");
        }
        this.removeFilter(new Tuple(CONDITION, condition));
    }

    protected void addFilter(Tuple reason, IFilter filter) {
        if (this.filters.containsKey(reason)) {
            throw new RuntimeException("Error, wait reason already contained: " + reason);
        }
        this.filters.put(reason, filter);
        this.filter = null;
    }

    protected void removeFilter(Tuple reason) {
        if (!this.filters.containsKey(reason)) {
            throw new RuntimeException("Error, wait reason not found: " + reason);
        }
        this.filters.remove(reason);
        this.filter = null;
    }

    public RCapability getCapability() {
        return this.capability;
    }

    protected IFilter createFilter(IMTrigger trigger) {
        IFilter ret = null;
        ArrayList filters = SCollection.createArrayList();
        if (trigger != null) {
            GoalEventFilter gf;
            String name;
            int i;
            IMEventReference eventref;
            IMEvent event;
            String name2;
            int i2;
            IMEventbase eventbase = ((IMCapability)this.capability.getModelElement()).getEventbase();
            IMReference[] refs = trigger.getInternalEvents();
            for (i2 = 0; i2 < refs.length; ++i2) {
                name2 = refs[i2].getReference();
                event = eventbase.getInternalEvent(name2);
                if (event == null && (eventref = eventbase.getInternalEventReference(name2)) == null) {
                    throw new RuntimeException("Referenced internal event not found: " + name2);
                }
                InternalEventFilter bf = new InternalEventFilter(name2);
                bf.setMatchExpression(refs[i2].getMatchExpression());
                filters.add(bf);
            }
            refs = trigger.getMessageEvents();
            for (i2 = 0; i2 < refs.length; ++i2) {
                name2 = refs[i2].getReference();
                event = eventbase.getMessageEvent(name2);
                if (event == null && (eventref = eventbase.getMessageEventReference(name2)) == null) {
                    throw new RuntimeException("Referenced message event not found: " + name2);
                }
                MessageEventFilter mf = new MessageEventFilter(name2);
                mf.setMatchExpression(refs[i2].getMatchExpression());
                filters.add(mf);
            }
            IMGoalbase goalbase = ((IMCapability)this.capability.getModelElement()).getGoalbase();
            refs = trigger.getGoalFinisheds();
            for (i = 0; i < refs.length; ++i) {
                name = refs[i].getReference();
                goalbase.getReferenceableElement(name);
                gf = new GoalEventFilter(name, true);
                gf.setMatchExpression(refs[i].getMatchExpression());
                filters.add(gf);
            }
            if (trigger instanceof IMPlanTrigger || trigger instanceof IMMetaGoalTrigger) {
                refs = trigger instanceof IMPlanTrigger ? ((IMPlanTrigger)trigger).getGoals() : ((IMMetaGoalTrigger)trigger).getGoals();
                for (i = 0; i < refs.length; ++i) {
                    name = refs[i].getReference();
                    goalbase.getReferenceableElement(name);
                    gf = new GoalEventFilter(name);
                    gf.setMatchExpression(refs[i].getMatchExpression());
                    filters.add(gf);
                }
            }
            if (trigger.getFilter() != null) {
                IFilter filter = (IFilter)this.capability.getExpressionbase().evaluateInternalExpression(trigger.getFilter(), this.capability);
                filters.add(filter);
            }
        }
        if (filters.size() == 1) {
            ret = (IFilter)filters.get(0);
        } else if (filters.size() > 1) {
            ret = new ComposedFilter(filters.toArray(new IFilter[filters.size()]), 2);
        }
        return ret;
    }

    static {
        $assertionsDisabled = !WaitAbstraction.class.desiredAssertionStatus();
        CONDITION = "condition";
        INTERNALEVENT = "internalevent";
        MESSAGEEVENT = "messageevent";
        GOAL = "goal";
        GOALPROCESSING = "goal";
        BELIEF = "belief";
        BELIEFSET = "beliefset";
        FILTER = "filter";
    }

    public class WaitAbstractionFilter
    implements IFilter,
    Serializable {
        public boolean filter(Object object) throws Exception {
            return WaitAbstraction.this.getFilter().filter(object);
        }
    }
}

