/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.ISystemEventTypes;
import jadex.runtime.IFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRElement;
import jadex.util.collection.SCollection;
import java.util.Set;

public class SystemEventFilter
implements IFilter {
    protected Set eventtypes;
    protected IRElement element;
    protected String type;

    public SystemEventFilter(String[] eventtypes, IRElement element) {
        this(eventtypes);
        this.element = element;
    }

    public SystemEventFilter(String[] eventtypes, String type) {
        this(eventtypes);
        this.type = type;
    }

    public SystemEventFilter(String[] eventtypes) {
        this.setEventTypes(eventtypes);
    }

    public boolean filter(Object object) throws Exception {
        Object src;
        if (!(object instanceof SystemEvent)) {
            return false;
        }
        boolean ret = true;
        SystemEvent se = (SystemEvent)object;
        if (this.eventtypes.size() > 0 && !this.eventtypes.contains(se.getType())) {
            ret = false;
        }
        if (!(!ret || this.type == null || (src = se.getSource()) instanceof IRElement && ((IRElement)src).getType().equals(this.type))) {
            ret = false;
        }
        if (ret && this.element != null && !this.element.equals(se.getSource())) {
            ret = false;
        }
        return ret;
    }

    public String toString() {
        return "SystemEventFilter(eventtypes=" + this.eventtypes + ", type=" + this.type + ", element" + this.element + ")";
    }

    public void setEventTypes(String[] eventtypes) {
        this.eventtypes = SCollection.createHashSet();
        for (int i = 0; i < eventtypes.length; ++i) {
            this.eventtypes.addAll(ISystemEventTypes.Subtypes.getSubtypes(eventtypes[i]));
        }
    }
}

