/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigElement;
import jadex.model.IMTypedElementSet;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RExpression;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.elementupdate.UpdateSetAction;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class RTypedElementSet
extends RReferenceableElement
implements PropertyChangeListener {
    protected static Class[] PCL = new Class[]{PropertyChangeListener.class};
    protected transient ArrayList values;
    protected ArrayList serialized_values;
    protected IRExpression inivals;
    protected boolean initing;
    private boolean modified;

    protected RTypedElementSet(String name, IMTypedElementSet typedelement, IMConfigElement state, RElement owner, RReferenceableElement creator) {
        super(name, typedelement, state, owner, creator, null);
    }

    protected void init() {
        if (this.isInited()) {
            return;
        }
        if (this.initing) {
            throw new RuntimeException("Recursive self initialization (probably cyclic dependency): " + this);
        }
        this.initing = true;
        this.setInitialValues();
        if (this.getUpdateRate() > 0L) {
            this.getScope().getAgent().addTimetableEntry(new TimetableData(this.getUpdateRate(), new UpdateSetAction(this, null)));
        }
        this.removeInitialState();
        this.initing = false;
        super.init();
    }

    protected abstract void setInitialValues();

    protected void setInitialValuesExpression(IRExpression inivals) {
        this.inivals = inivals;
        this.throwSystemEvent(this.createSystemEvent("BDI_esValuesChanged", null, -1));
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                this.deregisterValue(this.values.get(i));
            }
        }
    }

    public void addValue(Object value) {
        if (!this.isInited() && !this.initing) {
            this.init();
        }
        if (this.inivals != null) {
            throw new RuntimeException("Cannot change set with dynamic initial values: " + this);
        }
        this.checkType(value);
        Class type = ((IMTypedElementSet)this.getModelElement()).getClazz();
        value = SReflect.convertWrappedValue(value, type);
        this.registerValue(value);
        if (this.values == null) {
            this.values = SCollection.createArrayList();
        }
        this.values.add(value);
        if (!this.initing) {
            this.modified = true;
        }
        this.throwSystemEvent(this.createSystemEvent("BDI_esValueAdded", value, this.values.size() - 1));
    }

    public void removeValue(Object value) {
        if (!this.isInited()) {
            this.init();
        }
        if (this.inivals != null) {
            throw new RuntimeException("Cannot change set with dynamic initial values: " + this);
        }
        int index = this.indexOf(value);
        if (index != -1) {
            this.deregisterValue(this.values.remove(index));
            if (!this.initing) {
                this.modified = true;
            }
            this.throwSystemEvent(this.createSystemEvent("BDI_esValueRemoved", value, index));
        } else {
            this.getScope().getAgent().getLogger().warning("No such value in element set: " + this + " " + value);
        }
    }

    protected int indexOf(Object value) {
        return this.values != null ? this.values.indexOf(value) : -1;
    }

    public void addValues(Object[] values) {
        for (int i = 0; values != null && i < values.length; ++i) {
            this.addValue(values[i]);
        }
    }

    public void removeValues() {
        if (!this.isInited() && !this.initing) {
            this.init();
        }
        if (this.inivals != null) {
            throw new RuntimeException("Cannot change set with dynamic initial values: " + this);
        }
        if (this.values != null) {
            for (int i = this.values.size() - 1; i >= 0; --i) {
                this.removeValue(this.values.get(i));
            }
        }
        if (!this.initing) {
            this.modified = true;
        }
    }

    public void updateValue(Object newvalue) {
        if (!this.isInited()) {
            this.init();
        }
        if (this.inivals != null) {
            throw new RuntimeException("Cannot change set with dynamic initial values: " + this);
        }
        int index = this.indexOf(newvalue);
        if (index != -1) {
            this.deregisterValue(this.values.remove(index));
            this.values.add(index, newvalue);
            this.registerValue(newvalue);
            if (!this.initing) {
                this.modified = true;
            }
        } else {
            throw new RuntimeException("Value could not be updated, value not found: " + newvalue);
        }
        this.throwSystemEvent(this.createSystemEvent("BDI_esValueChanged", newvalue, index));
    }

    public Object getValue(Object oldval) {
        if (!this.isInited()) {
            this.init();
        }
        Object newval = null;
        boolean found = false;
        if (this.inivals != null) {
            Iterator it = SReflect.getIterator(this.inivals.getValue());
            while (!found && it.hasNext()) {
                Object val = it.next();
                found = val == null && oldval == null || val != null && val.equals(oldval);
                if (!found) continue;
                newval = val;
            }
        } else {
            int index = this.indexOf(oldval);
            if (index != -1) {
                found = true;
                newval = this.values.get(index);
            }
        }
        if (!found) {
            throw new RuntimeException("Value cannot be retrieved, old value not found: " + oldval);
        }
        return newval;
    }

    public boolean containsValue(Object value) {
        if (!this.isInited()) {
            this.init();
        }
        boolean contains = false;
        if (this.inivals != null) {
            Iterator it = SReflect.getIterator(this.inivals.getValue());
            while (!contains && it.hasNext()) {
                Object val = it.next();
                contains = val == null && value == null || val != null && val.equals(value);
            }
        } else if (this.values != null) {
            contains = this.values.contains(value);
        }
        return contains;
    }

    public Object[] getValues() {
        if (!this.isInited()) {
            this.init();
        }
        Object[] ret = this.inivals != null ? SUtil.iteratorToArray(SReflect.getIterator(this.inivals.getValue()), ((IMTypedElementSet)this.getModelElement()).getClazz()) : (this.values != null ? this.values.toArray((Object[])Array.newInstance(SReflect.getWrappedType(((IMTypedElementSet)this.getModelElement()).getClazz()), this.values.size())) : (Object[])Array.newInstance(SReflect.getWrappedType(((IMTypedElementSet)this.getModelElement()).getClazz()), 0));
        return ret;
    }

    public int size() {
        int size;
        if (!this.isInited()) {
            this.init();
        }
        if (this.inivals != null) {
            size = 0;
            Iterator it = SReflect.getIterator(this.inivals.getValue());
            while (it.hasNext()) {
                ++size;
                it.next();
            }
        } else {
            size = this.values != null ? this.values.size() : 0;
        }
        return size;
    }

    public long getUpdateRate() {
        if (!this.isInited() && !this.initing) {
            this.init();
        }
        return ((IMTypedElementSet)this.getModelElement()).getUpdateRate();
    }

    public boolean isModified() {
        return this.modified;
    }

    public Class getClazz() {
        return ((IMTypedElementSet)this.getModelElement()).getClazz();
    }

    public void propertyChange(final PropertyChangeEvent e) {
        final int index = this.indexOf(e.getSource());
        if (index != -1) {
            RPlan plan = this.getScope().getAgent().getCurrentPlan();
            if (this.getScope().getAgent().getInterpreter().isPlanThread()) {
                plan.startMonitorConsequences();
                this.throwSystemEvent(this.createSystemEvent("BDI_esValueChanged", e.getSource(), index));
                plan.endMonitorConsequences();
            } else if (this.getScope().getAgent().getInterpreter().isAgentThread()) {
                this.throwSystemEvent(this.createSystemEvent("BDI_esValueChanged", e.getSource(), index));
            } else {
                this.getScope().getAgent().getInterpreter().invokeLater(new Runnable(){

                    public void run() {
                        RTypedElementSet.this.throwSystemEvent(RTypedElementSet.this.createSystemEvent("BDI_esValueChanged", e.getSource(), index));
                    }
                });
            }
        } else {
            throw new RuntimeException("Value cannot be replaced, old value not found: " + e.getSource());
        }
    }

    public SystemEvent createSystemEvent(String type, Object value, int index) {
        return new SystemEvent(type, this, value, index);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.getName());
        sb.append(")");
        return sb.toString();
    }

    public Map getEncodableRepresentation() {
        Map rep = super.getEncodableRepresentation();
        rep.put("valueclass", ((IMTypedElementSet)this.getModelElement()).getClazz().getName());
        rep.put("updaterate", "" + ((IMTypedElementSet)this.getModelElement()).getUpdateRate());
        return rep;
    }

    protected void checkType(Object value) {
        Class<?> testtype = null;
        Class type = ((IMTypedElementSet)this.getModelElement()).getClazz();
        if (value != null) {
            testtype = value.getClass();
        }
        if (testtype != null && !SReflect.isSupertype(type, testtype)) {
            throw new RuntimeException("Cannot store value " + testtype + " in " + this);
        }
    }

    protected void registerValue(Object value) {
        this.serialized_values = null;
        if (value != null && !(value instanceof RExpression)) {
            try {
                Method meth = SReflect.getMethod(value.getClass(), "addPropertyChangeListener", PCL);
                if (meth != null) {
                    meth.invoke(value, this);
                }
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    protected void deregisterValue(Object value) {
        this.serialized_values = null;
        if (value != null) {
            try {
                Method meth = SReflect.getMethod(value.getClass(), "removePropertyChangeListener", PCL);
                if (meth != null) {
                    meth.invoke(value, this);
                }
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public IRExpression internalGetInivals() {
        if (!this.isInited() && !this.initing) {
            this.init();
        }
        return this.inivals;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (!((IMTypedElementSet)this.getModelElement()).isTransient()) {
            this.serialized_values = this.values;
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        this.values = this.serialized_values;
        this.serialized_values = null;
        return super.readResolve();
    }
}

