/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigElement;
import jadex.model.IMExpression;
import jadex.model.IMTypedElement;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IInterpreterCondition;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RExpression;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.elementupdate.UpdateAction;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class RTypedElement
extends RReferenceableElement
implements PropertyChangeListener {
    protected static Class[] PCL = new Class[]{PropertyChangeListener.class};
    private transient Object value;
    private Object serialized_value;
    private boolean modified;

    protected RTypedElement(String name, IMTypedElement typedelement, IMConfigElement state, RElement owner, RReferenceableElement creator) {
        super(name, typedelement, state, owner, creator, null);
    }

    protected void init() {
        if (!this.isInited()) {
            super.init();
            this.setInitialValue();
            if (this.getUpdateRate() > 0L) {
                this.getScope().getAgent().addTimetableEntry(new TimetableData(this.getUpdateRate(), new UpdateAction(this, null)));
            }
            this.removeInitialState();
        }
    }

    public abstract void setInitialValue();

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.value != null) {
            this.deregisterValue(this.value);
        }
    }

    public void setValue(Object value) {
        if (!this.isInited()) {
            this.initStructure();
        }
        if (value != null) {
            this.checkType(value);
            if (!(value instanceof RExpression)) {
                Class type = ((IMTypedElement)this.getModelElement()).getClazz();
                value = SReflect.convertWrappedValue(value, type);
            }
        }
        if (!SUtil.equals(this.value, value)) {
            this.deregisterValue(this.value);
            this.registerValue(value);
            this.value = value;
            this.modified = true;
            this.throwSystemEvent(this.createSystemEvent("BDI_valueChanged"));
        }
    }

    protected void setInitialValue(Object value) {
        if (value != null) {
            this.checkType(value);
            if (!(value instanceof RExpression)) {
                Class type = ((IMTypedElement)this.getModelElement()).getClazz();
                value = SReflect.convertWrappedValue(value, type);
            }
            this.registerValue(value);
            this.value = value;
            this.throwSystemEvent(this.createSystemEvent("BDI_valueChanged"));
        }
    }

    public Object getValue() {
        Object ret;
        if (!this.isInited()) {
            this.initStructure();
        }
        if ((ret = this.value) instanceof IRExpression && !SReflect.isSupertype(IRExpression.class, ((IMTypedElement)this.getModelElement()).getClazz()) && !SReflect.isSupertype(IInterpreterCondition.class, ((IMTypedElement)this.getModelElement()).getClazz())) {
            ret = ((RExpression)ret).getValue();
        }
        return ret;
    }

    public void refresh() {
        if (!this.isInited()) {
            this.initStructure();
        }
        if (!(this.value instanceof RExpression)) {
            throw new UnsupportedOperationException("Cannot refresh non-expression value: " + this);
        }
        ((RExpression)this.value).refresh();
    }

    public long getUpdateRate() {
        if (!this.isInited()) {
            this.initStructure();
        }
        return ((IMTypedElement)this.getModelElement()).getUpdateRate();
    }

    public boolean isModified() {
        return this.modified;
    }

    public Class getClazz() {
        return ((IMTypedElement)this.getModelElement()).getClazz();
    }

    public void propertyChange(PropertyChangeEvent e) {
        RPlan plan = this.getScope().getAgent().getCurrentPlan();
        if (this.getScope().getAgent().getInterpreter().isPlanThread()) {
            plan.startMonitorConsequences();
            this.throwSystemEvent(this.createSystemEvent("BDI_valueChanged"));
            plan.endMonitorConsequences();
        } else if (this.getScope().getAgent().getInterpreter().isAgentThread()) {
            this.throwSystemEvent(this.createSystemEvent("BDI_valueChanged"));
        } else {
            this.getScope().getAgent().getInterpreter().invokeLater(new Runnable(){

                public void run() {
                    RTypedElement.this.throwSystemEvent(RTypedElement.this.createSystemEvent("BDI_valueChanged"));
                }
            });
        }
    }

    public Object internalGetValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.getName());
        sb.append(", value=");
        sb.append(this.value);
        sb.append(", class=");
        sb.append(((IMTypedElement)this.getModelElement()).getClazz());
        sb.append(")");
        return sb.toString();
    }

    public Map getEncodableRepresentation() {
        String value;
        Map rep = super.getEncodableRepresentation();
        rep.put("valueclass", ((IMTypedElement)this.getModelElement()).getClazz().getName());
        rep.put("updaterate", "" + ((IMTypedElement)this.getModelElement()).getUpdateRate());
        if (this.value instanceof RExpression) {
            try {
                value = "" + ((RExpression)this.value).getValue();
            }
            catch (Exception e) {
                value = "n/a";
            }
        } else {
            value = "" + this.value;
        }
        rep.put("value", value);
        return rep;
    }

    public SystemEvent createSystemEvent(String type) {
        Class ctype;
        Object value = this.value;
        if (value instanceof RExpression && !SReflect.isSupertype(RExpression.class, ctype = ((IMTypedElement)this.getModelElement()).getClazz())) {
            try {
                value = ((RExpression)value).getValue();
            }
            catch (Exception e) {
                value = "n/a";
            }
        }
        return new SystemEvent(type, this, value);
    }

    protected void checkType(Object value) {
        Class testtype = null;
        Class type = ((IMTypedElement)this.getModelElement()).getClazz();
        if (value instanceof RExpression) {
            IMExpression mex = (IMExpression)((RExpression)value).getModelElement();
            if (SReflect.isSupertype(RExpression.class, type)) {
                testtype = value.getClass();
            } else if (mex.getClazz() != null) {
                testtype = mex.getClazz();
            }
        } else if (value != null) {
            testtype = value.getClass();
        }
        if (testtype != null && !SReflect.isSupertype(type, testtype)) {
            throw new RuntimeException("Cannot store value " + testtype + " in " + this + " " + this.getOwner());
        }
    }

    protected void registerValue(Object value) {
        this.serialized_value = null;
        if (value != null) {
            try {
                Method meth = SReflect.getMethod(value.getClass(), "addPropertyChangeListener", PCL);
                if (meth != null) {
                    meth.invoke(value, this);
                }
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    protected void deregisterValue(Object value) {
        this.serialized_value = null;
        if (value instanceof RExpression) {
            Class type;
            if (!SReflect.isSupertype(RExpression.class, type = ((IMTypedElement)this.getModelElement()).getClazz())) {
                ((RExpression)value).cleanup();
            }
        } else if (value != null) {
            try {
                Method meth = SReflect.getMethod(value.getClass(), "removePropertyChangeListener", PCL);
                if (meth != null) {
                    meth.invoke(value, this);
                }
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    protected IAgendaAction createUpdateAction() {
        return new UpdateAction(this, null);
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (!((IMTypedElement)this.getModelElement()).isTransient()) {
            this.serialized_value = this.value;
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        this.value = this.serialized_value;
        return super.readResolve();
    }
}

