/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMBase;
import jadex.model.IMConfigElement;
import jadex.model.IMElementReference;
import jadex.model.IMReferenceableElement;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRReferenceableElement;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RElementReference;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class RReferenceableElement
extends RElement
implements IRReferenceableElement {
    protected List references;
    protected RReferenceableElement creator;
    private IMConfigElement state;
    private boolean inited;
    protected List occurrences;
    Exception ex;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RReferenceableElement(String name, IMReferenceableElement modelelement, IMConfigElement state, RElement owner, RReferenceableElement creator, Map exparams) {
        super(name, modelelement, owner, exparams);
        this.state = state;
        if (!$assertionsDisabled && owner == null) {
            throw new AssertionError((Object)(name + " " + modelelement + " " + exparams));
        }
        this.creator = creator;
        this.fetchAssignToElements();
        this.fetchStrongExports();
    }

    public void initStructure() {
        List occs = this.getAllOccurrences();
        for (int i = 0; i < occs.size(); ++i) {
            ((RReferenceableElement)occs.get(i)).init();
        }
    }

    protected void init() {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (debug) {
            if (this.ex == null) {
                try {
                    throw new RuntimeException();
                }
                catch (RuntimeException e) {
                    this.ex = e;
                }
            } else {
                this.ex.printStackTrace();
            }
        }
        if (!$assertionsDisabled && this.inited) {
            throw new AssertionError(this);
        }
        this.inited = true;
    }

    protected boolean isInited() {
        return this.inited;
    }

    protected void fetchAssignToElements() {
        IMElementReference[] refs = ((IMReferenceableElement)this.getModelElement()).getAssignToElements();
        for (int i = 0; i < refs.length; ++i) {
            if (this.creator != null && this.creator.getModelElement() == refs[i] || !(this.getOwner() instanceof RBase)) continue;
            RBase base = (RBase)this.getOwner();
            RElementReference elem = (RElementReference)base.getElementInstance(refs[i], this);
        }
    }

    protected void fetchStrongExports() {
        if ("true".equals(((IMReferenceableElement)this.getModelElement()).getExported()) && this.getOwner() instanceof RBase && this.getScope().getParent() != null) {
            RBase base = (RBase)this.getOwner();
            IMBase mbase = (IMBase)base.getCorrespondingBase(this.getScope().getParent()).getModelElement();
            IMReferenceableElement[] elements = mbase.getReferenceableElements();
            for (int i = 0; i < elements.length; ++i) {
                IMElementReference ref;
                if (!(elements[i] instanceof IMElementReference) || (ref = (IMElementReference)elements[i]).getReferencedElement() != this.getModelElement() || this.creator != null && this.creator.getModelElement() == ref) continue;
                RElementReference elem = (RElementReference)base.getElementInstance(ref, this);
            }
        }
    }

    public IMConfigElement getInitialState() {
        return this.state;
    }

    public void removeInitialState() {
        this.state = null;
    }

    protected RReferenceableElement getCreator() {
        return this.creator;
    }

    protected void addReference(RElementReference reference) {
        if (this.references == null) {
            this.references = SCollection.createArrayList();
        }
        this.occurrences = null;
        this.references.add(reference);
    }

    public List getReferences() {
        if (this.references != null) {
            return this.references;
        }
        return Collections.EMPTY_LIST;
    }

    public List getAllOccurrences() {
        if (this.occurrences == null) {
            ArrayList refs = SCollection.createArrayList();
            refs.add(this);
            for (int i = 0; i < refs.size(); ++i) {
                RReferenceableElement elm = (RReferenceableElement)refs.get(i);
                if (elm.references == null) continue;
                refs.addAll(elm.references);
            }
            this.occurrences = Collections.unmodifiableList(refs);
        }
        return this.occurrences;
    }

    public RReferenceableElement getOriginalElement() {
        return this;
    }

    public void throwSystemEvent(String event) {
        this.throwSystemEvent(new SystemEvent(event, this));
    }

    public void throwSystemEvent(SystemEvent event) {
        if (!this.inited) {
            event.setInit(true);
        }
        if (this.getScope().getAgent().isTransactionStarted() && !event.isChangeRelevant()) {
            this.getScope().addInfoEvent(event);
        } else {
            this.getScope().getAgent().startSystemEventTransaction();
            this.createSystemEvents(event);
            this.getScope().getAgent().commitSystemEventTransaction();
        }
    }

    protected void createSystemEvents(SystemEvent event) {
        this.getScope().collectSystemEvents(event);
        if (this.references != null) {
            for (int i = 0; i < this.references.size(); ++i) {
                RElementReference ref = (RElementReference)this.references.get(i);
                SystemEvent clone = new SystemEvent(event.getType(), ref, event.getValue(), event.getIndex());
                ref.createSystemEvents(clone);
            }
        }
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.references != null) {
            for (int i = 0; i < this.references.size(); ++i) {
                ((RElementReference)this.references.get(i)).cleanup();
            }
        }
    }

    public Map getEncodableRepresentation() {
        Map rep = super.getEncodableRepresentation();
        rep.put("scope", this.getScope() == null ? "null" : this.getScope().getDetailName());
        return rep;
    }

    static {
        $assertionsDisabled = !RReferenceableElement.class.desiredAssertionStatus();
    }
}

