/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMExpression;
import jadex.model.IMPropertybase;
import jadex.model.IMReferenceableElement;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.util.ArrayList;

public class RPropertybase
extends RBase {
    protected IndexMap props = SCollection.createIndexMap();

    protected RPropertybase(IMPropertybase model, RElement owner) {
        super(null, model, owner);
    }

    protected void constructorInit() {
        IMExpression[] exps = ((IMPropertybase)this.getModelElement()).getProperties();
        for (int i = 0; i < exps.length; ++i) {
            Object prop = null;
            try {
                prop = this.getScope().getExpressionbase().evaluateInternalExpression(exps[i], this);
                this.props.add(exps[i].getName(), prop);
                continue;
            }
            catch (Exception e) {
                System.out.println(this.getScope().getAgentName() + " could not evaluate property: " + exps[i]);
                continue;
            }
            catch (Error e) {
                System.out.println(this.getScope().getAgentName() + " could not evaluate property: " + exps[i]);
            }
        }
    }

    public Object getProperty(String name) {
        Object value = this.props.get(name);
        if (value == null && this.getScope().getParent() != null) {
            value = this.getScope().getParent().getPropertybase().getProperty(name);
        }
        return value;
    }

    public String[] getPropertyNames(String start) {
        ArrayList ret = SCollection.createArrayList();
        String[] keys = (String[])this.props.getKeys(String.class);
        for (int i = 0; i < keys.length; ++i) {
            if (start != null && !keys[i].startsWith(start)) continue;
            ret.add(keys[i]);
        }
        String[] pps = null;
        if (this.getScope().getParent() != null) {
            pps = this.getScope().getParent().getPropertybase().getPropertyNames(start);
            for (int i = 0; i < pps.length; ++i) {
                ret.add(pps[i]);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    protected RReferenceableElement getElementInstance(IMReferenceableElement melement, RReferenceableElement creator) {
        throw new RuntimeException("Base does not support referenceable elements!: " + this.getName());
    }

    protected RBase getCorrespondingBase(RCapability scope) {
        return scope.getPropertybase();
    }
}

