/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMReferenceableElement;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RParameterSet;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class RProcessGoalParameterSet
extends RReferenceableElement
implements IRParameterSet {
    protected IRParameterSet paramset;
    protected boolean modified;
    protected List values;

    protected RProcessGoalParameterSet(IRParameterSet paramset, RElement owner) {
        super(paramset.getName(), (IMReferenceableElement)paramset.getModelElement(), null, owner, null, null);
        this.paramset = paramset;
        this.modified = false;
    }

    public void addValue(Object value) {
        this.modified();
        this.values.add(value);
    }

    public void removeValue(Object value) {
        this.modified();
        this.values.remove(value);
    }

    public void addValues(Object[] values) {
        this.modified();
        for (int i = 0; i < values.length; ++i) {
            this.values.add(values[i]);
        }
    }

    public void removeValues() {
        this.modified();
        this.values.clear();
    }

    public void updateValue(Object newvalue) {
        this.modified();
        if (!this.values.remove(newvalue)) {
            throw new RuntimeException("Value could not be updated, value not found: " + newvalue);
        }
        this.values.add(newvalue);
    }

    public Object getValue(Object oldval) {
        if (this.modified) {
            int index = this.values.indexOf(oldval);
            if (index != -1) {
                return this.values.get(index);
            }
            throw new RuntimeException("Value cannot be retrieved, old value not found: " + oldval);
        }
        return this.paramset.getValue(oldval);
    }

    public boolean containsValue(Object value) {
        if (this.modified) {
            return this.values.contains(value);
        }
        return this.paramset.containsValue(value);
    }

    public Object[] getValues() {
        if (this.modified) {
            return this.values.toArray((Object[])Array.newInstance(SReflect.getWrappedType(this.getClazz()), this.values.size()));
        }
        return this.paramset.getValues();
    }

    public int size() {
        if (this.modified) {
            return this.values.size();
        }
        return this.paramset.size();
    }

    public boolean isModified() {
        return this.modified;
    }

    public Class getClazz() {
        return this.paramset.getClazz();
    }

    public void checkReadAccess() {
    }

    public void checkWriteAccess() {
    }

    public void setInitialValues() {
    }

    protected void modified() {
        if (!this.modified) {
            this.modified = true;
            ArrayList ovals = ((RParameterSet)this.paramset.getOriginalElement()).values;
            this.values = ovals != null ? (ArrayList)ovals.clone() : SCollection.createArrayList();
        }
    }

    protected void copyContent() {
        if (this.modified) {
            this.paramset.removeValues();
            Object[] values = this.getValues();
            for (int i = 0; i < values.length; ++i) {
                this.paramset.addValue(values[i]);
            }
        }
    }
}

