/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMGoal;
import jadex.model.IMParameter;
import jadex.model.IMReferenceableElement;
import jadex.runtime.ICandidateInfo;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RProcessGoalParameter;
import jadex.runtime.impl.RProcessGoalParameterSet;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.agenda.goals.DropGoalAction;
import jadex.runtime.impl.agenda.goals.GoalLifecycleStatePrecondition;
import jadex.util.collection.SCollection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class RProcessGoal
extends RReferenceableElement
implements IRParameterElement {
    public static final String PROCESS_STATE_IN_PROCESS = "in_process";
    public static final String PROCESS_STATE_FAILED = "failed";
    public static final String PROCESS_STATE_SUCCEEDED = "succeeded";
    public static final String PROCESS_STATE_ABORTED_ON_FAILURE = "aborted_on_failure";
    public static final String PROCESS_STATE_ABORTED_ON_SUCCESS = "aborted_on_success";
    protected IRGoal propgoal;
    protected RPlan rplan;
    protected long time;
    protected List subgoals;
    protected String processingstate;
    protected Exception exception;
    protected ICandidateInfo candidateinfo;
    protected Map parameters;
    protected Map parametersets;
    protected String protectionmode;
    protected static Map procount;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RProcessGoal(IRGoal propgoal, RElement owner, ICandidateInfo cand) {
        super(propgoal != null ? RProcessGoal.createProcessGoalName(propgoal) : null, propgoal != null ? (IMReferenceableElement)propgoal.getModelElement() : ((IMCapability)owner.getScope().getModelElement()).getGoalbase().getGoal("dummy_goal"), null, owner, null, null);
        this.propgoal = propgoal;
        this.candidateinfo = cand;
        this.subgoals = SCollection.createArrayList();
        this.processingstate = PROCESS_STATE_IN_PROCESS;
        this.parameters = SCollection.createHashMap();
        this.parametersets = SCollection.createHashMap();
        if (propgoal != null) {
            IRParameter[] params = propgoal.getParameters();
            for (int i = 0; i < params.length; ++i) {
                RProcessGoalParameter paramclone = new RProcessGoalParameter(params[i], (RElement)this);
                this.parameters.put(params[i].getModelElement().getName(), paramclone);
            }
            IRParameterSet[] paramsets = propgoal.getParameterSets();
            for (int i = 0; i < paramsets.length; ++i) {
                RProcessGoalParameterSet paramclone = new RProcessGoalParameterSet(paramsets[i], (RElement)this);
                this.parametersets.put(paramsets[i].getModelElement().getName(), paramclone);
            }
        }
        this.time = System.currentTimeMillis();
        this.setParameterProtectionMode("protection_processing");
        this.init();
    }

    protected void fetchAssignToElements() {
    }

    protected void fetchStrongExports() {
    }

    public IRGoal[] getSubgoals() {
        return this.subgoals.toArray(new IRGoal[this.subgoals.size()]);
    }

    protected void addSubgoal(IRGoal subgoal) {
        if (!$assertionsDisabled && subgoal.isSubgoal()) {
            throw new AssertionError((Object)("Cannot add subgoal which has already parent! " + subgoal));
        }
        if (!$assertionsDisabled && subgoal.getScope() != this.getScope()) {
            throw new AssertionError((Object)("Cannot add subgoal from different scope! " + subgoal));
        }
        this.subgoals.add(subgoal);
        subgoal.setParent(this);
    }

    protected void removeSubgoal(IRGoal subgoal) {
        if (!$assertionsDisabled && subgoal.getParent() != this) {
            throw new AssertionError((Object)("Cannot remove subgoal (no such child)! " + subgoal));
        }
        boolean removed = this.subgoals.remove(subgoal);
        if (!$assertionsDisabled && !removed) {
            throw new AssertionError((Object)(this + ", " + subgoal));
        }
    }

    public boolean isFinished() {
        return PROCESS_STATE_SUCCEEDED.equals(this.processingstate) || PROCESS_STATE_FAILED.equals(this.processingstate) || PROCESS_STATE_ABORTED_ON_FAILURE.equals(this.processingstate) || PROCESS_STATE_ABORTED_ON_SUCCESS.equals(this.processingstate);
    }

    public boolean isSucceeded() {
        return PROCESS_STATE_SUCCEEDED.equals(this.processingstate);
    }

    public boolean isFailed() {
        return PROCESS_STATE_FAILED.equals(this.processingstate);
    }

    public boolean isAborted() {
        return PROCESS_STATE_ABORTED_ON_FAILURE.equals(this.processingstate) || PROCESS_STATE_ABORTED_ON_SUCCESS.equals(this.processingstate);
    }

    public boolean isAbortedOnSuccess() {
        return PROCESS_STATE_ABORTED_ON_SUCCESS.equals(this.processingstate);
    }

    public void fail(Exception reason) {
        this.setException(reason);
        this.drop(PROCESS_STATE_FAILED);
    }

    public void succeed() {
        this.drop(PROCESS_STATE_SUCCEEDED);
    }

    public void abort(boolean aborted_on_success) {
        if (aborted_on_success) {
            this.drop(PROCESS_STATE_ABORTED_ON_SUCCESS);
        } else {
            this.drop(PROCESS_STATE_ABORTED_ON_FAILURE);
        }
    }

    public IRGoal getProprietaryGoal() {
        return this.propgoal;
    }

    public long getExecutionTime() {
        return this.time;
    }

    public String getProcessingState() {
        if (!$assertionsDisabled && this.processingstate == null) {
            throw new AssertionError();
        }
        return this.processingstate;
    }

    protected void setProcessingState(String processingstate) {
        if (!$assertionsDisabled && !PROCESS_STATE_IN_PROCESS.equals(this.processingstate)) {
            throw new AssertionError((Object)(this.processingstate + ", " + this + ", planfinished: " + this.rplan.isFinished()));
        }
        if (!($assertionsDisabled || PROCESS_STATE_SUCCEEDED.equals(processingstate) || PROCESS_STATE_FAILED.equals(processingstate) || PROCESS_STATE_ABORTED_ON_FAILURE.equals(processingstate) || PROCESS_STATE_ABORTED_ON_SUCCESS.equals(processingstate))) {
            throw new AssertionError((Object)processingstate);
        }
        this.processingstate = processingstate;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setResult(Object result) {
        this.findResultParemeter().setValue(result);
    }

    public IRParameter findResultParemeter() {
        IMElement mret = null;
        IMParameter[] mparams = ((IMGoal)this.getModelElement()).getParameters();
        for (int i = 0; i < mparams.length; ++i) {
            if (!mparams[i].getDirection().equals("out") && !mparams[i].getDirection().equals("inout")) continue;
            if (mret == null) {
                mret = mparams[i];
                continue;
            }
            throw new RuntimeException("No unique out parameter: " + this);
        }
        return mret == null ? null : this.getParameter(mret.getName());
    }

    protected void setPlanInstance(RPlan rplan) {
        this.rplan = rplan;
    }

    public RPlan getPlanInstance() {
        return this.rplan;
    }

    public ICandidateInfo getCandidateInfo() {
        return this.candidateinfo;
    }

    protected void drop(String finalstate) {
        this.setProcessingState(finalstate);
        this.time = System.currentTimeMillis() - this.time;
        if (this.getProprietaryGoal() != null) {
            ((RGoal)this.getProprietaryGoal().getOriginalElement()).processGoalFinished(this);
        }
        this.rplan.terminate();
        IRGoal[] subgoals = this.getSubgoals();
        for (int i = 0; i < subgoals.length; ++i) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DropGoalAction(new GoalLifecycleStatePrecondition(subgoals[i], "adopted"), subgoals[i]), null);
        }
        this.getScope().getGoalbase().removeGoal(this);
        this.cleanup();
    }

    public Map getEncodableRepresentation() {
        Map representation = super.getEncodableRepresentation();
        representation.put("plan", this.rplan == null ? "null" : this.rplan.getName());
        representation.put("kind", "process");
        representation.put("processingstate", this.processingstate);
        if (this.propgoal != null) {
            representation.put("proprietarygoal", this.propgoal.getName());
        }
        return representation;
    }

    public String getParameterProtectionMode() {
        return this.protectionmode;
    }

    public void setParameterProtectionMode(String protectionmode) {
        this.protectionmode = protectionmode;
    }

    public IRParameter[] getParameters() {
        return this.parameters.values().toArray(new IRParameter[this.parameters.size()]);
    }

    public IRParameterSet[] getParameterSets() {
        return this.parametersets.values().toArray(new IRParameterSet[this.parametersets.size()]);
    }

    public IRParameter getParameter(String name) {
        IRParameter ret = (IRParameter)this.parameters.get(name);
        if (ret == null) {
            throw new RuntimeException("No such parameter: " + name + " in " + this);
        }
        return ret;
    }

    public IRParameterSet getParameterSet(String name) {
        IRParameterSet ret = (IRParameterSet)this.parametersets.get(name);
        if (ret == null) {
            throw new RuntimeException("No such parameter set: " + name + " in " + this);
        }
        return ret;
    }

    public boolean hasParameter(String name) {
        return this.parameters.get(name) != null;
    }

    public boolean hasParameterSet(String name) {
        return this.parametersets.get(name) != null;
    }

    public Object getParameterValue(String name) {
        return this.getParameter(name).getValue();
    }

    public Object[] getParameterSetValues(String name) {
        return this.getParameterSet(name).getValues();
    }

    protected void copyContent() {
        IRParameter[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            ((RProcessGoalParameter)params[i]).copyContent();
        }
        IRParameterSet[] paramsets = this.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            ((RProcessGoalParameterSet)paramsets[i]).copyContent();
        }
    }

    public boolean isAdopted() {
        return this.getPlanInstance() != null && this.getPlanInstance().isAlive();
    }

    protected static String createProcessGoalName(IRGoal goal) {
        Integer cnt = (Integer)procount.get(goal);
        cnt = cnt == null ? new Integer(1) : new Integer(cnt + 1);
        procount.put(goal, cnt);
        return goal.getName() + "_" + cnt;
    }

    static {
        $assertionsDisabled = !RProcessGoal.class.desiredAssertionStatus();
        procount = new WeakHashMap();
    }
}

