/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCapability;
import jadex.model.IMCondition;
import jadex.model.IMConfigParameter;
import jadex.model.IMConfigPlan;
import jadex.model.IMConfigPlanbase;
import jadex.model.IMConfiguration;
import jadex.model.IMInternalEvent;
import jadex.model.IMPlan;
import jadex.model.IMPlanTrigger;
import jadex.model.IMPlanbase;
import jadex.model.IMReferenceableElement;
import jadex.model.ISystemEventTypes;
import jadex.runtime.IFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.BeliefChangeCondition;
import jadex.runtime.impl.BeliefSetChangeCondition;
import jadex.runtime.impl.BindingHelper;
import jadex.runtime.impl.CandidateInfo;
import jadex.runtime.impl.IInterpreterCondition;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.PlanInfo;
import jadex.runtime.impl.PlanInstanceInfo;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RBindingCondition;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RInternalEvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.impl.WaitqueueInfo;
import jadex.runtime.impl.agenda.conditions.ConditionDefaultPrecondition;
import jadex.runtime.impl.agenda.plans.PlanCreationAction;
import jadex.util.SReflect;
import jadex.util.collection.IndexMap;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.NestedMap;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RPlanbase
extends RBase {
    protected IndexMap plans = SCollection.createIndexMap();
    protected Map actfilters = SCollection.createHashMap();
    protected Map executors = SCollection.createHashMap();
    protected Map bindings = SCollection.createHashMap();
    protected MultiCollection conditions = SCollection.createMultiCollection();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RPlanbase(IMPlanbase model, RElement owner) {
        super(null, model, owner);
    }

    protected void init(int level) {
        IMConfigPlanbase initialbase;
        IMConfiguration is;
        if (level == 0) {
            IMPlanbase model = (IMPlanbase)this.getModelElement();
            IMPlan[] mplans = model.getPlans();
            for (int i = 0; i < mplans.length; ++i) {
                this.registerPlan(mplans[i]);
            }
        }
        if (level == 1 && (is = this.getScope().getConfiguration()) != null && (initialbase = is.getPlanbase()) != null) {
            this.instantiateConfigPlans(initialbase.getInitialPlans());
        }
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        for (int i = 0; i < this.plans.size(); ++i) {
            ((RPlan)this.plans.get(i)).cleanup();
        }
        Iterator i = this.bindings.values().iterator();
        while (i.hasNext()) {
            ((BindingHelper)i.next()).cleanup();
        }
        IInterpreterCondition[] conds = (IInterpreterCondition[])this.conditions.getObjects(IInterpreterCondition.class);
        for (int i2 = 0; i2 < conds.length; ++i2) {
            conds[i2].cleanup();
        }
    }

    public RPlan[] getPlans() {
        return (RPlan[])this.plans.getObjects(RPlan.class);
    }

    public RPlan getPlan(String name) {
        return (RPlan)this.plans.get(name);
    }

    public RPlan[] getPlans(String type) {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.plans.size(); ++i) {
            RPlan tmp = (RPlan)this.plans.get(i);
            if (!tmp.getType().equals(type)) continue;
            ret.add(tmp);
        }
        return ret.toArray(new RPlan[ret.size()]);
    }

    public List getState(String[] types) {
        ArrayList ret = SCollection.createArrayList();
        if (ISystemEventTypes.Subtypes.isSubtype("BDI_planAdded", types)) {
            RPlan[] pls = this.getPlans();
            for (int i = 0; i < pls.length; ++i) {
                ret.add(new SystemEvent("BDI_planAdded", pls[i]));
            }
        }
        return ret;
    }

    public void registerPlan(IMPlan mplan) {
        IMPlanTrigger trigger = mplan.getTrigger();
        IFilter filter = new WaitAbstraction(this.getScope()).createFilter(trigger);
        if (filter != null) {
            this.actfilters.put(mplan, filter);
        }
        BindingHelper binding = null;
        if (mplan.getBindingParameters().length > 0) {
            binding = new BindingHelper(mplan, this, trigger != null && trigger.getCondition() != null);
            this.bindings.put(mplan, binding);
        }
        if (trigger != null) {
            IMCondition cond = trigger.getCondition();
            if (cond != null) {
                RBindingCondition creation = (RBindingCondition)this.getScope().getExpressionbase().createInternalCondition(cond, this, null, binding);
                this.conditions.put(mplan, creation);
                creation.setAction(new PlanCreationAction(this, new ConditionDefaultPrecondition(creation), mplan));
                creation.setTraceMode("always");
            }
            String[] belchanges = trigger.getBeliefChanges();
            for (int i = 0; i < belchanges.length; ++i) {
                IRBelief bel = this.getScope().getBeliefbase().getBelief(belchanges[i]);
                if (bel == null) {
                    throw new RuntimeException("Belief not found: " + belchanges[i]);
                }
                PlanCreationAction pcact = new PlanCreationAction(this, null, mplan);
                BeliefChangeCondition rcond = new BeliefChangeCondition(bel, bel.getFact(), pcact);
                rcond.setTraceMode("always");
                this.conditions.put(mplan, rcond);
            }
            MultiCollection eventtypes = SCollection.createMultiCollection();
            HashMap oldvals = SCollection.createHashMap();
            String[] belsetchanges = trigger.getBeliefSetChanges();
            for (int i = 0; i < belsetchanges.length; ++i) {
                IRBeliefSet belset = this.getScope().getBeliefbase().getBeliefSet(belsetchanges[i]);
                if (belset == null) {
                    throw new RuntimeException("Beliefset not found: " + belsetchanges[i]);
                }
                eventtypes.put(belset, "BDI_bsfactsChanged");
                oldvals.put(belset, belset.getFacts());
            }
            String[] factadditions = trigger.getFactAddedTriggers();
            for (int i = 0; i < factadditions.length; ++i) {
                IRBeliefSet belset = this.getScope().getBeliefbase().getBeliefSet(factadditions[i]);
                if (belset == null) {
                    throw new RuntimeException("Beliefset not found: " + factadditions[i]);
                }
                eventtypes.put(belset, "BDI_bsfactAdded");
            }
            String[] factremovals = trigger.getFactRemovedTriggers();
            for (int i = 0; i < factremovals.length; ++i) {
                IRBeliefSet belset = this.getScope().getBeliefbase().getBeliefSet(factremovals[i]);
                if (belset == null) {
                    throw new RuntimeException("Beliefset not found: " + factremovals[i]);
                }
                eventtypes.put(belset, "BDI_bsfactRemoved");
            }
            IRBeliefSet[] keys = (IRBeliefSet[])eventtypes.getKeys(IRBeliefSet.class);
            for (int i = 0; i < keys.length; ++i) {
                Collection col = (Collection)eventtypes.get(keys[i]);
                PlanCreationAction act = new PlanCreationAction(this, null, mplan);
                BeliefSetChangeCondition rcond = new BeliefSetChangeCondition(keys[i], (Object[])oldvals.get(keys[i]), col.toArray(new String[col.size()]), act);
                rcond.setTraceMode("always");
                this.conditions.put(mplan, rcond);
            }
        }
    }

    public void deregisterPlan(IMPlan mplan) {
        this.leaveRunningState(mplan);
        this.actfilters.remove(mplan);
    }

    public boolean checkPlanApplicability(PlanInfo cand, IREvent event, Set excludes) {
        boolean ret = false;
        if (excludes == null || !excludes.contains(cand)) {
            IMPlan plan = cand.getPlanModel();
            NestedMap params = cand.getBinding() == null ? SCollection.createNestedMap(this.getExpressionParameters()) : SCollection.createNestedMap(new Map[]{cand.getBinding(), this.getExpressionParameters()});
            params.put("$event", event);
            if (event instanceof IRGoalEvent) {
                params.put("$goal", ((IRGoalEvent)event).getGoal());
            }
            try {
                if (plan.getPrecondition() == null || ((Boolean)plan.getPrecondition().getTerm().getValue(params)).booleanValue()) {
                    ret = true;
                }
            }
            catch (Exception e) {
                this.getScope().getLogger().warning("Precondition could not be evaluated: " + plan.getPrecondition());
            }
        }
        return ret;
    }

    protected List generateBindingCandidates(IMConfigPlan state, IMPlan plan, IREvent event, Set excludes) {
        ArrayList candidates = SCollection.createArrayList();
        BindingHelper bh = (BindingHelper)this.bindings.get(plan);
        if (bh != null) {
            String[] names = null;
            Object[] vals = null;
            if (state != null) {
                IMConfigParameter[] inips = state.getParameters();
                names = new String[inips.length];
                vals = new Object[inips.length];
                for (int i = 0; i < inips.length; ++i) {
                    Object value = this.getScope().getExpressionbase().evaluateInternalExpression(inips[i].getInitialValue(), this);
                    names[i] = inips[i].getOriginalElement().getName();
                    vals[i] = new Object[]{value};
                }
            }
            List bindings = bh.calculateBindings(event, names, vals);
            Iterator j = bindings.iterator();
            while (j.hasNext()) {
                Map binding = (Map)j.next();
                PlanInfo cand = new PlanInfo(state, event, plan, binding);
                if (!this.checkPlanApplicability(cand, event, excludes)) continue;
                candidates.add(cand);
            }
        } else {
            PlanInfo cand = new PlanInfo(state, event, plan, null);
            if (this.checkPlanApplicability(cand, event, excludes)) {
                candidates.add(cand);
            }
        }
        return candidates;
    }

    protected RReferenceableElement getElementInstance(IMReferenceableElement melement, RReferenceableElement creator) {
        throw new RuntimeException("Base does not support referenceable elements!: " + this.getName());
    }

    protected RBase getCorrespondingBase(RCapability scope) {
        return scope.getPlanbase();
    }

    protected void addPlan(RPlan plan) {
        this.plans.add(plan.getName(), (Object)plan);
    }

    public void removePlan(RPlan plan) {
        plan = (RPlan)this.plans.removeKey(plan.getName());
        if (!$assertionsDisabled && plan == null) {
            throw new AssertionError();
        }
        plan.throwSystemEvent("BDI_planRemoved");
        plan.cleanup();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.name);
        sb.append("\nplans=\n");
        for (int i = 0; i < this.plans.size(); ++i) {
            sb.append("  ");
            sb.append(this.plans.get(i));
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    public RPlan createPlan(String name, IMPlan plan, IMConfigPlan state, Map binding, RProcessGoal processgoal, IREvent event) {
        return new RPlan(name, plan, this, state, null, binding, processgoal, event);
    }

    public IFilter getPassivePlanActivationFilter(IMPlan mplan) {
        return (IFilter)this.actfilters.get(mplan);
    }

    public BindingHelper getPassivePlanBindings(IMPlan mplan) {
        return (BindingHelper)this.bindings.get(mplan);
    }

    public static RPlan scheduleCandidate(CandidateInfo cand) {
        RPlan rplan;
        if (!$assertionsDisabled && cand == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || cand instanceof PlanInfo || cand instanceof PlanInstanceInfo || cand instanceof WaitqueueInfo)) {
            throw new AssertionError();
        }
        IREvent event = cand.getEventInstance();
        if (cand instanceof PlanInfo) {
            rplan = cand.getPlanInstance();
            rplan.adopt();
            rplan.getScope().getGoalbase().addProcessGoal(rplan.getRootGoal());
        } else if (cand instanceof PlanInstanceInfo) {
            if (event instanceof IRGoalEvent && !((IRGoalEvent)event).isInfo()) {
                event.getScope().getLogger().severe("Dispatching goal to running plan not allowed: " + cand + ", " + event);
            }
            rplan = cand.getPlanInstance();
            rplan.assignNewEvent(event);
        } else {
            if (event instanceof IRGoalEvent && !((IRGoalEvent)event).isInfo()) {
                event.getScope().getLogger().severe("Dispatching goal to waitqueue not allowed: " + cand + ", " + event);
            }
            WaitqueueInfo winfo = (WaitqueueInfo)cand;
            rplan = winfo.getPlanInstance();
            rplan.getWaitqueue().addEvent(winfo.getEventInstance());
        }
        if (!(cand instanceof WaitqueueInfo)) {
            rplan.schedule(null);
        }
        return rplan;
    }

    public void exitRunningState() {
        IMPlan[] plans = ((IMPlanbase)this.getModelElement()).getPlans();
        for (int i = 0; i < plans.length; ++i) {
            this.leaveRunningState(plans[i]);
        }
    }

    public void activateEndState() {
        IMConfigPlanbase planbase;
        IMConfiguration config = this.getScope().getConfiguration();
        if (config != null && (planbase = config.getPlanbase()) != null) {
            this.instantiateConfigPlans(planbase.getEndPlans());
        }
    }

    protected void instantiateConfigPlans(IMConfigPlan[] configplans) {
        for (int i = 0; i < configplans.length; ++i) {
            IMPlan mplan = (IMPlan)configplans[i].getOriginalElement();
            List candidates = this.generateBindingCandidates(configplans[i], mplan, null, null);
            RCapability cap = this.getScope();
            for (int j = 0; j < candidates.size(); ++j) {
                IMInternalEvent mevent = ((IMCapability)cap.getModelElement()).getEventbase().getInternalEvent("InternalEvent_execute_plan");
                RInternalEvent event = this.getScope().getEventbase().createInternalEvent(mevent);
                ((PlanInfo)candidates.get(j)).setEvent(event);
                RPlanbase.scheduleCandidate((PlanInfo)candidates.get(j));
            }
        }
    }

    public void leaveRunningState(IMPlan plan) {
        RPlan[] plans = this.getPlans(plan.getName());
        for (int i = 0; i < plans.length; ++i) {
            if (this.isProtected(plans[i])) continue;
            plans[i].terminate();
        }
        BindingHelper bh = (BindingHelper)this.bindings.remove(plan);
        if (bh != null) {
            bh.cleanup();
        }
        List pcs = (List)this.conditions.remove(plan);
        for (int i = 0; pcs != null && i < pcs.size(); ++i) {
            ((IInterpreterCondition)pcs.get(i)).cleanup();
        }
    }

    public boolean isEndStateTerminated() {
        return this.plans.size() == 0;
    }

    static {
        $assertionsDisabled = !RPlanbase.class.desiredAssertionStatus();
    }
}

