/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigPlan;
import jadex.model.IMPlan;
import jadex.runtime.BDIFailureException;
import jadex.runtime.IFilter;
import jadex.runtime.IPlanExecutor;
import jadex.runtime.impl.IEncodable;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.IRInternalEvent;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RCondition;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RParameterElement;
import jadex.runtime.impl.RPlanParameter;
import jadex.runtime.impl.RPlanParameterSet;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.impl.Waitqueue;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.plans.ExecutePlanStepAction;
import jadex.runtime.impl.agenda.plans.PlanTerminationAction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;

public class RPlan
extends RParameterElement {
    public static final String PROPERTY_PLAN_EXECUTOR = "planexecutor";
    public static final String PROPERTY_LOGGING_LEVEL_EXCEPTIONS = "logging.level.exceptions";
    public static final String STATE_INITIAL = "initial";
    public static final String STATE_BODY = "body";
    public static final String STATE_PASSED = "passed";
    public static final String STATE_FAILED = "failed";
    public static final String STATE_ABORTED = "aborted";
    protected Object body;
    protected IPlanExecutor exe;
    protected IREvent initialevent;
    protected IREvent event;
    protected RProcessGoal rootgoal;
    protected RCondition contextcondition;
    protected WaitAbstraction waitabs;
    protected WaitAbstraction lastwaitabs;
    protected Waitqueue waitqueue;
    protected boolean alive;
    protected int monitor_consequences;
    protected int agenda_state;
    protected Exception exception;
    protected String state;
    boolean scheduled;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RPlan(String name, IMPlan plan, RElement owner, IMConfigPlan state, RReferenceableElement creator, Map exparams, RProcessGoal goal, IREvent initialevent) {
        super(name, plan, state, owner, creator, exparams);
        this.rootgoal = goal;
        this.initialevent = initialevent;
        this.state = STATE_INITIAL;
        this.setExpressionParameter("$plan", this);
        this.setExpressionParameter("$event", initialevent);
        if (initialevent instanceof IRGoalEvent) {
            this.setExpressionParameter("$goal", ((IRGoalEvent)initialevent).getGoal());
        }
        this.assignNewEvent(initialevent);
        IRParameterElement target = initialevent instanceof IRMessageEvent || initialevent instanceof IRInternalEvent ? initialevent : goal;
        if (target != null) {
            IRParameter[] params = this.getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof RPlanParameter) || !((RPlanParameter)params[i]).isConnectable()) continue;
                ((RPlanParameter)params[i]).connect(target);
            }
            IRParameterSet[] paramsets = this.getParameterSets();
            for (int i = 0; i < paramsets.length; ++i) {
                if (!(paramsets[i] instanceof RPlanParameterSet) || !((RPlanParameterSet)paramsets[i]).isConnectable()) continue;
                ((RPlanParameterSet)paramsets[i]).connect(target);
            }
        }
        this.setParameterProtectionMode("protection_processing");
    }

    public void adopt() {
        this.getScope().getPlanbase().addPlan(this);
        IMPlan plan = (IMPlan)this.getModelElement();
        if (plan.getContextCondition() != null) {
            this.contextcondition = this.getScope().getExpressionbase().createInternalCondition(plan.getContextCondition(), this, new PlanTerminationAction(this, new IAgendaActionPrecondition(){

                public boolean check() {
                    return RPlan.this.state.equals(RPlan.STATE_INITIAL) || RPlan.this.state.equals(RPlan.STATE_BODY);
                }
            }), null);
            this.contextcondition.setTraceMode("once");
        }
        this.alive = true;
        String type = plan.getBody().getType();
        this.exe = (IPlanExecutor)this.getScope().getPropertybase().getProperty("planexecutor." + type);
        if (this.exe == null) {
            throw new RuntimeException("No plan executor found for plan: " + plan + ", type=" + type);
        }
        if (plan.getWaitqueue() != null) {
            this.getWaitqueue().addFilter(this.getWaitqueue().createFilter(plan.getWaitqueue()));
        }
        this.throwSystemEvent("BDI_planAdded");
    }

    public void cleanup() {
        if (this.exe != null) {
            this.exe.cleanup(this);
        }
        this.assignNewEvent(null);
        this.scheduled = false;
        if (this.contextcondition != null) {
            this.contextcondition.cleanup();
        }
        super.cleanup();
    }

    public RCondition getContextCondition() {
        return this.contextcondition;
    }

    public Object createBody() throws Exception {
        if (!this.state.equals(STATE_BODY)) {
            throw new RuntimeException("Plan body must be created in the first plan step: " + this + ", " + this.getState());
        }
        if (this.body != null) {
            throw new RuntimeException("Plan body already exists: " + this);
        }
        this.body = this.exe.createPlanBody(this);
        this.throwSystemEvent("BDI_planChanged");
        return this.body;
    }

    public Object getBody() {
        return this.body;
    }

    public IPlanExecutor getPlanExecutor() {
        return this.exe;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getState() {
        return this.state;
    }

    public void executePlanStep() {
        Exception ex;
        boolean interrupted;
        RCapability cap;
        block30: {
            cap = this.getScope();
            interrupted = false;
            ex = null;
            if (!$assertionsDisabled && cap.getAgent().getCurrentPlan() != null) {
                throw new AssertionError();
            }
            cap.getAgent().setCurrentPlan(this);
            try {
                this.scheduled = false;
                if (this.state.equals(STATE_INITIAL)) {
                    this.state = STATE_BODY;
                }
                if (this.state.equals(STATE_BODY)) {
                    interrupted = this.exe.executePlanStep(this);
                } else if (this.state.equals(STATE_PASSED)) {
                    interrupted = this.exe.executePassedStep(this);
                } else if (this.state.equals(STATE_FAILED)) {
                    interrupted = this.exe.executeFailedStep(this);
                } else if (this.state.equals(STATE_ABORTED)) {
                    interrupted = this.exe.executeAbortedStep(this);
                }
            }
            catch (Exception e) {
                ex = e;
                if (!(e instanceof BDIFailureException)) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    Level level = (Level)cap.getPropertybase().getProperty(PROPERTY_LOGGING_LEVEL_EXCEPTIONS);
                    cap.getLogger().log(level, cap.getAgent().getName() + ": Exception while executing: " + this + "\n" + sw);
                }
                if (this.getRootGoal().getProprietaryGoal() != null) break block30;
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                cap.getLogger().warning(cap.getAgent().getName() + ": Exception while executing: " + this + "\n" + sw);
            }
        }
        cap.getAgent().setCurrentPlan(null);
        if (!this.isScheduled()) {
            this.event = null;
        }
        if (cap.getAgent().isAtomic()) {
            if (!$assertionsDisabled && interrupted) {
                throw new AssertionError((Object)"When atomic, plan shouldn't be interrupted.");
            }
            if (ex == null) {
                cap.getLogger().log(Level.SEVERE, cap.getAgent().getName() + ": Atomic block not finished: " + this);
                ex = new RuntimeException("Atomic block not finished.");
            }
            cap.getAgent().endAtomic();
        }
        if (ex != null && this.state.equals(STATE_BODY)) {
            if (!$assertionsDisabled && (this.getWaitAbstraction() != null || this.isScheduled())) {
                throw new AssertionError((Object)("When exception, plan shouldn't be waiting: " + ex + ", " + this.getWaitAbstraction() + ", " + this.isScheduled()));
            }
            if (!$assertionsDisabled && interrupted) {
                throw new AssertionError((Object)("When exception, plan shouldn't be interrupted: " + ex));
            }
            this.exception = ex;
            this.state = STATE_FAILED;
            if (this.contextcondition != null) {
                this.contextcondition.setTraceMode("never");
            }
            this.schedule(null);
        } else if (interrupted && !this.isScheduled()) {
            this.schedule(null);
        } else if (this.getWaitAbstraction() == null && !this.isScheduled()) {
            if (this.state.equals(STATE_BODY)) {
                this.state = STATE_PASSED;
                if (this.contextcondition != null) {
                    this.contextcondition.setTraceMode("never");
                }
                this.schedule(null);
            } else {
                if (!this.getRootGoal().isFinished()) {
                    if (this.exception != null) {
                        this.getRootGoal().fail(this.exception);
                    } else {
                        this.getRootGoal().succeed();
                    }
                }
                this.getScope().getPlanbase().removePlan(this);
                this.alive = false;
            }
        }
    }

    public void interruptPlanStep() {
        if (!$assertionsDisabled && this.state.equals(STATE_INITIAL)) {
            throw new AssertionError(this);
        }
        this.exe.interruptPlanStep(this);
    }

    public void schedule(Object event) {
        this.scheduled = true;
        this.getScope().getAgent().getInterpreter().addAgendaEntry(new ExecutePlanStepAction(this), event != null ? event : this);
    }

    public IFilter waitFor(WaitAbstraction wa) {
        if (!this.isAlive()) {
            return null;
        }
        boolean dispatched = false;
        if (wa.getFilter() != null) {
            IREvent[] events = this.getWaitqueue().getEvents();
            for (int i = 0; i < events.length && !dispatched; ++i) {
                if (!this.getScope().getAgent().applyFilter(wa.getFilter(), events[i])) continue;
                this.getWaitqueue().removeEvent(events[i]);
                this.assignNewEvent(events[i]);
                this.schedule(events[i]);
                dispatched = true;
            }
        }
        if (!dispatched) {
            this.setWaitAbstraction(wa);
        }
        return wa.getFilter();
    }

    public RProcessGoal getRootGoal() {
        return this.rootgoal;
    }

    public IREvent getInitialEvent() {
        return this.initialevent;
    }

    public IREvent getLatestEvent() {
        return this.event;
    }

    public void assignNewEvent(IREvent event) {
        if (this.event != null && !this.event.isCleanedup()) {
            this.event.cleanup();
        }
        this.event = event;
        this.setWaitAbstraction(null);
        this.throwSystemEvent("BDI_planChanged");
    }

    public WaitAbstraction getWaitAbstraction() {
        return this.waitabs;
    }

    public void setWaitAbstraction(WaitAbstraction waitabs) {
        this.lastwaitabs = this.waitabs;
        this.waitabs = waitabs;
        if (this.lastwaitabs != null) {
            this.lastwaitabs.cleanup();
        }
        this.throwSystemEvent("BDI_planChanged");
    }

    public WaitAbstraction getLastWaitAbstraction() {
        return this.lastwaitabs;
    }

    public Waitqueue getWaitqueue() {
        if (this.waitqueue == null) {
            this.waitqueue = new Waitqueue(this);
        }
        return this.waitqueue;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isFinished() {
        return this.getWaitAbstraction() == null && !this.isScheduled();
    }

    public void terminate() {
        if (!$assertionsDisabled && !this.isAlive()) {
            throw new AssertionError();
        }
        if (this.contextcondition != null) {
            this.contextcondition.setTraceMode("never");
        }
        if (!this.getRootGoal().isFinished()) {
            this.getRootGoal().drop("aborted_on_failure");
        } else if (this.state.equals(STATE_BODY)) {
            this.state = STATE_ABORTED;
            this.schedule(null);
            this.setWaitAbstraction(null);
        } else if (this.state.equals(STATE_INITIAL)) {
            this.getScope().getPlanbase().removePlan(this);
            this.alive = false;
        }
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public Thread getThread() {
        return this.exe.getExecutionThread(this);
    }

    public void startMonitorConsequences() {
        ++this.monitor_consequences;
        if (this.monitor_consequences == 1) {
            this.agenda_state = this.getScope().getAgent().getInterpreter().getAgendaState();
        }
    }

    public void endMonitorConsequences() {
        if (!$assertionsDisabled && this.monitor_consequences <= 0) {
            throw new AssertionError();
        }
        --this.monitor_consequences;
        if (this.monitor_consequences == 0 && this.agenda_state != this.getScope().getAgent().getInterpreter().getAgendaState()) {
            if (!$assertionsDisabled && !this.alive) {
                throw new AssertionError(this);
            }
            this.interruptPlanStep();
        }
    }

    public void resetMonitorConsequences() {
        this.monitor_consequences = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RPlan(name=");
        sb.append(this.getName());
        sb.append(")");
        return sb.toString();
    }

    public Map getEncodableRepresentation() {
        IFilter filter;
        Map representation = super.getEncodableRepresentation();
        representation.put("rootgoal", this.getRootGoal().getName());
        if (this.getRootGoal() != null && this.getRootGoal().getProprietaryGoal() != null) {
            RReferenceableElement propgoal = this.getRootGoal().getProprietaryGoal().getOriginalElement();
            representation.put("proprietarygoal", propgoal.getName());
            representation.put("proprietarygoalscope", propgoal.getScope().getDetailName());
        }
        representation.put("latestevent", this.getLatestEvent() == null ? "null" : ((RReferenceableElement)((Object)this.getLatestEvent())).getEncodableRepresentation());
        IFilter iFilter = filter = this.getWaitAbstraction() == null ? null : this.getWaitAbstraction().getFilter();
        representation.put("filter", filter == null ? "null" : (filter instanceof IEncodable ? ((IEncodable)((Object)filter)).getEncodableRepresentation() : "" + filter));
        representation.put("state", "" + this.state);
        representation.put(STATE_BODY, "" + this.body);
        representation.put("waitqueue", "" + this.waitqueue);
        return representation;
    }

    public void throwSystemEvent(String event) {
        if (this.isAlive()) {
            super.throwSystemEvent(event);
        }
    }

    static {
        $assertionsDisabled = !RPlan.class.desiredAssertionStatus();
    }
}

