/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigGoal;
import jadex.model.IMPerformGoal;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.easydeliberation.DeactivateInhibitedGoalsAction;
import jadex.runtime.impl.agenda.easydeliberation.DeliberateInhibitedGoalsReactivationAction;
import jadex.runtime.impl.agenda.goals.GoalFinishedAction;
import jadex.runtime.impl.agenda.goals.GoalProcessingStatePrecondition;
import jadex.runtime.impl.agenda.goals.RetryAction;
import jadex.util.SReflect;
import jadex.util.collection.MultiCollection;
import java.util.List;
import java.util.Map;

public class RPerformGoal
extends RGoal {
    public static final String PERFORM_STATE_START = "start";
    public static final String PERFORM_STATE_PROCESSING_PAUSED = "processing_paused";
    public static final String PERFORM_STATE_IN_PROCESS = "in_process";
    public static final String PERFORM_STATE_SUCCEEDED = "succeeded";
    public static final String PERFORM_STATE_FAILED = "failed";
    protected static final MultiCollection proc_transitions;
    protected String processingstate;
    public IAgendaAction retryaction = new RetryAction(this, (IAgendaActionPrecondition)new GoalProcessingStatePrecondition(this, "processing_paused"));
    protected boolean succeeded;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RPerformGoal(String name, IMPerformGoal goal, IMConfigGoal state, RElement owner, RReferenceableElement creator, Map binding) {
        super(name, goal, state, owner, creator, binding);
        this.setProcessingState(PERFORM_STATE_START);
    }

    public boolean isFinished() {
        return PERFORM_STATE_SUCCEEDED.equals(this.processingstate) || PERFORM_STATE_FAILED.equals(this.processingstate);
    }

    public boolean isSucceeded() {
        return PERFORM_STATE_SUCCEEDED.equals(this.processingstate);
    }

    public boolean isInProcess() {
        return this.isActive() && PERFORM_STATE_IN_PROCESS.equals(this.processingstate);
    }

    public void processGoalsCreated(List pgoals) {
        super.processGoalsCreated(pgoals);
        if (!pgoals.isEmpty()) {
            this.changeProcessingState(PERFORM_STATE_IN_PROCESS);
        } else if (this.isRecur()) {
            if (!PERFORM_STATE_PROCESSING_PAUSED.equals(this.getProcessingState())) {
                this.changeProcessingState(PERFORM_STATE_PROCESSING_PAUSED);
            }
            this.scheduleRecur();
        } else {
            this.changeProcessingState(this.succeeded ? PERFORM_STATE_SUCCEEDED : PERFORM_STATE_FAILED);
            this.drop();
        }
    }

    protected void processGoalFinished(RProcessGoal procgoal) {
        super.processGoalFinished(procgoal);
        if (this.isFinished() || PERFORM_STATE_START.equals(this.processingstate)) {
            return;
        }
        if (!$assertionsDisabled && !this.isActive()) {
            throw new AssertionError(this);
        }
        boolean bl = this.succeeded = this.succeeded || PERFORM_STATE_SUCCEEDED.equals(procgoal.getProcessingState());
        if (!this.isPostToAll() && this.isRetry()) {
            if (this.getRetryDelay() > 0L) {
                this.changeProcessingState(PERFORM_STATE_PROCESSING_PAUSED);
                this.setRetryEntry(new TimetableData(this.getRetryDelay(), this.retryaction));
                this.getScope().getAgent().addTimetableEntry(this.getRetryEntry());
            } else {
                this.throwProcessEvent();
            }
        } else if (this.isProcessingFinished()) {
            if (this.isRecur()) {
                this.changeProcessingState(PERFORM_STATE_PROCESSING_PAUSED);
                this.scheduleRecur();
            } else {
                String newstate = this.succeeded ? PERFORM_STATE_SUCCEEDED : PERFORM_STATE_FAILED;
                this.getScope().getAgent().getInterpreter().addAgendaEntry(new GoalFinishedAction(this, new GoalProcessingStatePrecondition(this, PERFORM_STATE_IN_PROCESS), newstate), this);
            }
        }
    }

    public String getProcessingState() {
        if (!$assertionsDisabled && this.processingstate == null) {
            throw new AssertionError();
        }
        return this.processingstate;
    }

    protected void setProcessingState(String processingstate) {
        this.processingstate = processingstate;
        this.throwSystemEvent("BDI_goalChanged");
    }

    public void changeProcessingState(String newstate) {
        if (!$assertionsDisabled && !proc_transitions.getCollection(this.getProcessingState()).contains(newstate)) {
            throw new AssertionError((Object)("Cannot change processing state from " + this.getProcessingState() + " to " + newstate + ": " + this.getName()));
        }
        if (newstate.equals(this.getProcessingState())) {
            return;
        }
        String oldstate = this.getProcessingState();
        this.setProcessingState(newstate);
        if (oldstate.equals(PERFORM_STATE_IN_PROCESS)) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateInhibitedGoalsReactivationAction(new GoalProcessingStatePrecondition(this, PERFORM_STATE_IN_PROCESS, true), this), this);
        } else if (newstate.equals(PERFORM_STATE_IN_PROCESS)) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeactivateInhibitedGoalsAction(new GoalProcessingStatePrecondition(this, PERFORM_STATE_IN_PROCESS), this), this);
        }
    }

    protected void enterActiveState() {
        this.throwProcessEvent();
        super.enterActiveState();
    }

    protected void exitActiveState() {
        if (PERFORM_STATE_IN_PROCESS.equals(this.processingstate)) {
            this.setProcessingState(PERFORM_STATE_START);
        }
        super.exitActiveState();
    }

    protected void exitAdoptedState() {
        if (!this.isFinished()) {
            this.setProcessingState(PERFORM_STATE_FAILED);
        }
        super.exitAdoptedState();
    }

    public Map getEncodableRepresentation() {
        Map representation = super.getEncodableRepresentation();
        representation.put("processingstate", this.processingstate.equals(PERFORM_STATE_START) ? "" : this.processingstate);
        return representation;
    }

    protected String toString(int level) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(name=");
        buf.append(this.getName());
        buf.append(", type=");
        buf.append(this.getType());
        buf.append(", processingstate=");
        buf.append(this.processingstate);
        buf.append(")");
        return buf.toString();
    }

    static {
        $assertionsDisabled = !RPerformGoal.class.desiredAssertionStatus();
        proc_transitions = new MultiCollection();
        proc_transitions.put(PERFORM_STATE_START, PERFORM_STATE_IN_PROCESS);
        proc_transitions.put(PERFORM_STATE_START, PERFORM_STATE_FAILED);
        proc_transitions.put(PERFORM_STATE_START, PERFORM_STATE_PROCESSING_PAUSED);
        proc_transitions.put(PERFORM_STATE_IN_PROCESS, PERFORM_STATE_IN_PROCESS);
        proc_transitions.put(PERFORM_STATE_IN_PROCESS, PERFORM_STATE_PROCESSING_PAUSED);
        proc_transitions.put(PERFORM_STATE_IN_PROCESS, PERFORM_STATE_SUCCEEDED);
        proc_transitions.put(PERFORM_STATE_IN_PROCESS, PERFORM_STATE_FAILED);
        proc_transitions.put(PERFORM_STATE_PROCESSING_PAUSED, PERFORM_STATE_IN_PROCESS);
        proc_transitions.put(PERFORM_STATE_PROCESSING_PAUSED, PERFORM_STATE_SUCCEEDED);
        proc_transitions.put(PERFORM_STATE_PROCESSING_PAUSED, PERFORM_STATE_FAILED);
    }
}

