/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCapability;
import jadex.model.IMConfigParameterSet;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.model.IMParameterSet;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RParameterElement;
import jadex.runtime.impl.RParameterElementReference;
import jadex.runtime.impl.RParameterSetReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.RTypedElementSet;
import jadex.util.SReflect;
import java.util.Iterator;

public class RParameterSet
extends RTypedElementSet
implements IRParameterSet {
    protected IMConfigParameterSet state;

    protected RParameterSet(IMParameterSet param, IMConfigParameterSet state, RElement owner) {
        super(param.getName(), param, state, owner, null);
        this.state = state;
    }

    public void setInitialValues() {
        RParameterSetReference ref;
        RReferenceableElement root;
        boolean found = false;
        for (root = ((RParameterElement)this.getOwner()).getCreator(); root != null && root.getCreator() != null; root = root.getCreator()) {
        }
        if (root != null && root.getInitialState() != null && (ref = ((RParameterElementReference)root).getParameterSetReference(this)).getInitialState() != null) {
            found = true;
            Object[] values = ref.getInitialValues();
            for (int i = 0; values != null && i < values.length; ++i) {
                this.addValue(values[i]);
            }
            Object inivals = ref.getInitialValuesExpression();
            if (inivals instanceof IRExpression) {
                IMExpressionReference mref = ((IMCapability)this.getScope().getModelElement()).getExpressionbase().getExpressionReference("standard_expression_reference");
                inivals = this.getScope().getExpressionbase().createExpression(mref, (RReferenceableElement)inivals);
                this.setInitialValuesExpression((IRExpression)inivals);
            } else if (inivals != null) {
                Iterator ivalues = SReflect.getIterator(inivals);
                while (ivalues.hasNext()) {
                    this.addValue(ivalues.next());
                }
            }
        }
        if (!found) {
            IMExpression[] mvalues = null;
            IMExpression minivals = null;
            if (this.getInitialState() != null) {
                mvalues = ((IMConfigParameterSet)this.getInitialState()).getInitialValues();
                minivals = ((IMConfigParameterSet)this.getInitialState()).getInitialValuesExpression();
            } else {
                mvalues = ((IMParameterSet)this.getModelElement()).getDefaultValues();
                minivals = ((IMParameterSet)this.getModelElement()).getDefaultValuesExpression();
            }
            for (int i = 0; mvalues != null && i < mvalues.length; ++i) {
                this.addValue(this.getScope().getExpressionbase().evaluateInternalExpression(mvalues[i], this));
            }
            if (minivals != null) {
                if (minivals.getEvaluationMode().equals("static")) {
                    Iterator it = SReflect.getIterator(this.getScope().getExpressionbase().evaluateInternalExpression(minivals, this));
                    while (it.hasNext()) {
                        this.addValue(it.next());
                    }
                } else {
                    this.setInitialValuesExpression(this.getScope().getExpressionbase().createInternalExpression(minivals, this, this.createSystemEvent("BDI_esValuesChanged", null, -1)));
                }
            }
        }
    }

    protected void init() {
        super.init();
        this.state = null;
    }

    public void addValue(Object value) {
        if (!this.initing && ((IMParameterSet)this.getModelElement()).getDirection().equals("fixed")) {
            throw new RuntimeException("Fixed elements cannot be altered: " + this);
        }
        super.addValue(value);
    }

    public void removeValue(Object value) {
        if (!this.initing && ((IMParameterSet)this.getModelElement()).getDirection().equals("fixed")) {
            throw new RuntimeException("Fixed elements cannot be altered: " + this);
        }
        super.removeValue(value);
    }

    public void removeValues() {
        if (!this.initing && ((IMParameterSet)this.getModelElement()).getDirection().equals("fixed")) {
            throw new RuntimeException("Fixed elements cannot be altered: " + this);
        }
        super.removeValues();
    }

    public void updateValue(Object newvalue) {
        if (!this.initing && ((IMParameterSet)this.getModelElement()).getDirection().equals("fixed")) {
            throw new RuntimeException("Fixed elements cannot be altered: " + this);
        }
        super.updateValue(newvalue);
    }

    public Object getValue(Object oldval) {
        return super.getValue(oldval);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object[] getValues() {
        return super.getValues();
    }

    public String getProtectionMode() {
        String ret = null;
        if (this.getOwner() instanceof RParameterElement) {
            RParameterElement owner = (RParameterElement)this.getOwner();
            ret = owner.getParameterProtectionMode();
        }
        return ret;
    }

    public void checkReadAccess() {
        String dir = ((IMParameterSet)this.getModelElement()).getDirection();
        if ("protection_init".equals(this.getProtectionMode()) && dir.equals("in")) {
            throw new RuntimeException("Read access not allowed to parameter set: " + ((IMParameterSet)this.getModelElement()).getDirection() + " " + this.getName());
        }
    }

    public void checkWriteAccess() {
        boolean ret = true;
        String dir = ((IMParameterSet)this.getModelElement()).getDirection();
        if ("protection_init".equals(this.getProtectionMode()) && dir.equals("out")) {
            throw new RuntimeException("Read access not allowed to parameter set: " + ((IMParameterSet)this.getModelElement()).getDirection() + " " + this.getName());
        }
        if ("protection_processing".equals(this.getProtectionMode()) && dir.equals("in")) {
            throw new RuntimeException("Read access not allowed to parameter set: " + ((IMParameterSet)this.getModelElement()).getDirection() + " " + this.getName());
        }
    }

    public void throwSystemEvent(SystemEvent event) {
        if ("protection_processing".equals(this.getProtectionMode())) {
            super.throwSystemEvent(event);
        }
    }
}

