/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigParameterElement;
import jadex.model.IMParameterElementReference;
import jadex.model.IMParameterReference;
import jadex.model.IMParameterSetReference;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RElementReference;
import jadex.runtime.impl.RParameter;
import jadex.runtime.impl.RParameterReference;
import jadex.runtime.impl.RParameterSet;
import jadex.runtime.impl.RParameterSetReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.collection.SCollection;
import java.util.HashMap;
import java.util.Map;

public class RParameterElementReference
extends RElementReference
implements IRParameterElement {
    protected Map parameterrefs;
    protected Map parametersetrefs;

    protected RParameterElementReference(String name, IMParameterElementReference modelelement, IMConfigParameterElement state, RElement owner, RReferenceableElement creator) {
        super(name, modelelement, state, owner, creator);
        this.createParameters();
    }

    protected void init() {
        super.init();
        IRParameter[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            ((RParameterReference)params[i]).init();
        }
        IRParameterSet[] paramsets = this.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            ((RParameterSetReference)paramsets[i]).init();
        }
    }

    protected void createParameters() {
        IMParameterElementReference modelelement = (IMParameterElementReference)this.getModelElement();
        IMConfigParameterElement state = (IMConfigParameterElement)this.getInitialState();
        IMParameterReference[] params = modelelement.getParameterReferences();
        if (this.parameterrefs == null) {
            this.parameterrefs = SCollection.createHashMap();
        }
        for (int i = 0; i < params.length; ++i) {
            RParameterReference param = new RParameterReference(params[i], state != null ? state.getParameter(params[i]) : null, (RElement)this);
            this.parameterrefs.put(params[i].getName(), param);
        }
        IMParameterSetReference[] paramsets = modelelement.getParameterSetReferences();
        if (this.parametersetrefs == null) {
            this.parametersetrefs = SCollection.createHashMap();
        }
        for (int i = 0; i < paramsets.length; ++i) {
            RParameterSetReference param = new RParameterSetReference(paramsets[i], state != null ? state.getParameterSet(paramsets[i]) : null, (RElement)this);
            this.parametersetrefs.put(paramsets[i].getName(), param);
        }
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        IRParameter[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            params[i].cleanup();
        }
        IRParameterSet[] paramsets = this.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            paramsets[i].cleanup();
        }
    }

    public String getParameterProtectionMode() {
        return ((IRParameterElement)((Object)this.getReferencedElement())).getParameterProtectionMode();
    }

    public IRParameter[] getParameters() {
        if (this.parameterrefs == null) {
            return new IRParameter[0];
        }
        return this.parameterrefs.values().toArray(new IRParameter[this.parameterrefs.size()]);
    }

    public IRParameterSet[] getParameterSets() {
        if (this.parametersetrefs == null) {
            return new IRParameterSet[0];
        }
        return this.parametersetrefs.values().toArray(new IRParameterSet[this.parametersetrefs.size()]);
    }

    public IRParameter getParameter(String name) {
        if (this.parameterrefs != null && this.parameterrefs.containsKey(name)) {
            return (IRParameter)this.parameterrefs.get(name);
        }
        throw new RuntimeException("No such parameter: " + name + " in " + this);
    }

    public IRParameterSet getParameterSet(String name) {
        if (this.parametersetrefs != null && this.parametersetrefs.containsKey(name)) {
            return (IRParameterSet)this.parametersetrefs.get(name);
        }
        throw new RuntimeException("No such parameter set: " + name + " in " + this);
    }

    public boolean hasParameter(String name) {
        return this.parameterrefs != null && this.parameterrefs.containsKey(name);
    }

    public boolean hasParameterSet(String name) {
        return this.parametersetrefs != null && this.parametersetrefs.containsKey(name);
    }

    public Object getParameterValue(String name) {
        return this.getParameter(name).getValue();
    }

    public Object[] getParameterSetValues(String name) {
        return this.getParameterSet(name).getValues();
    }

    protected RParameterReference getParameterReference(RParameter parameter) {
        RParameterReference ret = null;
        IRParameter[] params = this.getParameters();
        for (int i = 0; i < params.length && ret == null; ++i) {
            RParameterReference test = (RParameterReference)params[i];
            if (test.getOriginalElement() != parameter) continue;
            ret = test;
        }
        return ret;
    }

    protected RParameterSetReference getParameterSetReference(RParameterSet parameterset) {
        RParameterSetReference ret = null;
        IRParameterSet[] paramsets = this.getParameterSets();
        for (int i = 0; i < paramsets.length && ret == null; ++i) {
            RParameterSetReference test = (RParameterSetReference)paramsets[i];
            if (test.getOriginalElement() != parameterset) continue;
            ret = test;
        }
        return ret;
    }

    public void throwSystemEvent(SystemEvent event) {
        if (this.getParameterProtectionMode().equals("protection_processing")) {
            super.throwSystemEvent(event);
        }
    }

    public Map getEncodableRepresentation() {
        Map rep = super.getEncodableRepresentation();
        HashMap encparams = SCollection.createHashMap();
        encparams.put("isencodeablepresentation", "true");
        IRParameter[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            encparams.put(params[i].getName(), ((RElement)((Object)params[i])).getEncodableRepresentation());
        }
        IRParameterSet[] paramsets = this.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            encparams.put(paramsets[i].getName(), ((RElement)((Object)paramsets[i])).getEncodableRepresentation());
        }
        rep.put("parameters", encparams);
        return rep;
    }
}

