/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigParameterElement;
import jadex.model.IMParameter;
import jadex.model.IMParameterElement;
import jadex.model.IMParameterSet;
import jadex.model.IMPlanParameter;
import jadex.model.IMPlanParameterSet;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RParameter;
import jadex.runtime.impl.RParameterSet;
import jadex.runtime.impl.RPlanParameter;
import jadex.runtime.impl.RPlanParameterSet;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.collection.SCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class RParameterElement
extends RReferenceableElement
implements IRParameterElement {
    public static final String ACCESS_PROTECTION_INIT = "protection_init";
    public static final String ACCESS_PROTECTION_PROCESSING = "protection_processing";
    protected Map parameters;
    protected Map parametersets;
    protected String protectionmode;

    protected RParameterElement(String name, IMParameterElement modelelement, IMConfigParameterElement state, RElement owner, RReferenceableElement creator, Map exparams) {
        super(name, modelelement, state, owner, creator, exparams);
        this.setParameterProtectionMode(ACCESS_PROTECTION_INIT);
        this.createParameters();
    }

    public void init() {
        Iterator it;
        super.init();
        if (this.parameters != null) {
            it = this.parameters.values().iterator();
            while (it.hasNext()) {
                ((RParameter)it.next()).initStructure();
            }
        }
        if (this.parametersets != null) {
            it = this.parametersets.values().iterator();
            while (it.hasNext()) {
                ((RParameterSet)it.next()).initStructure();
            }
        }
    }

    public void cleanup() {
        Iterator it;
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        this.setParameterProtectionMode(ACCESS_PROTECTION_INIT);
        if (this.parameters != null) {
            it = this.parameters.values().iterator();
            while (it.hasNext()) {
                ((IRParameter)it.next()).cleanup();
            }
        }
        if (this.parametersets != null) {
            it = this.parametersets.values().iterator();
            while (it.hasNext()) {
                ((IRParameterSet)it.next()).cleanup();
            }
        }
    }

    public String getParameterProtectionMode() {
        return this.protectionmode;
    }

    protected void setParameterProtectionMode(String protectionmode) {
        this.protectionmode = protectionmode;
    }

    public void throwSystemEvent(SystemEvent event) {
        if (this.protectionmode.equals(ACCESS_PROTECTION_PROCESSING)) {
            super.throwSystemEvent(event);
        }
    }

    public IRParameter[] getParameters() {
        if (this.parameters == null) {
            return new IRParameter[0];
        }
        return this.parameters.values().toArray(new IRParameter[this.parameters.size()]);
    }

    public IRParameterSet[] getParameterSets() {
        if (this.parametersets == null) {
            return new IRParameterSet[0];
        }
        return this.parametersets.values().toArray(new IRParameterSet[this.parametersets.size()]);
    }

    public IRParameter getParameter(String name) {
        IMParameter mparam;
        if (!(this.parameters != null && this.parameters.containsKey(name) || (mparam = ((IMParameterElement)this.getModelElement()).getParameter(name)) == null)) {
            IMConfigParameterElement state;
            if (this.parameters == null) {
                this.parameters = SCollection.createHashMap();
            }
            RParameter param = new RParameter(mparam, (state = (IMConfigParameterElement)this.getInitialState()) != null ? state.getParameter(mparam) : null, (RElement)this);
            this.parameters.put(mparam.getName(), param);
            return param;
        }
        if (this.parameters != null && this.parameters.containsKey(name)) {
            return (IRParameter)this.parameters.get(name);
        }
        throw new RuntimeException("No such parameter: " + name + " in " + this);
    }

    public IRParameterSet getParameterSet(String name) {
        IMParameterSet mparamset;
        if (!(this.parametersets != null && this.parametersets.containsKey(name) || (mparamset = ((IMParameterElement)this.getModelElement()).getParameterSet(name)) == null)) {
            IMConfigParameterElement state;
            if (this.parametersets == null) {
                this.parametersets = SCollection.createHashMap();
            }
            RParameterSet paramset = new RParameterSet(mparamset, (state = (IMConfigParameterElement)this.getInitialState()) != null ? state.getParameterSet(mparamset) : null, (RElement)this);
            this.parametersets.put(mparamset.getName(), paramset);
            return paramset;
        }
        if (this.parametersets != null && this.parametersets.containsKey(name)) {
            return (IRParameterSet)this.parametersets.get(name);
        }
        throw new RuntimeException("No such parameter set: " + name + " in " + this);
    }

    public boolean hasParameter(String name) {
        return ((IMParameterElement)this.getModelElement()).getParameter(name) != null;
    }

    public boolean hasParameterSet(String name) {
        return ((IMParameterElement)this.getModelElement()).getParameterSet(name) != null;
    }

    protected void createParameters() {
        IMParameterElement modelelement = (IMParameterElement)this.getModelElement();
        IMConfigParameterElement state = (IMConfigParameterElement)this.getInitialState();
        IMParameter[] params = modelelement.getParameters();
        if (params.length > 0 && this.parameters == null) {
            this.parameters = SCollection.createHashMap();
        }
        for (int i = 0; i < params.length; ++i) {
            if (this.parameters.containsKey(params[i].getName())) continue;
            RParameter param = params[i] instanceof IMPlanParameter && params[i] instanceof IMParameter ? new RPlanParameter(params[i], state != null ? state.getParameter(params[i]) : null, (RElement)this) : new RParameter(params[i], state != null ? state.getParameter(params[i]) : null, (RElement)this);
            this.parameters.put(params[i].getName(), param);
        }
        IMParameterSet[] paramsets = modelelement.getParameterSets();
        if (paramsets.length > 0 && this.parametersets == null) {
            this.parametersets = SCollection.createHashMap();
        }
        for (int i = 0; i < paramsets.length; ++i) {
            if (this.parametersets.containsKey(paramsets[i].getName())) continue;
            RParameterSet paramset = paramsets[i] instanceof IMPlanParameterSet ? new RPlanParameterSet(paramsets[i], state != null ? state.getParameterSet(paramsets[i]) : null, (RElement)this) : new RParameterSet(paramsets[i], state != null ? state.getParameterSet(paramsets[i]) : null, (RElement)this);
            this.parametersets.put(paramsets[i].getName(), paramset);
        }
    }

    public Object getParameterValue(String name) {
        return this.getParameter(name).getValue();
    }

    public Object[] getParameterSetValues(String name) {
        return this.getParameterSet(name).getValues();
    }

    public Map getEncodableRepresentation() {
        int i;
        Map rep = super.getEncodableRepresentation();
        HashMap encparams = SCollection.createHashMap();
        encparams.put("isencodeablepresentation", "true");
        if (this.parameters != null) {
            RElement[] params = this.parameters.values().toArray(new RElement[this.parameters.size()]);
            for (i = 0; i < params.length; ++i) {
                encparams.put(params[i].getName(), params[i].getEncodableRepresentation());
            }
        }
        if (this.parametersets != null) {
            RElement[] paramsets = this.parametersets.values().toArray(new RElement[this.parametersets.size()]);
            for (i = 0; i < paramsets.length; ++i) {
                encparams.put(paramsets[i].getName(), paramsets[i].getEncodableRepresentation());
            }
        }
        rep.put("parameters", encparams);
        return rep;
    }
}

