/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCapability;
import jadex.model.IMConfigParameter;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.model.IMParameter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RParameterElement;
import jadex.runtime.impl.RParameterElementReference;
import jadex.runtime.impl.RParameterReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.RTypedElement;

public class RParameter
extends RTypedElement
implements IRParameter {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RParameter(IMParameter parameter, IMConfigParameter state, RElement owner) {
        super(parameter.getName(), parameter, state, owner, null);
    }

    public void setInitialValue() {
        boolean found = false;
        if (((IMParameter)this.getModelElement()).getBindingOptions() != null && this.getInitialState() == null) {
            if (!$assertionsDisabled && this.getExpressionParameter(this.getModelElement().getName()) == null) {
                throw new AssertionError((Object)("Binding value not found: " + this.getModelElement().getName() + " " + this.getExpressionParameters()));
            }
            this.setInitialValue(this.getExpressionParameters().get(this.getModelElement().getName()));
            found = true;
        }
        if (!found) {
            RParameterReference ref;
            RReferenceableElement root;
            for (root = ((RParameterElement)this.getOwner()).getCreator(); root != null && root.getCreator() != null; root = root.getCreator()) {
            }
            if (root != null && (ref = ((RParameterElementReference)root).getParameterReference(this)).getInitialState() != null) {
                Object value = ref.getInitialValue();
                if (value instanceof IRExpression) {
                    IMExpressionReference mref = ((IMCapability)this.getScope().getModelElement()).getExpressionbase().getExpressionReference("standard_expression_reference");
                    value = this.getScope().getExpressionbase().createExpression(mref, (RReferenceableElement)value);
                }
                this.setInitialValue(value);
                found = true;
            }
        }
        if (!found) {
            IMExpression mvalue = null;
            mvalue = this.getInitialState() != null ? ((IMConfigParameter)this.getInitialState()).getInitialValue() : ((IMParameter)this.getModelElement()).getDefaultValue();
            if (mvalue != null) {
                if (mvalue.getEvaluationMode().equals("static")) {
                    this.setInitialValue(this.getScope().getExpressionbase().evaluateInternalExpression(mvalue, this));
                } else {
                    this.setInitialValue(this.getScope().getExpressionbase().createInternalExpression(mvalue, this, new SystemEvent("BDI_valueChanged", this)));
                }
            }
        }
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setValue(Object value) {
        if (((IMParameter)this.getModelElement()).getDirection().equals("fixed")) {
            throw new RuntimeException("Fixed elements cannot be altered: " + this);
        }
        super.setValue(value);
    }

    private String getProtectionMode() {
        String ret = null;
        RParameterElement owner = (RParameterElement)this.getOwner();
        if (owner != null) {
            ret = owner.getParameterProtectionMode();
        }
        return ret;
    }

    public void checkReadAccess() {
        String dir = ((IMParameter)this.getModelElement()).getDirection();
        if ("protection_init".equals(this.getProtectionMode()) && dir.equals("in")) {
            throw new RuntimeException("Read access not allowed to parameter: " + ((IMParameter)this.getModelElement()).getDirection() + " " + this.getName() + " " + this.getOwner());
        }
    }

    public void checkWriteAccess() {
        String dir = ((IMParameter)this.getModelElement()).getDirection();
        if ("protection_init".equals(this.getProtectionMode()) && dir.equals("out")) {
            throw new RuntimeException("Write access not allowed to parameter: " + ((IMParameter)this.getModelElement()).getDirection() + " " + this.getName());
        }
        if ("protection_processing".equals(this.getProtectionMode()) && dir.equals("in")) {
            throw new RuntimeException("Write access not allowed to parameter: " + ((IMParameter)this.getModelElement()).getDirection() + " " + this.getName());
        }
    }

    public void throwSystemEvent(SystemEvent event) {
        if ("protection_processing".equals(this.getProtectionMode())) {
            super.throwSystemEvent(event);
        }
    }

    static {
        $assertionsDisabled = !RParameter.class.desiredAssertionStatus();
    }
}

