/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigMessageEvent;
import jadex.model.IMConfigParameterElement;
import jadex.model.IMEventbase;
import jadex.model.IMMessageEvent;
import jadex.model.IMMessageEventReference;
import jadex.model.IMParameter;
import jadex.model.IMParameterSet;
import jadex.model.MessageType;
import jadex.runtime.ContentException;
import jadex.runtime.IFilter;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRReferenceableElement;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.REvent;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.util.Map;

public class RMessageEvent
extends REvent
implements IRMessageEvent {
    private static int message_no;
    protected Object message;
    protected IRMessageEvent originalmsg;
    protected long timeout;
    private String id;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RMessageEvent(String name, IMMessageEvent event, IMConfigMessageEvent state, RElement owner, RReferenceableElement creator, boolean incoming, Map exparams) {
        super(name, event, (IMConfigParameterElement)state, owner, creator, exparams);
        if (event.getDirection().equals("receive") && !incoming) {
            throw new RuntimeException("Cannot create outgoing message. Is declared to be only received: " + event);
        }
        if (event.getDirection().equals("send") && incoming) {
            throw new RuntimeException("Cannot create incoming message. Is declared to be only received: " + event);
        }
        this.timeout = -1L;
        if (!incoming) {
            this.id = "#" + message_no++ + "@" + this.getScope().getAgentName();
        }
    }

    public Object getMessage() {
        return this.message;
    }

    public void setMessage(Object message) {
        if (!$assertionsDisabled && this.message != null) {
            throw new AssertionError(this);
        }
        this.message = message;
    }

    public boolean isReply() {
        return this.originalmsg != null;
    }

    public IRMessageEvent getInReplyMessageEvent() {
        return this.originalmsg;
    }

    public void setInReplyMessageEvent(IRMessageEvent event) {
        this.originalmsg = event;
    }

    public Object getContent() {
        if (!this.hasParameter("content")) {
            throw new RuntimeException("No content parameter defined in message: " + this.getType());
        }
        IRParameter param = this.getParameter("content");
        Object content = param.getValue();
        if (content instanceof ContentException) {
            throw (ContentException)content;
        }
        return content;
    }

    public void setContent(Object content) {
        if (!this.hasParameter("content")) {
            this.hasParameter("content");
            throw new RuntimeException("No content parameter defined in message: " + this.getType());
        }
        IRParameter param = this.getParameter("content");
        param.setValue(content);
    }

    public IRMessageEvent createReply(String msgeventtype) {
        Object sourceval;
        IRReferenceableElement dest;
        IRParameter source;
        int i;
        IMEventbase ebase = (IMEventbase)this.getScope().getEventbase().getModelElement();
        IMMessageEvent mevent = ebase.getMessageEvent(msgeventtype);
        IMMessageEventReference meventref = null;
        MessageType eventtype = null;
        if (mevent == null) {
            meventref = ebase.getMessageEventReference(msgeventtype);
            if (meventref != null) {
                mevent = (IMMessageEvent)meventref.getOriginalElement();
            } else {
                throw new RuntimeException("Message event type not found in model: " + msgeventtype);
            }
        }
        eventtype = mevent.getMessageType();
        MessageType thistype = ((IMMessageEvent)this.getModelElement()).getMessageType();
        if (!SUtil.equals(thistype, eventtype)) {
            throw new RuntimeException("Cannot create reply of incompatible message type: " + this + ", " + (meventref != null ? meventref.toString() : mevent.toString()));
        }
        IRMessageEvent event = this.getScope().getEventbase().createMessageEvent(meventref != null ? meventref : mevent, null, null, false, null);
        event.setInReplyMessageEvent(this);
        MessageType.ParameterSpecification[] params = eventtype.getParameters();
        MessageType.ParameterSpecification[] paramsets = eventtype.getParameterSets();
        for (i = 0; i < params.length; ++i) {
            if (params[i].getSource() == null || mevent.getParameter(params[i].getName()).getDirection().equals("fixed")) continue;
            source = this.getParameter(params[i].getSource());
            dest = event.getParameter(params[i].getName());
            sourceval = source.getValue();
            if ("in".equals(((IMParameter)dest.getOriginalElement().getModelElement()).getDirection()) || "inout".equals(((IMParameter)dest.getOriginalElement().getModelElement()).getDirection())) {
                dest.setValue(sourceval);
                continue;
            }
            Object destvalue = dest.getValue();
            if (SUtil.equals(sourceval, destvalue)) continue;
            this.getScope().getLogger().warning("Cannot overwrite reply value " + params[i].getName() + " on " + this);
        }
        for (i = 0; i < paramsets.length; ++i) {
            if (paramsets[i].getSource() == null || mevent.getParameterSet(paramsets[i].getName()).getDirection().equals("fixed")) continue;
            source = this.getParameter(paramsets[i].getSource());
            dest = event.getParameterSet(paramsets[i].getName());
            sourceval = source.getValue();
            if ("in".equals(((IMParameterSet)dest.getOriginalElement().getModelElement()).getDirection()) || "inout".equals(((IMParameterSet)dest.getOriginalElement().getModelElement()).getDirection())) {
                dest.removeValues();
                dest.addValue(sourceval);
                continue;
            }
            Object[] destvalues = dest.getValues();
            if (sourceval == null && destvalues.length <= 0 || sourceval != null && destvalues.length <= 1 && sourceval.equals(destvalues[0])) continue;
            this.getScope().getLogger().warning("Cannot overwrite reply value " + params[i].getName() + " on " + this);
        }
        return event;
    }

    public IRMessageEvent createReply(String msgeventtype, Object content) {
        IRMessageEvent event = this.createReply(msgeventtype);
        event.setContent(content);
        return event;
    }

    public IFilter getFilter() {
        return new MessageEventFilter(null, this.getName());
    }

    public String toString() {
        if (((IMMessageEvent)this.getModelElement()).getType().equals("fipa")) {
            try {
                return this.getParameter("performative").getValue() + "(" + this.getContent() + ")";
            }
            catch (ContentException e) {
                return this.getParameter("performative").getValue() + "(invalid content)";
            }
        }
        return SReflect.getInnerClassName(this.getClass()) + "(type=" + this.getType() + ", message=" + (this.message != null ? "" + this.message : "null") + ", source=" + (this.getScope() == null ? "null" : this.getScope().getName()) + ")";
    }

    public Map getEncodableRepresentation() {
        Map rep = super.getEncodableRepresentation();
        StringBuffer msgtxt = new StringBuffer();
        msgtxt.append(SUtil.arrayToString(this.getParameters()));
        msgtxt.append(" ");
        msgtxt.append(SUtil.arrayToString(this.getParameterSets()));
        rep.put("message", msgtxt);
        return rep;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    static {
        $assertionsDisabled = !RMessageEvent.class.desiredAssertionStatus();
        message_no = 0;
    }
}

