/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCondition;
import jadex.model.IMConfigGoal;
import jadex.model.IMMaintainGoal;
import jadex.runtime.impl.RCondition;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.AbstractAgendaAction;
import jadex.runtime.impl.agenda.ComposedPrecondition;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.easydeliberation.DeactivateInhibitedGoalsAction;
import jadex.runtime.impl.agenda.easydeliberation.DeliberateInhibitedGoalsReactivationAction;
import jadex.runtime.impl.agenda.goals.GoalLifecycleStatePrecondition;
import jadex.runtime.impl.agenda.goals.GoalNotFinishedPrecondition;
import jadex.runtime.impl.agenda.goals.GoalProcessingStatePrecondition;
import jadex.runtime.impl.agenda.goals.maintain.MaintainAction;
import jadex.runtime.impl.agenda.goals.maintain.MaintainGoalFinishedAction;
import jadex.runtime.impl.agenda.goals.maintain.MaintainGoalRetryAction;
import jadex.runtime.impl.agenda.goals.maintain.TargetAction;
import jadex.util.SReflect;
import jadex.util.collection.MultiCollection;
import java.util.List;
import java.util.Map;

public class RMaintainGoal
extends RGoal {
    public static final String MAINTAIN_STATE_UNMAINTAINABLE = "unmaintainable";
    public static final String MAINTAIN_STATE_UNKNOWN = "unknown";
    public static final String MAINTAIN_STATE_IN_PROCESS = "in_process";
    public static final String MAINTAIN_STATE_IDLE = "idle";
    public static final String MAINTAIN_STATE_PROCESSING_PAUSED = "processing_paused";
    protected static final MultiCollection proc_transitions;
    protected RCondition maintain;
    protected RCondition target;
    protected AbstractAgendaAction targetaction = new TargetAction(this, (IAgendaActionPrecondition)new GoalLifecycleStatePrecondition(this, "active"));
    protected String processingstate;
    public IAgendaAction retryaction = new MaintainGoalRetryAction(this, (IAgendaActionPrecondition)new GoalProcessingStatePrecondition(this, "processing_paused"));
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RMaintainGoal(String name, IMMaintainGoal goal, IMConfigGoal state, RElement owner, RReferenceableElement creator, Map binding) {
        super(name, goal, state, owner, creator, binding);
        this.setProcessingState(MAINTAIN_STATE_IDLE);
        this.setMaintainCondition(goal.getMaintainCondition());
        this.setTargetCondition(goal.getTargetCondition());
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.target != null) {
            this.target.cleanup();
        }
        if (this.maintain != null) {
            this.maintain.cleanup();
        }
    }

    public RCondition getMaintainCondition() {
        return this.maintain;
    }

    public void setMaintainCondition(IMCondition mmaintain) {
        if (this.maintain != null) {
            this.maintain.cleanup();
        }
        this.maintain = this.getScope().getExpressionbase().createInternalCondition(mmaintain, this, new MaintainAction(this, (IAgendaActionPrecondition)new GoalLifecycleStatePrecondition(this, "active")), null);
        if (this.isActive()) {
            this.maintain.traceOnce();
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    public RCondition getTargetCondition() {
        return this.target;
    }

    public void setTargetCondition(IMCondition mtarget) {
        if (this.target != null) {
            this.target.cleanup();
        }
        if (mtarget != null) {
            this.target = this.getScope().getExpressionbase().createInternalCondition(mtarget, this, this.targetaction, null);
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    public boolean isSucceeded() {
        return MAINTAIN_STATE_IDLE.equals(this.processingstate);
    }

    public void processGoalsCreated(List hists) {
        super.processGoalsCreated(hists);
        if (hists.size() == 0) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new MaintainGoalFinishedAction(this, (IAgendaActionPrecondition)new GoalProcessingStatePrecondition(this, this.getProcessingState())), this);
        } else {
            this.changeProcessingState(MAINTAIN_STATE_IN_PROCESS);
        }
    }

    protected void processGoalFinished(RProcessGoal procgoal) {
        super.processGoalFinished(procgoal);
        if (this.ignoreProcessGoals()) {
            return;
        }
        if (!$assertionsDisabled && !this.isActive()) {
            throw new AssertionError(this);
        }
        if (!this.isPostToAll() && this.isRetry()) {
            if (this.getRetryDelay() > 0L) {
                this.changeProcessingState(MAINTAIN_STATE_PROCESSING_PAUSED);
                this.setRetryEntry(new TimetableData(this.getRetryDelay(), this.retryaction));
                this.getScope().getAgent().addTimetableEntry(this.getRetryEntry());
            } else {
                this.throwProcessEvent();
            }
        } else if (this.isProcessingFinished()) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new MaintainGoalFinishedAction(this, (IAgendaActionPrecondition)new GoalProcessingStatePrecondition(this, MAINTAIN_STATE_IN_PROCESS)), this);
        }
    }

    public void clearExcludedCandidates() {
        if (this.apl != null) {
            this.apl.clearExcludeSet();
        }
    }

    public String getProcessingState() {
        if (!$assertionsDisabled && this.processingstate == null) {
            throw new AssertionError();
        }
        return this.processingstate;
    }

    protected void setProcessingState(String processingstate) {
        this.processingstate = processingstate;
        this.throwSystemEvent("BDI_goalChanged");
    }

    public void changeProcessingState(String newstate) {
        if (!$assertionsDisabled && !proc_transitions.getCollection(this.getProcessingState()).contains(newstate)) {
            throw new AssertionError((Object)("Cannot change processing state from " + this.getProcessingState() + " to " + newstate + ": " + this.getName()));
        }
        if (newstate.equals(this.getProcessingState())) {
            return;
        }
        String oldstate = this.getProcessingState();
        this.setProcessingState(newstate);
        if (oldstate.equals(MAINTAIN_STATE_IN_PROCESS)) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateInhibitedGoalsReactivationAction(new GoalProcessingStatePrecondition(this, MAINTAIN_STATE_IN_PROCESS, true), this), this);
        } else if (newstate.equals(MAINTAIN_STATE_IN_PROCESS)) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeactivateInhibitedGoalsAction(new GoalProcessingStatePrecondition(this, MAINTAIN_STATE_IN_PROCESS), this), this);
        }
    }

    protected void enterActiveState() {
        this.maintain.traceOnce();
        super.enterActiveState();
    }

    protected void exitActiveState() {
        if (MAINTAIN_STATE_IN_PROCESS.equals(this.processingstate) || MAINTAIN_STATE_PROCESSING_PAUSED.equals(this.processingstate)) {
            this.setProcessingState(MAINTAIN_STATE_IDLE);
        }
        this.maintain.setTraceMode("never");
        this.maintain.reset();
        this.target.setTraceMode("never");
        super.exitActiveState();
    }

    public boolean ignoreProcessGoals() {
        return MAINTAIN_STATE_IDLE.equals(this.processingstate) || MAINTAIN_STATE_UNKNOWN.equals(this.processingstate) || MAINTAIN_STATE_UNMAINTAINABLE.equals(this.processingstate);
    }

    public boolean isInProcess() {
        return this.isActive() && MAINTAIN_STATE_IN_PROCESS.equals(this.processingstate);
    }

    public boolean isFinished() {
        return this.dropping || "dropped".equals(this.getLifecycleState());
    }

    public Map getEncodableRepresentation() {
        Map representation = super.getEncodableRepresentation();
        representation.put("processingstate", this.processingstate);
        representation.put("maintaincondition", this.maintain == null ? "" : ((IMCondition)this.maintain.getModelElement()).getExpressionText());
        representation.put("targetcondition", this.target == null ? "" : ((IMCondition)this.target.getModelElement()).getExpressionText());
        return representation;
    }

    protected String toString(int level) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(name=");
        buf.append(this.getName());
        buf.append(", type=");
        buf.append(this.getType());
        buf.append(", processingstate=");
        buf.append(this.processingstate);
        buf.append(", active=");
        buf.append(this.isActive());
        buf.append(")");
        return buf.toString();
    }

    protected IAgendaActionPrecondition createProcessEventPrecondition() {
        ComposedPrecondition cp = new ComposedPrecondition(new GoalNotFinishedPrecondition(this), new GoalLifecycleStatePrecondition(this, "active"));
        cp.addPrecondition(new IAgendaActionPrecondition(){

            public boolean check() {
                return RMaintainGoal.this.maintain.getLastValue() == null || RMaintainGoal.this.maintain.getLastValue() == false;
            }
        });
        return cp;
    }

    public void doRecur() {
        if (!($assertionsDisabled || MAINTAIN_STATE_UNKNOWN.equals(this.getProcessingState()) || MAINTAIN_STATE_UNMAINTAINABLE.equals(this.getProcessingState()))) {
            throw new AssertionError((Object)this.getProcessingState());
        }
        super.doRecur();
        this.getMaintainCondition().setTraceMode("never");
        this.getTargetCondition().setTraceMode("once");
    }

    static {
        $assertionsDisabled = !RMaintainGoal.class.desiredAssertionStatus();
        proc_transitions = new MultiCollection();
        proc_transitions.put(MAINTAIN_STATE_IDLE, MAINTAIN_STATE_IN_PROCESS);
        proc_transitions.put(MAINTAIN_STATE_IDLE, MAINTAIN_STATE_UNMAINTAINABLE);
        proc_transitions.put(MAINTAIN_STATE_IN_PROCESS, MAINTAIN_STATE_IN_PROCESS);
        proc_transitions.put(MAINTAIN_STATE_IN_PROCESS, MAINTAIN_STATE_IDLE);
        proc_transitions.put(MAINTAIN_STATE_IN_PROCESS, MAINTAIN_STATE_UNMAINTAINABLE);
        proc_transitions.put(MAINTAIN_STATE_IN_PROCESS, MAINTAIN_STATE_UNKNOWN);
        proc_transitions.put(MAINTAIN_STATE_IN_PROCESS, MAINTAIN_STATE_PROCESSING_PAUSED);
        proc_transitions.put(MAINTAIN_STATE_UNMAINTAINABLE, MAINTAIN_STATE_IDLE);
        proc_transitions.put(MAINTAIN_STATE_UNMAINTAINABLE, MAINTAIN_STATE_IN_PROCESS);
        proc_transitions.put(MAINTAIN_STATE_UNMAINTAINABLE, MAINTAIN_STATE_UNMAINTAINABLE);
        proc_transitions.put(MAINTAIN_STATE_UNKNOWN, MAINTAIN_STATE_IDLE);
        proc_transitions.put(MAINTAIN_STATE_UNKNOWN, MAINTAIN_STATE_IN_PROCESS);
        proc_transitions.put(MAINTAIN_STATE_PROCESSING_PAUSED, MAINTAIN_STATE_IDLE);
        proc_transitions.put(MAINTAIN_STATE_PROCESSING_PAUSED, MAINTAIN_STATE_IN_PROCESS);
        proc_transitions.put(MAINTAIN_STATE_PROCESSING_PAUSED, MAINTAIN_STATE_UNMAINTAINABLE);
    }
}

