/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMAchieveGoal;
import jadex.model.IMAchieveGoalReference;
import jadex.model.IMBase;
import jadex.model.IMConfigGoal;
import jadex.model.IMConfigGoalbase;
import jadex.model.IMConfigParameter;
import jadex.model.IMConfiguration;
import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.model.IMGoalbase;
import jadex.model.IMMaintainGoal;
import jadex.model.IMMaintainGoalReference;
import jadex.model.IMMetaGoal;
import jadex.model.IMMetaGoalReference;
import jadex.model.IMPerformGoal;
import jadex.model.IMPerformGoalReference;
import jadex.model.IMQueryGoal;
import jadex.model.IMQueryGoalReference;
import jadex.model.IMReferenceableElement;
import jadex.model.ISystemEventTypes;
import jadex.runtime.GoalEventFilter;
import jadex.runtime.GoalFailureException;
import jadex.runtime.ICandidateInfo;
import jadex.runtime.IFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.BindingHelper;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RAchieveGoal;
import jadex.runtime.impl.RAchieveGoalReference;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RBindingCondition;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RGoalReference;
import jadex.runtime.impl.RMaintainGoal;
import jadex.runtime.impl.RMaintainGoalReference;
import jadex.runtime.impl.RMetaGoal;
import jadex.runtime.impl.RMetaGoalReference;
import jadex.runtime.impl.RPerformGoal;
import jadex.runtime.impl.RPerformGoalReference;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RQueryGoal;
import jadex.runtime.impl.RQueryGoalReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.impl.agenda.conditions.ConditionDefaultPrecondition;
import jadex.runtime.impl.agenda.goals.GoalCreationAction;
import jadex.util.SReflect;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RGoalbase
extends RBase {
    protected IndexMap adoptedgoals = SCollection.createIndexMap();
    protected IndexMap processgoals = SCollection.createIndexMap();
    protected Map bindings = SCollection.createHashMap();
    protected Map conditions = SCollection.createHashMap();
    protected Map metagoalmap;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RGoalbase(IMGoalbase model, RElement owner) {
        super(null, model, owner);
    }

    protected void init(int level) {
        IMConfigGoalbase initialbase;
        IMConfiguration is;
        if (level == 0) {
            this.metagoalmap = SCollection.createHashMap();
            IMMetaGoal[] metagoals = ((IMGoalbase)this.getModelElement()).getMetaGoals();
            for (int i = 0; i < metagoals.length; ++i) {
                this.metagoalmap.put(new WaitAbstraction(this.getScope()).createFilter(metagoals[i].getTrigger()), metagoals[i]);
            }
            IMGoal[] mgoals = ((IMGoalbase)this.getModelElement()).getGoals();
            for (int i = 0; i < mgoals.length; ++i) {
                this.registerGoal(mgoals[i]);
            }
        }
        if (level == 1 && (is = this.getScope().getConfiguration()) != null && (initialbase = is.getGoalbase()) != null) {
            IMConfigGoal[] inigoals = initialbase.getInitialGoals();
            this.instantiateConfigGoals(inigoals);
        }
    }

    public void cleanup() {
        int i;
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        Iterator i2 = this.bindings.values().iterator();
        while (i2.hasNext()) {
            ((BindingHelper)i2.next()).cleanup();
        }
        i2 = this.conditions.values().iterator();
        while (i2.hasNext()) {
            ((IRCondition)i2.next()).cleanup();
        }
        for (i = 0; i < this.adoptedgoals.size(); ++i) {
            ((IRGoal)this.adoptedgoals.get(i)).drop();
        }
        for (i = 0; i < this.processgoals.size(); ++i) {
            ((RProcessGoal)this.processgoals.get(i)).drop("aborted_on_failure");
        }
    }

    public IRGoal getGoal(String name) {
        return (IRGoal)this.adoptedgoals.get(name);
    }

    public boolean containsGoal(IRGoal goal) {
        return this.adoptedgoals.contains(goal);
    }

    public boolean containsProcessGoal(RProcessGoal goal) {
        return this.processgoals.contains(goal);
    }

    public IRGoal createGoal(String type) {
        IMReferenceableElement ref = ((IMBase)this.getModelElement()).getReferenceableElement(type);
        if (ref == null) {
            throw new RuntimeException("Unknown goal: " + type);
        }
        return this.createGoal(null, ref, null, null, null);
    }

    public IRGoal[] getGoals(String type) {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.adoptedgoals.size(); ++i) {
            IRGoal tmp = (IRGoal)this.adoptedgoals.get(i);
            if (!tmp.getType().equals(type)) continue;
            ret.add(tmp);
        }
        return ret.toArray(new IRGoal[ret.size()]);
    }

    public IRGoal[] getActiveGoals(String type) {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.adoptedgoals.size(); ++i) {
            IRGoal tmp = (IRGoal)this.adoptedgoals.get(i);
            if (!tmp.getType().equals(type) || !tmp.isActive()) continue;
            ret.add(tmp);
        }
        return ret.toArray(new IRGoal[ret.size()]);
    }

    public IRGoal[] getOptions(String type) {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.adoptedgoals.size(); ++i) {
            IRGoal tmp = (IRGoal)this.adoptedgoals.get(i);
            if (!tmp.getType().equals(type) || !tmp.isOption()) continue;
            ret.add(tmp);
        }
        return ret.toArray(new IRGoal[ret.size()]);
    }

    public IRGoal[] getActiveGoals() {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.adoptedgoals.size(); ++i) {
            IRGoal tmp = (IRGoal)this.adoptedgoals.get(i);
            if (!tmp.isActive()) continue;
            ret.add(tmp);
        }
        return ret.toArray(new IRGoal[ret.size()]);
    }

    public IRGoal[] getOptions() {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.adoptedgoals.size(); ++i) {
            IRGoal tmp = (IRGoal)this.adoptedgoals.get(i);
            if (!tmp.isOption()) continue;
            ret.add(tmp);
        }
        return ret.toArray(new IRGoal[ret.size()]);
    }

    public IRGoal[] getGoals() {
        return (IRGoal[])this.adoptedgoals.getObjects(IRGoal.class);
    }

    public void registerGoal(IMGoal mgoal) {
        BindingHelper binding = null;
        if (mgoal.getBindingParameters().length > 0) {
            binding = new BindingHelper(mgoal, this, mgoal.getCreationCondition() != null);
            this.bindings.put(mgoal, binding);
        }
        if (mgoal.getCreationCondition() != null) {
            RBindingCondition creation = (RBindingCondition)this.getScope().getExpressionbase().createInternalCondition(mgoal.getCreationCondition(), this, null, binding);
            this.conditions.put(mgoal, creation);
            creation.setAction(new GoalCreationAction(this, new ConditionDefaultPrecondition(creation), mgoal));
            creation.setTraceMode("always");
        }
    }

    public void deregisterGoal(IMGoal mgoal) {
        this.leaveRunningState(mgoal);
    }

    public void registerGoalReference(IMGoalReference mgoalref) {
    }

    public void deregisterGoalReference(IMGoalReference mgoalref) {
        this.leaveRunningState(mgoalref);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.name);
        sb.append("\ngoals=\n");
        IRGoal[] mgoals = this.getGoals();
        for (int i = 0; i < mgoals.length; ++i) {
            sb.append("  ");
            sb.append(mgoals[i].getName());
            sb.append("\n");
        }
        sb.append("\nprocessgoals=\n");
        RProcessGoal[] pgoals = this.getProcessGoals();
        for (int i = 0; i < pgoals.length; ++i) {
            sb.append("  ");
            sb.append(pgoals[i].getName());
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    public List getState(String[] types) {
        ArrayList ret = SCollection.createArrayList();
        if (ISystemEventTypes.Subtypes.isSubtype("BDI_goalAdded", types)) {
            for (int i = 0; i < this.adoptedgoals.size(); ++i) {
                RReferenceableElement goal = (RReferenceableElement)this.adoptedgoals.get(i);
                ret.add(new SystemEvent("BDI_goalAdded", goal));
            }
        }
        return ret;
    }

    public IFilter dispatchTopLevelGoal(IRGoal goal) {
        if (goal == null) {
            throw new RuntimeException("Dispatched goal must not null: " + goal);
        }
        GoalEventFilter gf = new GoalEventFilter(goal.getType(), goal.getName(), true);
        if (!this.adoptGoal(goal)) {
            this.getScope().getLogger().warning("Cannot adopt goal (already exists): " + goal);
        }
        return gf;
    }

    public IFilter dispatchSubgoal(RProcessGoal parent, IRGoal subgoal) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && subgoal == null) {
            throw new AssertionError();
        }
        GoalEventFilter gf = new GoalEventFilter(subgoal.getType(), subgoal.getName(), true);
        parent.addSubgoal(subgoal);
        if (!this.adoptGoal(subgoal)) {
            parent.removeSubgoal(subgoal);
            throw new GoalFailureException(null, "Cannot adopt goal (already exists).");
        }
        return gf;
    }

    public RProcessGoal[] getProcessGoals() {
        return (RProcessGoal[])this.processgoals.getObjects(RProcessGoal.class);
    }

    protected RProcessGoal[] getProcessGoals(String type) {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < this.processgoals.size(); ++i) {
            RProcessGoal tmp = (RProcessGoal)this.processgoals.get(i);
            if (!tmp.getType().equals(type)) continue;
            ret.add(tmp);
        }
        return ret.toArray(new RProcessGoal[ret.size()]);
    }

    public boolean adoptGoal(IRGoal igoal) {
        int i;
        if (!$assertionsDisabled && igoal == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ((RGoal)igoal.getOriginalElement()).isAdopted()) {
            throw new AssertionError();
        }
        boolean adopt = true;
        RGoal goal = (RGoal)igoal.getOriginalElement();
        IMGoal mgoal = (IMGoal)goal.getModelElement();
        if (mgoal.getUnique() != null) {
            IRGoal[] siblings = this.getGoals(goal.getType());
            for (i = 0; adopt && i < siblings.length; ++i) {
                adopt = !goal.isSame(siblings[i]);
            }
        }
        if (adopt) {
            List occs = goal.getAllOccurrences();
            for (i = 0; i < occs.size(); ++i) {
                IRGoal tmp = (IRGoal)occs.get(i);
                ((RGoalbase)tmp.getOwner()).internalAdoptGoal(tmp);
            }
            goal.adopt();
        } else {
            goal.cleanup();
        }
        return adopt;
    }

    protected void internalAdoptGoal(IRGoal goal) {
        if (!$assertionsDisabled && goal == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.adoptedgoals.containsKey(goal.getName())) {
            throw new AssertionError((Object)("Goal with same name is already adopted: " + goal.getName()));
        }
        this.adoptedgoals.add(goal.getName(), (Object)goal);
    }

    protected void removeGoal(IRGoal goal) {
        if (!$assertionsDisabled && goal == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.adoptedgoals.containsKey(goal.getName())) {
            throw new AssertionError();
        }
        this.adoptedgoals.removeKey(goal.getName());
    }

    protected void removeGoal(RProcessGoal goal) {
        if (!$assertionsDisabled && goal == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.processgoals.containsKey(goal.getName())) {
            throw new AssertionError();
        }
        this.processgoals.removeKey(goal.getName());
    }

    protected RReferenceableElement getElementInstance(IMReferenceableElement melement, RReferenceableElement creator) {
        RCapability scope = this.getScope().getAgent().lookupCapability(melement.getScope());
        if (!$assertionsDisabled && scope == null) {
            throw new AssertionError((Object)(this + ", " + this.getScope() + ", " + melement.getScope()));
        }
        return (RReferenceableElement)((Object)scope.getGoalbase().internalCreateGoal(null, melement, null, creator, null));
    }

    protected RBase getCorrespondingBase(RCapability scope) {
        return scope.getGoalbase();
    }

    public IRGoal createGoal(String name, IMReferenceableElement goal, IMConfigGoal state, RReferenceableElement creator, Map binding) {
        IRGoal ret = this.internalCreateGoal(name, goal, state, creator, binding);
        ret.getOriginalElement().initStructure();
        return ret;
    }

    protected IRGoal internalCreateGoal(String name, IMReferenceableElement goal, IMConfigGoal state, RReferenceableElement creator, Map binding) {
        if (!$assertionsDisabled && goal == null) {
            throw new AssertionError((Object)(goal + " " + creator));
        }
        if (!($assertionsDisabled || goal instanceof IMGoal || goal instanceof IMGoalReference)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && goal.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRGoal)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        if (goal instanceof IMGoal) {
            if (binding == null && this.bindings.containsKey(goal)) {
                BindingHelper bh = (BindingHelper)this.bindings.get(goal);
                IMConfigParameter[] inips = state.getParameters();
                String[] names = new String[inips.length];
                Object[] vals = new Object[inips.length];
                for (int i = 0; i < inips.length; ++i) {
                    Object value = this.getScope().getExpressionbase().evaluateInternalExpression(inips[i].getInitialValue(), this);
                    names[i] = inips[i].getOriginalElement().getName();
                    vals[i] = new Object[]{this.getScope().getExpressionbase().evaluateInternalExpression(inips[i].getInitialValue(), this)};
                }
                List bindings = bh.calculateBindings(null, names, vals);
                if (bindings.size() == 0) {
                    throw new RuntimeException("No binding available!");
                }
                binding = (Map)bindings.get(0);
            }
            if (goal instanceof IMMetaGoal) {
                ret = new RMetaGoal(name, (IMMetaGoal)goal, state, (RElement)this, creator, binding);
            } else if (goal instanceof IMPerformGoal) {
                ret = new RPerformGoal(name, (IMPerformGoal)goal, state, (RElement)this, creator, binding);
            } else if (goal instanceof IMAchieveGoal) {
                ret = new RAchieveGoal(name, (IMAchieveGoal)goal, state, (RElement)this, creator, binding);
            } else if (goal instanceof IMMaintainGoal) {
                ret = new RMaintainGoal(name, (IMMaintainGoal)goal, state, (RElement)this, creator, binding);
            } else if (goal instanceof IMQueryGoal) {
                ret = new RQueryGoal(name, (IMQueryGoal)goal, state, (RElement)this, creator, binding);
            }
        } else {
            RGoalReference rgr = null;
            if (goal instanceof IMMetaGoalReference) {
                rgr = new RMetaGoalReference(name, (IMMetaGoalReference)goal, state, (RElement)this, creator);
            } else if (goal instanceof IMPerformGoalReference) {
                rgr = new RPerformGoalReference(name, (IMPerformGoalReference)goal, state, (RElement)this, creator);
            } else if (goal instanceof IMAchieveGoalReference) {
                rgr = new RAchieveGoalReference(name, (IMAchieveGoalReference)goal, state, (RElement)this, creator);
            } else if (goal instanceof IMMaintainGoalReference) {
                rgr = new RMaintainGoalReference(name, (IMMaintainGoalReference)goal, state, (RElement)this, creator);
            } else if (goal instanceof IMQueryGoalReference) {
                rgr = new RQueryGoalReference(name, (IMQueryGoalReference)goal, state, (RElement)this, creator);
            }
            if (!$assertionsDisabled && rgr == null) {
                throw new AssertionError(goal);
            }
            ret = rgr;
        }
        if (!$assertionsDisabled && ret == null) {
            throw new AssertionError(goal);
        }
        return ret;
    }

    protected RProcessGoal createProcessGoal(IRGoal goal, ICandidateInfo cand) {
        if (goal != null && !this.adoptedgoals.containsKey(goal.getName())) {
            System.out.println("holla");
        }
        if (!$assertionsDisabled && goal != null && !this.adoptedgoals.containsKey(goal.getName())) {
            throw new AssertionError(goal);
        }
        if (!$assertionsDisabled && cand == null) {
            throw new AssertionError();
        }
        RProcessGoal ret = new RProcessGoal(goal, this, cand);
        return ret;
    }

    public void addProcessGoal(RProcessGoal goal) {
        this.processgoals.add(goal.getName(), (Object)goal);
    }

    public void exitRunningState() {
        IMGoal[] goals = ((IMGoalbase)this.getModelElement()).getGoals();
        for (int i = 0; i < goals.length; ++i) {
            this.leaveRunningState(goals[i]);
        }
        IMGoalReference[] goalrefs = ((IMGoalbase)this.getModelElement()).getGoalReferences();
        for (int i = 0; i < goalrefs.length; ++i) {
            this.leaveRunningState(goalrefs[i]);
        }
    }

    public void activateEndState() {
        IMConfigGoalbase goalbase;
        IMConfiguration config = this.getScope().getConfiguration();
        if (config != null && (goalbase = config.getGoalbase()) != null) {
            this.instantiateConfigGoals(goalbase.getEndGoals());
        }
    }

    protected void instantiateConfigGoals(IMConfigGoal[] configgoals) {
        for (int i = 0; i < configgoals.length; ++i) {
            BindingHelper bh = (BindingHelper)this.bindings.get(configgoals[i].getOriginalElement());
            if (bh != null) {
                IMConfigParameter[] inips = configgoals[i].getParameters();
                String[] names = new String[inips.length];
                Object[] vals = new Object[inips.length];
                for (int j = 0; j < inips.length; ++j) {
                    Object value = this.getScope().getExpressionbase().evaluateInternalExpression(inips[j].getInitialValue(), this);
                    names[j] = inips[j].getOriginalElement().getName();
                    vals[j] = new Object[]{value};
                }
                List bindings = bh.calculateBindings(null, names, vals);
                for (int j = 0; j < bindings.size(); ++j) {
                    IRGoal goal = this.createGoal(null, (IMReferenceableElement)configgoals[i].getOriginalElement(), configgoals[i], null, (Map)bindings.get(j));
                    this.dispatchTopLevelGoal(goal);
                }
                continue;
            }
            IRGoal goal = this.createGoal(configgoals[i].getName(), (IMReferenceableElement)configgoals[i].getOriginalElement(), configgoals[i], null, null);
            this.dispatchTopLevelGoal(goal);
        }
    }

    protected void leaveRunningState(IMGoal mgoal) {
        IRCondition pc;
        BindingHelper bh = (BindingHelper)this.bindings.remove(mgoal);
        if (bh != null) {
            bh.cleanup();
        }
        if ((pc = (IRCondition)this.conditions.remove(mgoal)) != null) {
            pc.cleanup();
        }
        IRGoal[] goals = this.getGoals(mgoal.getName());
        for (int i = 0; i < goals.length; ++i) {
            if (this.isProtected(goals[i])) continue;
            goals[i].drop();
        }
        RProcessGoal[] pgoals = this.getProcessGoals(mgoal.getName());
        for (int i = 0; i < pgoals.length; ++i) {
            if (this.isProtected(pgoals[i])) continue;
            pgoals[i].drop("aborted_on_failure");
        }
    }

    protected void leaveRunningState(IMGoalReference mgoal) {
        IRGoal[] goals = this.getGoals(mgoal.getName());
        for (int i = 0; i < goals.length; ++i) {
            if (this.isProtected(goals[i])) continue;
            goals[i].drop();
        }
        RProcessGoal[] pgoals = this.getProcessGoals(mgoal.getName());
        for (int i = 0; i < pgoals.length; ++i) {
            if (this.isProtected(pgoals[i])) continue;
            pgoals[i].drop("aborted_on_failure");
        }
    }

    public boolean isEndStateTerminated() {
        return this.adoptedgoals.size() == 0 && this.processgoals.size() == 0;
    }

    public IMMetaGoal getMetaGoals(IREvent event) {
        IMMetaGoal ret = null;
        Iterator metagoalfilters = this.metagoalmap.keySet().iterator();
        while (metagoalfilters.hasNext()) {
            IFilter filter = (IFilter)metagoalfilters.next();
            if (!this.getScope().getAgent().applyFilter(filter, event)) continue;
            if (ret != null) {
                throw new RuntimeException("Multiple meta goals matching event: " + event + ", " + ret + ", " + this.metagoalmap.get(filter));
            }
            ret = (IMMetaGoal)this.metagoalmap.get(filter);
        }
        return ret;
    }

    static {
        $assertionsDisabled = !RGoalbase.class.desiredAssertionStatus();
    }
}

