/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCondition;
import jadex.model.IMConfigGoal;
import jadex.model.IMDeliberation;
import jadex.model.IMElement;
import jadex.model.IMGoal;
import jadex.model.IMParameter;
import jadex.model.IMParameterSet;
import jadex.runtime.GoalEventFilter;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.ApplicableCandidateList;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RCondition;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RGoalEvent;
import jadex.runtime.impl.RParameterElement;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.ComposedPrecondition;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.easydeliberation.DeactivateInhibitedGoalsAction;
import jadex.runtime.impl.agenda.easydeliberation.DeliberateGoalActivationAction;
import jadex.runtime.impl.agenda.easydeliberation.DeliberateInhibitedGoalsReactivationAction;
import jadex.runtime.impl.agenda.goals.DropGoalAction;
import jadex.runtime.impl.agenda.goals.GoalLifecycleStatePrecondition;
import jadex.runtime.impl.agenda.goals.GoalNotFinishedPrecondition;
import jadex.runtime.impl.agenda.goals.GoalProcessingStatePrecondition;
import jadex.runtime.impl.agenda.goals.RecurAction;
import jadex.runtime.impl.agenda.goals.SwitchContextAction;
import jadex.util.SReflect;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RGoal
extends RParameterElement
implements IRGoal {
    protected static final boolean DELIBERATION = true;
    protected static final MultiCollection transitions;
    protected RProcessGoal parent;
    protected RElement cause;
    protected Set processgoals;
    protected RCondition context;
    protected RCondition drop;
    protected String lifecyclestate = "new";
    protected boolean dropping;
    protected boolean subgoal;
    protected TimetableData retryentry;
    protected Exception exception;
    protected ApplicableCandidateList apl;
    protected Boolean posttoall;
    protected Boolean random;
    protected Boolean retry;
    protected Long retrydelay;
    protected String excludemode;
    protected Boolean recalculate;
    protected Boolean recur;
    protected Long recurdelay;
    protected IAgendaActionPrecondition prec_notfinished;
    private TimetableData recurentry;
    protected RuntimeException ex;
    protected IAgendaActionPrecondition precond;
    protected SystemEvent goalchanged = new SystemEvent("BDI_goalChanged", this);
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RGoal(String name, IMGoal goal, IMConfigGoal state, RElement owner, RReferenceableElement creator, Map binding) {
        super(name, goal, state, owner, creator, binding);
        this.prec_notfinished = new GoalNotFinishedPrecondition(this);
        this.setExpressionParameter("$goal", this);
        this.setContextCondition(goal.getContextCondition());
        this.setDropCondition(goal.getDropCondition());
        this.setParameterProtectionMode("protection_init");
        this.setCause(this.getScope().getAgent().getCurrentPlan());
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.drop != null) {
            this.drop.cleanup();
        }
        if (this.context != null) {
            this.context.cleanup();
        }
    }

    public boolean isPostToAll() {
        return this.posttoall != null ? this.posttoall.booleanValue() : ((IMGoal)this.getModelElement()).isPostToAll();
    }

    public boolean isRandomSelection() {
        return this.random != null ? this.random.booleanValue() : ((IMGoal)this.getModelElement()).isRandomSelection();
    }

    public void setPostToAll(boolean flag) {
        this.posttoall = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setRandomSelection(boolean flag) {
        this.random = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isRetry() {
        return this.retry != null ? this.retry.booleanValue() : ((IMGoal)this.getModelElement()).isRetry();
    }

    public void setRetry(boolean flag) {
        this.retry = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public long getRetryDelay() {
        return this.retrydelay != null ? this.retrydelay.longValue() : ((IMGoal)this.getModelElement()).getRetryDelay();
    }

    public void setRetryDelay(long delay) {
        this.retrydelay = new Long(delay);
    }

    public String getExcludeMode() {
        return this.excludemode != null ? this.excludemode : ((IMGoal)this.getModelElement()).getExcludeMode();
    }

    public void setExcludeMode(String exclude) {
        this.excludemode = exclude;
    }

    public boolean isRecalculating() {
        return this.recalculate != null ? this.recalculate.booleanValue() : ((IMGoal)this.getModelElement()).isRecalculating();
    }

    public void setRecalculating(boolean recalculate) {
        this.recalculate = recalculate ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isRecur() {
        return this.recur != null ? this.recur.booleanValue() : ((IMGoal)this.getModelElement()).isRecur();
    }

    public long getRecurDelay() {
        return this.recurdelay != null ? this.recurdelay.longValue() : ((IMGoal)this.getModelElement()).getRecurDelay();
    }

    public void setRecur(boolean flag) {
        this.recur = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setRecurDelay(long delay) {
        this.recurdelay = new Long(delay);
    }

    public RProcessGoal getRealParent() {
        RProcessGoal realparent = null;
        List occs = this.getAllOccurrences();
        for (int i = 0; realparent == null && i < occs.size(); ++i) {
            IRGoal occ = (IRGoal)occs.get(i);
            realparent = occ.getParent();
        }
        return realparent;
    }

    public RProcessGoal getParent() {
        return this.parent;
    }

    public void setParent(RProcessGoal parent) {
        this.parent = parent;
        if (parent != null) {
            this.setSubgoal(true);
        }
    }

    public RElement getCause() {
        return this.cause;
    }

    public void setCause(RElement cause) {
        this.cause = cause;
    }

    public boolean isActive() {
        return "active".equals(this.lifecyclestate);
    }

    public abstract boolean isInProcess();

    public abstract boolean isFinished();

    public abstract boolean isSucceeded();

    public boolean isFailed() {
        return this.isFinished() && !this.isSucceeded();
    }

    public boolean isOption() {
        return "option".equals(this.lifecyclestate);
    }

    public boolean isAdopted() {
        return "adopted".equals(this.lifecyclestate) || "active".equals(this.lifecyclestate) || "option".equals(this.lifecyclestate) || "suspended".equals(this.lifecyclestate);
    }

    public String getLifecycleState() {
        return this.lifecyclestate;
    }

    public void setContextCondition(IMCondition mcontext) {
        if (this.context != null) {
            this.context.cleanup();
        }
        if (mcontext != null) {
            SwitchContextAction sca = new SwitchContextAction(this, (IAgendaActionPrecondition)new GoalLifecycleStatePrecondition(this, "adopted"));
            sca.addPrecondition(new IAgendaActionPrecondition(){

                public boolean check() {
                    Boolean valid_context = RGoal.this.context.evaluate();
                    boolean trigger_true = RGoal.this.context.getTrigger().equals("changes_to_true");
                    return trigger_true && valid_context != null && valid_context != false || !trigger_true && valid_context != null && valid_context == false;
                }
            });
            this.context = this.getScope().getExpressionbase().createInternalCondition(mcontext, this, sca, null);
            if (this.isAdopted()) {
                this.context.traceAlways();
            }
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    public RCondition getContextCondition() {
        return this.context;
    }

    public void setDropCondition(IMCondition mdel) {
        if (this.drop != null) {
            this.drop.cleanup();
        }
        if (mdel != null) {
            this.drop = this.getScope().getExpressionbase().createInternalCondition(mdel, this, new DropGoalAction(new GoalLifecycleStatePrecondition(this, "adopted"), this), null);
            if (this.isAdopted()) {
                this.drop.traceOnce();
            }
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    public boolean isSame(IRGoal goal) {
        boolean same = this.getType().equals(goal.getType());
        if (same) {
            IMGoal mgoal = (IMGoal)goal.getModelElement();
            IMParameter[] params = mgoal.getRelevantParameters();
            for (int i = 0; same && i < params.length; ++i) {
                Object val2;
                Object val1 = this.getParameter(params[i].getName()).getValue();
                same = val1 == (val2 = goal.getParameter(params[i].getName()).getValue()) || val1 != null && val1.equals(val2);
            }
            IMParameterSet[] paramsets = mgoal.getRelevantParameterSets();
            for (int i = 0; same && i < paramsets.length; ++i) {
                Object[] vals2;
                Object[] vals1 = this.getParameterSet(paramsets[i].getName()).getValues();
                same = vals1.length == (vals2 = goal.getParameterSet(paramsets[i].getName()).getValues()).length;
                for (int j = 0; same && j < vals1.length; ++j) {
                    same = vals1[j] == vals2[j] || vals1[j] != null && vals1[j].equals(vals2[j]);
                }
            }
        }
        return same;
    }

    public ApplicableCandidateList getApplicableCandidateList() {
        return this.apl;
    }

    public void setApplicableCandidateList(ApplicableCandidateList apl) {
        this.apl = apl;
    }

    public void processGoalsCreated(List pgoals) {
        if (this.processgoals == null && !pgoals.isEmpty()) {
            this.processgoals = SCollection.createHashSet();
        }
        for (int i = 0; i < pgoals.size(); ++i) {
            this.processgoals.add(pgoals.get(i));
            if (!this.getExcludeMode().equals(IGoal.EXCLUDE_WHEN_TRIED)) continue;
            this.apl.addExcludeCandidate(((RProcessGoal)pgoals.get(i)).getCandidateInfo());
        }
    }

    protected void processGoalFinished(RProcessGoal procgoal) {
        if (!$assertionsDisabled && this.processgoals == null) {
            throw new AssertionError(this);
        }
        if (!$assertionsDisabled && !this.processgoals.contains(procgoal)) {
            throw new AssertionError(this);
        }
        this.processgoals.remove(procgoal);
        if (this.getExcludeMode().equals(IGoal.EXCLUDE_WHEN_SUCCEEDED) && procgoal.isSucceeded() || this.getExcludeMode().equals(IGoal.EXCLUDE_WHEN_FAILED) && procgoal.isFailed()) {
            this.apl.addExcludeCandidate(procgoal.getCandidateInfo());
        }
        if (!this.isFinished() && !this.getLifecycleState().equals("suspended")) {
            this.copyContentFrom(procgoal);
        }
    }

    public void scheduleRecur() {
        if (!($assertionsDisabled || this.isRecur() && !this.isFinished())) {
            throw new AssertionError();
        }
        this.recurentry = new TimetableData(this.getRecurDelay(), new RecurAction(this, (IAgendaActionPrecondition)new GoalProcessingStatePrecondition(this, this.getProcessingState())));
        this.getScope().getAgent().addTimetableEntry(this.recurentry);
    }

    public void changeLifecycleState(String newstate) {
        if (!$assertionsDisabled && !transitions.getCollection(this.getLifecycleState()).contains(newstate)) {
            throw new AssertionError((Object)("Cannot change lifecycle state from " + this.getLifecycleState() + " to " + newstate + ": " + this.getName()));
        }
        String oldstate = this.lifecyclestate;
        this.lifecyclestate = newstate;
        if (oldstate.equals("new")) {
            this.exitNewState();
        } else if (oldstate.equals("option")) {
            this.exitOptionState();
        } else if (oldstate.equals("active")) {
            this.exitActiveState();
        } else if (oldstate.equals("suspended")) {
            this.exitSuspendedState();
        }
        if (newstate.equals("adopted")) {
            this.enterAdoptedState();
        } else if (newstate.equals("option")) {
            this.enterOptionState();
        } else if (newstate.equals("active")) {
            this.enterActiveState();
        } else if (newstate.equals("suspended")) {
            this.enterSuspendedState();
        } else if (newstate.equals("dropped")) {
            if ("adopted".equals(oldstate) || "active".equals(oldstate) || "option".equals(oldstate) || "suspended".equals(oldstate)) {
                this.exitAdoptedState();
            }
            this.enterDroppedState();
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    protected void enterAdoptedState() {
        IRParameter[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IMParameter mparam = (IMParameter)params[i].getModelElement();
            if (mparam.isOptional() || !mparam.getDirection().equals("in") && !mparam.getDirection().equals("inout") || params[i].getValue() != null) continue;
            throw new RuntimeException("Goal parameter is required and nulls: " + params[i] + " " + this + " " + this.parameters);
        }
        IRParameterSet[] paramsets = this.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            IMParameterSet mparam = (IMParameterSet)paramsets[i].getModelElement();
            if (mparam.isOptional() || !mparam.getDirection().equals("in") && !mparam.getDirection().equals("inout") || paramsets[i].size() != 0) continue;
            throw new RuntimeException("Goal parameter set is required and nulls: " + paramsets[i] + " " + this + " " + this.parameters);
        }
        this.setParameterProtectionMode("protection_processing");
        this.throwSystemEvent(new SystemEvent("BDI_goalAdded", this));
        if (this.drop != null) {
            if (this.drop.isTriggered()) {
                this.drop();
            } else {
                this.drop.setTraceMode("once");
            }
        }
        if (this.isAdopted()) {
            boolean suspend = false;
            if (this.context != null) {
                Boolean valid_context = this.context.evaluate();
                suspend = valid_context != null && valid_context == false;
                this.context.setTraceMode("always");
            }
            this.changeLifecycleState(suspend ? "suspended" : "option");
        }
    }

    protected void enterOptionState() {
        this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateGoalActivationAction(new GoalLifecycleStatePrecondition(this, "option"), this), this);
    }

    protected void enterActiveState() {
        this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeactivateInhibitedGoalsAction(new GoalLifecycleStatePrecondition(this, "active"), this), this);
    }

    public IMDeliberation getDeliberationInfo() {
        return ((IMGoal)this.getModelElement()).getDeliberation();
    }

    protected void enterSuspendedState() {
        if (this.context != null) {
            this.context.setTrigger("changes_to_true");
        }
        this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateInhibitedGoalsReactivationAction(new GoalLifecycleStatePrecondition(this, "active", true), this), this);
    }

    protected void enterDroppedState() {
        this.throwInfoEvent();
        this.getScope().getGoalbase().removeGoal(this);
        List occs = this.getAllOccurrences();
        for (int i = 0; i < occs.size(); ++i) {
            IRGoal occ = (IRGoal)occs.get(i);
            if (occ.getParent() != null) {
                occ.getParent().removeSubgoal(occ);
            }
            if (!occ.getScope().getGoalbase().containsGoal(occ)) continue;
            occ.getScope().getGoalbase().removeGoal(occ);
        }
        this.throwSystemEvent(new SystemEvent("BDI_goalRemoved", this));
        this.cleanup();
    }

    protected void exitNewState() {
    }

    protected void exitAdoptedState() {
        if (!$assertionsDisabled && !this.isFinished()) {
            throw new AssertionError(this);
        }
        if (this.context != null) {
            this.context.setTraceMode("never");
        }
        if (this.drop != null) {
            this.drop.setTraceMode("never");
        }
        this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateInhibitedGoalsReactivationAction(null, this), this);
    }

    protected void exitOptionState() {
    }

    protected void exitActiveState() {
        if (this.retryentry != null) {
            this.getScope().getAgent().removeTimetableEntry(this.retryentry);
        }
        if (this.recurentry != null) {
            this.getScope().getAgent().removeTimetableEntry(this.recurentry);
        }
        this.abortProcessGoals();
    }

    protected void exitSuspendedState() {
        if (this.context != null) {
            this.context.setTrigger("changes_to_false");
        }
    }

    public TimetableData getRetryEntry() {
        return this.retryentry;
    }

    public void setRetryEntry(TimetableData retryentry) {
        this.retryentry = retryentry;
    }

    public TimetableData getRecurEntry() {
        return this.recurentry;
    }

    protected void adopt() {
        this.changeLifecycleState("adopted");
    }

    public void option() {
        this.changeLifecycleState("option");
    }

    public void activate() {
        this.changeLifecycleState("active");
    }

    public void suspend() {
        this.changeLifecycleState("suspended");
    }

    public void drop() {
        if (!this.isAdopted()) {
            throw new RuntimeException("Cannot drop a goal wich is not (any longer) adopted: " + this);
        }
        if (this.dropping) {
            return;
        }
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (debug) {
            if (this.ex == null) {
                try {
                    throw new RuntimeException("First stack trace: " + this.getName() + ", " + this.getProcessingState() + ", " + this.getLifecycleState());
                }
                catch (RuntimeException e) {
                    this.ex = e;
                }
            } else {
                this.ex.printStackTrace();
                try {
                    throw new RuntimeException("Second stack trace: " + this.getName() + ", " + this.getProcessingState() + ", " + this.getLifecycleState());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        this.dropping = true;
        this.changeLifecycleState("dropped");
        this.dropping = false;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setResult(Object result) {
        this.findResultParameter().setValue(result);
        this.throwSystemEvent("BDI_goalChanged");
    }

    public Object getResult() {
        return this.findResultParameter().getValue();
    }

    protected IRParameter findResultParameter() {
        IMElement mret = null;
        IMParameter[] mparams = ((IMGoal)this.getModelElement()).getParameters();
        for (int i = 0; i < mparams.length; ++i) {
            if (!mparams[i].getDirection().equals("out") && !mparams[i].getDirection().equals("inout")) continue;
            if (mret == null) {
                mret = mparams[i];
                continue;
            }
            throw new RuntimeException("No unique out parameter: " + this);
        }
        if (mret == null) {
            throw new RuntimeException("No out parameter found: " + this);
        }
        return this.getParameter(mret.getName());
    }

    public boolean isSubgoal() {
        return this.subgoal;
    }

    public void setSubgoal(boolean subgoal) {
        this.subgoal = subgoal;
    }

    protected String toString(int level) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(name=");
        buf.append(this.getName());
        buf.append(", type=");
        buf.append(this.getType());
        buf.append(", active=");
        buf.append(this.isActive());
        buf.append(")");
        return buf.toString();
    }

    public void doRecur() {
        if (this.apl != null) {
            this.apl.clearExcludeSet();
        }
        this.throwProcessEvent();
    }

    public void throwProcessEvent() {
        if (!this.dropping) {
            if (this.precond == null) {
                this.precond = this.createProcessEventPrecondition();
            }
            RGoalEvent event = this.getScope().getEventbase().createGoalEvent(this, false);
            this.getScope().dispatchEvent(event, this.precond);
        }
    }

    protected IAgendaActionPrecondition createProcessEventPrecondition() {
        return new ComposedPrecondition(new GoalNotFinishedPrecondition(this), new GoalLifecycleStatePrecondition(this, "active"));
    }

    public void throwInfoEvent() {
        RGoalEvent event = this.getScope().getEventbase().createGoalEvent(this, true);
        this.getScope().dispatchEvent(event, new IAgendaActionPrecondition(){

            public boolean check() {
                return !RGoal.this.isSubgoal() || RGoal.this.getRealParent().isAdopted();
            }
        });
    }

    public void throwSystemEvent(String event) {
        if (!$assertionsDisabled && !"BDI_goalChanged".equals(event)) {
            throw new AssertionError();
        }
        this.throwSystemEvent(this.goalchanged);
    }

    public Map getEncodableRepresentation() {
        RProcessGoal realparent;
        Map representation = super.getEncodableRepresentation();
        representation.put("contextcondition", this.context == null ? "" : ((IMCondition)this.context.getModelElement()).getExpressionText());
        representation.put("dropcondition", this.drop == null ? "" : ((IMCondition)this.drop.getModelElement()).getExpressionText());
        representation.put("lifecyclestate", this.getLifecycleState());
        if (this.parent != null) {
            representation.put("parent", this.parent.getName());
        }
        if ((realparent = this.getRealParent()) != null) {
            representation.put("realparent", realparent.getName());
            representation.put("realparentscope", realparent.getScope().getDetailName());
        }
        representation.put("kind", this.getGoalKind());
        return representation;
    }

    public String getGoalKind() {
        String kind = SReflect.getInnerClassName(this.getClass());
        kind = kind.substring(1, kind.length() - 4);
        return kind.toLowerCase();
    }

    protected boolean isProcessingFinished() {
        return this.processgoals == null || this.processgoals.isEmpty();
    }

    public abstract String getProcessingState();

    public abstract void changeProcessingState(String var1);

    public void abortProcessGoals() {
        boolean abort_on_success = this.isSucceeded();
        if (this.processgoals != null) {
            RProcessGoal[] goals = this.processgoals.toArray(new RProcessGoal[this.processgoals.size()]);
            for (int i = 0; i < goals.length; ++i) {
                goals[i].abort(abort_on_success);
            }
        }
    }

    public boolean wasProcessed() {
        return this.processgoals != null;
    }

    protected void copyContentFrom(RProcessGoal pgoal) {
        this.setException(pgoal.getException());
        try {
            pgoal.copyContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IFilter getFilter() {
        return new GoalEventFilter(this.getType(), this.getName(), true);
    }

    static {
        $assertionsDisabled = !RGoal.class.desiredAssertionStatus();
        transitions = new MultiCollection();
        transitions.put("new", "adopted");
        transitions.put("adopted", "option");
        transitions.put("adopted", "suspended");
        transitions.put("adopted", "dropped");
        transitions.put("option", "active");
        transitions.put("option", "suspended");
        transitions.put("option", "dropped");
        transitions.put("active", "option");
        transitions.put("active", "suspended");
        transitions.put("active", "dropped");
        transitions.put("suspended", "option");
        transitions.put("suspended", "dropped");
    }
}

