/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMBindingCondition;
import jadex.model.IMCondition;
import jadex.model.IMConditionReference;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.model.IMExpressionbase;
import jadex.model.IMReferenceableElement;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.BindingHelper;
import jadex.runtime.impl.IInterpreterCondition;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RBindingCondition;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RCondition;
import jadex.runtime.impl.RConditionReference;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RExpression;
import jadex.runtime.impl.RExpressionReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.agenda.AbstractAgendaAction;
import jadex.util.collection.SCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class RExpressionbase
extends RBase {
    protected Set observed_expressions = SCollection.createWeakSet();
    protected Set expview;
    protected Collection traced_conditions = SCollection.concurrencyCheckingList(SCollection.createWeakList());
    protected Collection condview;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RExpressionbase(IMExpressionbase model, RElement owner) {
        super(null, model, owner);
    }

    public IRExpression getExpression(String name) {
        IMReferenceableElement exp = ((IMExpressionbase)this.getModelElement()).getReferenceableElement(name);
        return this.createExpression(exp, null);
    }

    public IRExpression createExpression(String query, String[] paramnames, Class[] paramtypes) {
        if (paramnames == null && paramtypes != null || paramnames != null && paramtypes == null || paramnames != null && paramnames.length != paramnames.length) {
            throw new RuntimeException("Parameter invalid: " + paramnames);
        }
        IRExpression ret = null;
        IMExpression mex = ((IMExpressionbase)this.getModelElement()).createExpression(null, query, null, "false", paramnames, paramtypes);
        ret = this.createExpression(mex, null);
        ret.setTemporary(true);
        return ret;
    }

    public IRCondition createCondition(String expression) {
        return this.createCondition(expression, "changes_to_true", null, null);
    }

    public IRCondition createCondition(String query, String trigger, String[] paramnames, Class[] paramtypes) {
        if (paramnames == null && paramtypes != null || paramnames != null && paramtypes == null || paramnames != null && paramnames.length != paramnames.length) {
            throw new RuntimeException("Parameter invalid: " + paramnames);
        }
        IRCondition ret = null;
        IMCondition mcond = ((IMExpressionbase)this.getModelElement()).createCondition(null, query, trigger, "false", paramnames, paramtypes);
        ret = this.createCondition(mcond, null);
        ret.setTemporary(true);
        return ret;
    }

    protected IRExpression createExpression(IMReferenceableElement model, RReferenceableElement creator) {
        IRExpression ret = this.internalCreateExpression(model, creator);
        ret.getOriginalElement().initStructure();
        return ret;
    }

    protected IRExpression internalCreateExpression(IMReferenceableElement model, RReferenceableElement creator) {
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRExpression)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        if (model.getScope() != this.getScope().getModelElement()) {
            throw new RuntimeException("Creation of elements only allowed in definition scope! " + model.getName());
        }
        if (model instanceof IMExpression) {
            ret = new RExpression((IMExpression)model, this, creator, null);
        } else if (model instanceof IMExpressionReference) {
            ret = new RExpressionReference((IMExpressionReference)model, this, creator);
        } else {
            throw new RuntimeException("Element not an expression: " + model);
        }
        return ret;
    }

    public IRCondition createCondition(IMReferenceableElement model, RReferenceableElement creator) {
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRCondition)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        if (model.getScope() != this.getScope().getModelElement()) {
            throw new RuntimeException("Creation of elements only allowed in definition scope! " + model.getName());
        }
        if (model instanceof IMCondition) {
            ret = new RCondition((IMCondition)model, (RElement)this, creator, null);
        } else if (model instanceof IMConditionReference) {
            RConditionReference rcr = new RConditionReference((IMConditionReference)model, (RElement)this, creator);
            rcr.init();
            ret = rcr;
        } else {
            throw new RuntimeException("Element not an expression: " + model);
        }
        return ret;
    }

    public IRCondition getCondition(String name) {
        IMReferenceableElement mcond = ((IMExpressionbase)this.getModelElement()).getReferenceableElement(name);
        return this.createCondition(mcond, null);
    }

    public Object evaluateInternalExpression(IMExpression model, RElement owner) {
        if (!$assertionsDisabled && model == null) {
            throw new AssertionError((Object)"Expression must not be null.");
        }
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)("Creation of elements only allowed in definition scope! " + model.getName()));
        }
        return RExpression.evaluateExpression(model, owner.getExpressionParameters());
    }

    public RExpression createInternalExpression(IMExpression model, RElement owner, SystemEvent systemevent) {
        if (model.getScope() != owner.getScope().getModelElement()) {
            throw new RuntimeException("Creation of elements only allowed in definition scope! " + model.getName());
        }
        return new RExpression(model, owner, null, systemevent);
    }

    protected RCondition createInternalCondition(IMCondition model, RElement owner, AbstractAgendaAction action, BindingHelper bindings) {
        if (model.getScope() != owner.getScope().getModelElement()) {
            throw new RuntimeException("Creation of elements only allowed in definition scope! " + model.getName());
        }
        RCondition ret = model instanceof IMBindingCondition ? new RBindingCondition((IMBindingCondition)model, owner, action, bindings) : new RCondition(model, owner, null, action);
        return ret;
    }

    protected void addExpression(RExpression expression) {
        if (!this.observed_expressions.add(expression)) {
            throw new RuntimeException("Expression already contained: " + expression);
        }
    }

    protected void removeExpression(RExpression expression) {
        this.observed_expressions.remove(expression);
    }

    protected void addCondition(IInterpreterCondition condition) {
        if (!this.traced_conditions.add(condition)) {
            throw new RuntimeException("Condition already contained: " + condition);
        }
    }

    protected void removeCondition(IInterpreterCondition condition) {
        this.traced_conditions.remove(condition);
    }

    protected Set getExpressions() {
        return this.expview != null ? this.expview : (this.expview = Collections.unmodifiableSet(this.observed_expressions));
    }

    public Collection getConditions() {
        return this.condview != null ? this.condview : (this.condview = Collections.unmodifiableCollection(this.traced_conditions));
    }

    public void registerExpression(IMExpression mexpression) {
    }

    public void registerExpressionReference(IMExpressionReference mexpressionref) {
    }

    public void registerCondition(IMCondition mcondition) {
    }

    public void registerConditionReference(IMConditionReference mconditionref) {
    }

    public void deregisterExpression(IMExpression mexpression) {
    }

    public void deregisterExpressionReference(IMExpressionReference mexpressionref) {
    }

    public void deregisterCondition(IMCondition mcondition) {
    }

    public void deregisterConditionReference(IMConditionReference mconditionref) {
    }

    protected RReferenceableElement getElementInstance(IMReferenceableElement melement, RReferenceableElement creator) {
        RCapability scope = this.getScope().getAgent().lookupCapability(melement.getScope());
        if (melement instanceof IMCondition || melement instanceof IMConditionReference) {
            return (RReferenceableElement)((Object)scope.getExpressionbase().createCondition(melement, creator));
        }
        if (melement instanceof IMExpression || melement instanceof IMExpressionReference) {
            return (RReferenceableElement)((Object)scope.getExpressionbase().internalCreateExpression(melement, creator));
        }
        throw new RuntimeException("Cannot create element (neither expression nor condition): " + melement);
    }

    protected RBase getCorrespondingBase(RCapability scope) {
        return scope.getExpressionbase();
    }

    static {
        $assertionsDisabled = !RExpressionbase.class.desiredAssertionStatus();
    }
}

