/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMElement;
import jadex.model.IMExpression;
import jadex.model.IMExpressionbase;
import jadex.model.IMReferenceableElement;
import jadex.runtime.ExpressionEvaluationException;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.SReflect;
import jadex.util.Tuple;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RExpression
extends RReferenceableElement
implements IRExpression {
    protected Object value;
    protected SystemEvent systemevent;
    protected MultiCollection relevant;
    protected Collection relevant_any;
    protected boolean temporary;

    protected RExpression(IMExpression modelelement, RElement owner, RReferenceableElement creator, SystemEvent systemevent) {
        super(null, modelelement, null, owner, creator, null);
        if (modelelement.getEvaluationMode() == null) {
            throw new RuntimeException("Evaluation mode nulls: " + modelelement.getName() + " " + modelelement.getExpressionText());
        }
        if (!modelelement.getEvaluationMode().equals("dynamic")) {
            this.value = this.evaluateTerm(null);
        }
        this.systemevent = systemevent;
        if (systemevent != null) {
            systemevent.setDerived(true);
            this.getScope().getExpressionbase().addExpression(this);
        }
        this.relevant = ((IMExpression)this.getModelElement()).getRelevantList();
        this.relevant_any = this.relevant.getCollection("any_element_indicator");
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.getClass().equals(RExpression.class)) {
            if (this.isTemporary()) {
                IMReferenceableElement elem = (IMReferenceableElement)this.getModelElement();
                ((IMExpressionbase)this.getScope().getExpressionbase().getModelElement()).deleteReferenceableElement(elem);
            }
            if (this.systemevent != null) {
                this.getScope().getExpressionbase().removeExpression(this);
            }
        }
    }

    public Object getValue() {
        return this.getValue(null);
    }

    protected Object getValue(Map params) {
        Object ret = this.value;
        if (((IMExpression)this.getModelElement()).getEvaluationMode().equals("dynamic")) {
            ret = this.evaluateTerm(params);
        }
        return ret;
    }

    public void refresh() {
        if (!"dynamic".equals(((IMExpression)this.getModelElement()).getEvaluationMode())) {
            this.value = this.evaluateTerm(null);
        }
    }

    public boolean isAffected(SystemEvent event) {
        boolean affected = false;
        affected = this.relevant_any.contains(event.getType());
        if (!affected && event.getSource() instanceof RElement) {
            affected = this.relevant.getCollection(((RElement)event.getSource()).getModelElement()).contains(event.getType());
        } else if (!affected && event.getSource() instanceof IMElement) {
            affected = this.relevant.getCollection(event.getSource()).contains(event.getType());
        }
        return affected;
    }

    public SystemEvent getSystemEvent(SystemEvent event) {
        SystemEvent ret = null;
        if (this.systemevent != null && this.getOwner() != event.getSource() && this.isAffected(event)) {
            ret = this.systemevent;
            if (!this.getScope().listenerinfos.isEmpty()) {
                try {
                    this.systemevent.setValue(this.getValue());
                }
                catch (Exception e) {
                    this.systemevent.setValue("n/a");
                }
            }
        }
        return ret;
    }

    public String toString() {
        return this.getName() + " " + ((IMExpression)this.getModelElement()).getExpressionText();
    }

    protected Object evaluateTerm(Map parameters) {
        IMExpression mex = (IMExpression)this.getModelElement();
        parameters = parameters != null ? SCollection.createNestedMap(new Map[]{parameters, this.getExpressionParameters()}) : this.getExpressionParameters();
        Object value = RExpression.evaluateExpression(mex, parameters);
        if (mex.getClazz() != null) {
            value = SReflect.convertWrappedValue(value, mex.getClazz());
        }
        return value;
    }

    public void setParameter(String name, Object value) {
        this.setExpressionParameter(name, value);
    }

    public Object getParameter(String name) {
        return this.getExpressionParameter(name);
    }

    public Object execute() {
        return this.getValue();
    }

    public Object execute(String name, Object value) {
        HashMap params = SCollection.createHashMap();
        params.put(name, value);
        return this.getValue(params);
    }

    public Object execute(Tuple[] parameters) {
        HashMap params = SCollection.createHashMap();
        for (int i = 0; i < parameters.length; ++i) {
            params.put(parameters[i].get(0), parameters[i].get(1));
        }
        return this.getValue(params);
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public static Object evaluateExpression(IMExpression mex, Map params) {
        try {
            return mex.getTerm().getValue(params);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException("Error evaluating expression '" + mex.getExpressionText() + "' of element " + mex.getOwner() + ".", e);
        }
    }
}

