/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.adapter.AbstractMessageAdapter;
import jadex.adapter.IMessageAdapter;
import jadex.adapter.IMessageEventTransport;
import jadex.model.IMCapability;
import jadex.model.IMConfigEventbase;
import jadex.model.IMConfigInternalEvent;
import jadex.model.IMConfigMessageEvent;
import jadex.model.IMConfigParameter;
import jadex.model.IMConfiguration;
import jadex.model.IMEvent;
import jadex.model.IMEventReference;
import jadex.model.IMEventbase;
import jadex.model.IMGoal;
import jadex.model.IMGoalEvent;
import jadex.model.IMGoalEventReference;
import jadex.model.IMInternalEvent;
import jadex.model.IMInternalEventReference;
import jadex.model.IMMessageEvent;
import jadex.model.IMMessageEventReference;
import jadex.model.IMReferenceableElement;
import jadex.model.MessageType;
import jadex.runtime.IFilter;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.BindingHelper;
import jadex.runtime.impl.IElementCreator;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.IRInternalEvent;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.IRReferenceableElement;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RCondition;
import jadex.runtime.impl.RConditionReference;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RElementReference;
import jadex.runtime.impl.REventReference;
import jadex.runtime.impl.RGoalEvent;
import jadex.runtime.impl.RGoalEventReference;
import jadex.runtime.impl.RGoalReference;
import jadex.runtime.impl.RInternalEvent;
import jadex.runtime.impl.RInternalEventReference;
import jadex.runtime.impl.RMessageEvent;
import jadex.runtime.impl.RMessageEventReference;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class REventbase
extends RBase {
    public static final String STORED_MESSAGES_MAX = "storedmessages.size";
    protected List sent_mevents = SCollection.createWeakList();
    protected long mevents_max;
    protected long max_mevents_delay;
    protected Map bindings = SCollection.createHashMap();
    protected List mevent_store = SCollection.createArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected REventbase(IMEventbase model, RElement owner) {
        super(null, model, owner);
    }

    protected void init(int level) {
        if (level == 0) {
            IMMessageEvent[] mevents = ((IMEventbase)this.getModelElement()).getMessageEvents();
            for (int i = 0; i < mevents.length; ++i) {
                this.registerEvent(mevents[i]);
            }
            IMInternalEvent[] ievents = ((IMEventbase)this.getModelElement()).getInternalEvents();
            for (int i = 0; i < ievents.length; ++i) {
                this.registerEvent(ievents[i]);
            }
        } else if (level == 1) {
            IMConfigEventbase initialbase;
            Integer cmax = (Integer)this.getScope().getPropertybase().getProperty(STORED_MESSAGES_MAX);
            if (cmax == null) {
                this.getScope().getLogger().warning("Could not read default conversation max amount in agent properties.");
            } else {
                this.mevents_max = cmax.intValue();
            }
            IMConfiguration is = this.getScope().getConfiguration();
            if (is != null && (initialbase = is.getEventbase()) != null) {
                this.instantiateConfigMessages(initialbase.getInitialMessageEvents());
                this.instantiateConfigInternalEvents(initialbase.getInitialInternalEvents());
            }
        }
    }

    protected void instantiateConfigInternalEvents(IMConfigInternalEvent[] ies) {
        for (int i = 0; i < ies.length; ++i) {
            BindingHelper bh = (BindingHelper)this.bindings.get(ies[i].getOriginalElement());
            if (bh != null) {
                if (ies[i].getName() != null) {
                    throw new RuntimeException("Config elements for elements with bindings cannot have a name: " + ies[i]);
                }
                IMConfigParameter[] inips = ies[i].getParameters();
                String[] names = new String[inips.length];
                Object[] vals = new Object[inips.length];
                for (int j = 0; j < inips.length; ++j) {
                    Object value = this.getScope().getExpressionbase().evaluateInternalExpression(inips[j].getInitialValue(), this);
                    names[j] = inips[j].getOriginalElement().getName();
                    vals[j] = new Object[]{this.getScope().getExpressionbase().evaluateInternalExpression(inips[j].getInitialValue(), this)};
                }
                List binds = bh.calculateBindings(null, names, vals);
                for (int j = 0; j < binds.size(); ++j) {
                    this.dispatchInternalEvent(this.createInternalEvent((IMReferenceableElement)ies[i].getOriginalElement(), ies[i], null, (Map)binds.get(j)));
                }
                continue;
            }
            this.dispatchInternalEvent(this.createInternalEvent((IMReferenceableElement)ies[i].getOriginalElement(), ies[i], null, null));
        }
    }

    protected void instantiateConfigMessages(IMConfigMessageEvent[] mes) {
        for (int i = 0; i < mes.length; ++i) {
            BindingHelper bh = (BindingHelper)this.bindings.get(mes[i].getOriginalElement());
            if (bh != null) {
                if (mes[i].getName() != null) {
                    throw new RuntimeException("Config elements for elements with bindings cannot have a name: " + mes[i]);
                }
                IMConfigParameter[] inips = mes[i].getParameters();
                String[] names = new String[inips.length];
                Object[] vals = new Object[inips.length];
                for (int j = 0; j < inips.length; ++j) {
                    names[j] = inips[j].getOriginalElement().getName();
                    vals[j] = new Object[]{this.getScope().getExpressionbase().evaluateInternalExpression(inips[j].getInitialValue(), this)};
                }
                List binds = bh.calculateBindings(null, names, vals);
                for (int j = 0; j < binds.size(); ++j) {
                    this.sendMessage(this.createMessageEvent((IMReferenceableElement)mes[i].getOriginalElement(), mes[i], null, false, (Map)binds.get(j)));
                }
                continue;
            }
            IRMessageEvent me = this.createMessageEvent((IMReferenceableElement)mes[i].getOriginalElement(), mes[i], null, false, null);
            this.sendMessage(me);
            if (mes[i].getName() == null) continue;
            this.mevent_store.add(me);
        }
    }

    public void dispatchInternalEvent(IRInternalEvent event) {
        this.getScope().dispatchEvent(event, null);
        this.getScope().throwSystemEvent(new SystemEvent("internalevent_occurred", event, null));
    }

    public IRInternalEvent createInternalEvent(String type) {
        IMReferenceableElement mevent = ((IMEventbase)this.getModelElement()).getInternalEvent(type);
        if (mevent == null) {
            mevent = ((IMEventbase)this.getModelElement()).getInternalEventReference(type);
        }
        if (mevent == null) {
            throw new RuntimeException("Internal event type not found: " + type);
        }
        return this.createInternalEvent(mevent, null, null, null);
    }

    public IRInternalEvent createInternalEvent(String type, Object content) {
        IMInternalEvent mevent = ((IMEventbase)this.getModelElement()).getInternalEvent("legacy_internal_event");
        IRInternalEvent event = this.createInternalEvent(mevent, null, null, null);
        event.getParameter("legacy_type").setValue(type);
        event.getParameter("legacy_content").setValue(content);
        return event;
    }

    public IFilter sendMessage(IRMessageEvent me) {
        String dir = ((IMMessageEvent)me.getOriginalElement().getModelElement()).getDirection();
        if ("receive".equals(dir)) {
            throw new RuntimeException("Cannot send message that is declared to be received only: " + me);
        }
        this.registerMessageEvent(me);
        this.getScope().throwSystemEvent(new SystemEvent("message_sent", me, null));
        IRMessageEvent ome = (IRMessageEvent)((Object)me.getOriginalElement());
        IMessageEventTransport[] ptrans = this.getScope().getAgentAdapter().getMessageEventTransports();
        boolean sent = false;
        for (int i = 0; i < ptrans.length && !sent; ++i) {
            sent = ptrans[i].sendMessage(ome);
        }
        if (!sent) {
            throw new RuntimeException("No message event transport could send: " + me);
        }
        return new MessageEventFilter(null, me.getName());
    }

    public IRMessageEvent createMessageEvent(String type) {
        IMReferenceableElement mevent = ((IMEventbase)this.getModelElement()).getMessageEvent(type);
        if (mevent == null) {
            mevent = ((IMEventbase)this.getModelElement()).getMessageEventReference(type);
        }
        if (mevent == null) {
            throw new RuntimeException("Message event type not found: " + type);
        }
        return this.createMessageEvent(mevent, null, null, false, null);
    }

    public void removeMessageEvent(String name) {
        for (int i = 0; i < this.mevent_store.size(); ++i) {
            IRMessageEvent me = (IRMessageEvent)this.mevent_store.get(i);
            if (!name.equals(me.getName())) continue;
            this.mevent_store.remove(me);
            break;
        }
    }

    protected IRInternalEvent createInternalEvent(IMReferenceableElement model, IMConfigInternalEvent config, RReferenceableElement creator, Map exparams) {
        if (!$assertionsDisabled && model == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRInternalEvent)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        if (model instanceof IMInternalEvent) {
            ret = new RInternalEvent(config != null ? config.getName() : null, (IMInternalEvent)model, config, (RElement)this, creator, exparams);
        } else if (model instanceof IMInternalEventReference) {
            RInternalEventReference rier = new RInternalEventReference(config != null ? config.getName() : null, (IMEventReference)model, config, (RElement)this, creator);
            rier.init();
            ret = rier;
        } else {
            throw new RuntimeException("Element not an internal event: " + model);
        }
        return ret;
    }

    public RInternalEvent createInternalEvent(IMInternalEvent model) {
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        RInternalEvent ret = new RInternalEvent(null, model, null, (RElement)this, null, null);
        return ret;
    }

    protected IRMessageEvent createMessageEvent(IMReferenceableElement model, IMConfigMessageEvent config, RReferenceableElement creator, boolean incoming, Map exparams) {
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)("Creation of elements only allowed in definition scope! " + model.getScope().getName() + " " + this.getScope().getModelElement().getName()));
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRMessageEvent)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        if (model instanceof IMMessageEvent) {
            ret = new RMessageEvent(config != null ? config.getName() : null, (IMMessageEvent)model, config, this, creator, incoming, exparams);
        } else if (model instanceof IMMessageEventReference) {
            RMessageEventReference rmer = new RMessageEventReference(config != null ? config.getName() : null, (IMEventReference)model, config, (RElement)this, creator);
            rmer.init();
            ret = rmer;
        } else {
            throw new RuntimeException("Element not an internal event: " + model);
        }
        return ret;
    }

    public void dispatchIncomingMessageEvent(IMReferenceableElement model, IMessageAdapter msgad, IRMessageEvent original) {
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        IRMessageEvent msg = this.createMessageEvent(model, null, null, true, null);
        if (original != null) {
            msg.setInReplyMessageEvent(original);
        }
        AbstractMessageAdapter.prepareReceiving(msg, msgad);
        RCapability scope = this.getScope();
        scope.dispatchEvent(msg, null);
        scope.throwSystemEvent(new SystemEvent("message_received", msg, null));
    }

    public RInternalEvent createInternalConditionTriggeredEvent(IMInternalEvent model, RCondition cond) {
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        return (RInternalEvent)this.createElementStructure(cond, new ConditionEventCreator(model, cond));
    }

    protected RGoalEvent createGoalEvent(IRGoal goal, boolean info) {
        IMGoalEvent model = ((IMGoal)goal.getModelElement()).getGoalEvent();
        if (!$assertionsDisabled && model.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        return (RGoalEvent)this.createElementStructure(goal, new GoalEventCreator(model, goal, info));
    }

    protected RMessageEventReference createMessageEventReference(IMMessageEventReference reference, RReferenceableElement creator) {
        if (!$assertionsDisabled && reference.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRMessageEvent)) {
            throw new AssertionError(creator);
        }
        RMessageEventReference eventref = new RMessageEventReference(null, (IMEventReference)reference, null, (RElement)this, creator);
        return eventref;
    }

    protected RInternalEventReference createInternalEventReference(IMInternalEventReference reference, RReferenceableElement creator) {
        if (!$assertionsDisabled && reference.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRInternalEvent)) {
            throw new AssertionError(creator);
        }
        RInternalEventReference eventref = new RInternalEventReference(null, (IMEventReference)reference, null, (RElement)this, creator);
        return eventref;
    }

    protected RGoalEventReference createGoalEventReference(IMGoalEventReference reference, RReferenceableElement creator, RGoalReference goalref) {
        if (!$assertionsDisabled && reference == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && goalref == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && reference.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)"Creation of elements only allowed in definition scope!");
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRGoalEvent)) {
            throw new AssertionError(creator);
        }
        RGoalEventReference eventref = new RGoalEventReference(null, (IMEventReference)reference, this, creator, goalref);
        return eventref;
    }

    public void registerEvent(IMEvent mevent) {
        BindingHelper binding = null;
        if (mevent.getBindingParameters().length > 0) {
            binding = new BindingHelper(mevent, this, false);
            this.bindings.put(mevent, binding);
        }
    }

    public void deregisterEvent(IMEvent mevent) {
        BindingHelper bh = (BindingHelper)this.bindings.remove(mevent);
        if (bh != null) {
            bh.cleanup();
        }
    }

    public void registerEventReference(IMEventReference meventref) {
    }

    public void deregisterEventReference(IMEventReference meventref) {
    }

    protected RReferenceableElement getElementInstance(IMReferenceableElement melement, RReferenceableElement creator) {
        RCapability scope = this.getScope().getAgent().lookupCapability(melement.getScope());
        if (melement instanceof IMMessageEvent || melement instanceof IMMessageEventReference) {
            return (RReferenceableElement)((Object)scope.getEventbase().createMessageEvent(melement, null, creator, false, null));
        }
        if (melement instanceof IMInternalEvent || melement instanceof IMInternalEventReference) {
            return (RReferenceableElement)((Object)scope.getEventbase().createInternalEvent(melement, null, creator, null));
        }
        throw new RuntimeException("Cannot create element (neither internal nor message event): " + melement);
    }

    protected RBase getCorrespondingBase(RCapability scope) {
        return scope.getEventbase();
    }

    public RElement createElementStructure(IRReferenceableElement orig_structure, IElementCreator creator) {
        if (!$assertionsDisabled && orig_structure instanceof RElementReference) {
            throw new AssertionError();
        }
        RReferenceableElement ret = creator.create();
        if (ret != null) {
            ArrayList structure_elems = SCollection.createArrayList();
            ArrayList created_elems = SCollection.createArrayList();
            structure_elems.add(orig_structure);
            created_elems.add(ret);
            while (structure_elems.size() > 0) {
                RReferenceableElement structure_elem = (RReferenceableElement)structure_elems.remove(0);
                RReferenceableElement new_elem = (RReferenceableElement)created_elems.remove(0);
                List refs = structure_elem.getReferences();
                for (int i = 0; i < refs.size(); ++i) {
                    RReferenceableElement structure_ref = (RReferenceableElement)refs.get(i);
                    RElementReference new_ref = creator.createReference(structure_ref, new_elem);
                    if (new_ref == null) continue;
                    structure_elems.add(structure_ref);
                    created_elems.add(new_ref);
                }
            }
        }
        if (!$assertionsDisabled && ret == null) {
            throw new AssertionError((Object)("Created structure nulls: " + creator));
        }
        ret.initStructure();
        return ret;
    }

    protected void registerMessageEvent(IRMessageEvent msgevent) {
        if (this.mevents_max != 0L && (long)this.sent_mevents.size() > this.mevents_max) {
            this.getScope().getLogger().severe("Agent does not save conversation due to too many outstanding messages. Increase buffer in runtime.xml - storedmessages.size");
        } else {
            this.sent_mevents.add(msgevent);
        }
    }

    public IRMessageEvent getInReplyMessageEvent(IMessageAdapter message) {
        IRMessageEvent ret = null;
        IRMessageEvent[] smes = this.sent_mevents.toArray(new IRMessageEvent[0]);
        for (int i = smes.length - 1; ret == null && i > -1; --i) {
            boolean match = true;
            boolean matched = false;
            MessageType type = ((IMMessageEvent)smes[i].getOriginalElement().getModelElement()).getMessageType();
            MessageType.ParameterSpecification[] params = type.getParameters();
            for (int j = 0; match && j < params.length; ++j) {
                if (!params[j].isConversationIdentifier()) continue;
                Object sourceval = smes[i].getParameter(params[j].getSource()).getValue();
                Object destval = message.getValue(params[j].getName(), this.getScope());
                match = SUtil.equals(sourceval, destval);
                matched = matched || sourceval != null;
            }
            MessageType.ParameterSpecification[] paramsets = type.getParameterSets();
            for (int j = 0; match && j < paramsets.length; ++j) {
                if (!paramsets[j].isConversationIdentifier()) continue;
                Object sourceval = smes[i].getParameter(paramsets[j].getSource()).getValue();
                Iterator it2 = SReflect.getIterator(message.getValue(paramsets[j].getName(), this.getScope()));
                while (it2.hasNext()) {
                    Object destval = it2.next();
                    match = SUtil.equals(sourceval, destval);
                    matched = matched || sourceval != null;
                }
            }
            if (!matched || !match) continue;
            ret = smes[i];
        }
        return ret;
    }

    public void activateEndState() {
        IMConfigEventbase eventbase;
        IMConfiguration config = this.getScope().getConfiguration();
        if (config != null && (eventbase = config.getEventbase()) != null) {
            this.instantiateConfigMessages(eventbase.getEndMessageEvents());
            this.instantiateConfigInternalEvents(eventbase.getEndInternalEvents());
        }
    }

    protected static IREvent getOriginalEvent(IREvent event) {
        while (event instanceof REventReference) {
            event = (IREvent)((Object)((REventReference)event).getReferencedElement());
        }
        return event;
    }

    static {
        $assertionsDisabled = !REventbase.class.desiredAssertionStatus();
    }

    public class GoalEventCreator
    implements IElementCreator {
        protected IMGoalEvent model;
        protected IRGoal goal;
        protected boolean info;

        public GoalEventCreator(IMGoalEvent model, IRGoal goal, boolean info) {
            this.model = model;
            this.goal = goal;
            this.info = info;
        }

        public RReferenceableElement create() {
            return new RGoalEvent(this.model, REventbase.this, this.goal, this.info, null);
        }

        public RElementReference createReference(RReferenceableElement ref, RReferenceableElement creator) {
            IMGoalEventReference mevent = ((IMCapability)ref.getScope().getModelElement()).getEventbase().getGoalEventReference("standard_goal_event_reference");
            if (mevent == null) {
                mevent = ((IMCapability)ref.getScope().getModelElement()).getEventbase().getGoalEventReference("standard_goal_event_reference");
            }
            RGoalEventReference eventref = ref.getScope().getEventbase().createGoalEventReference(mevent, creator, (RGoalReference)ref);
            return eventref;
        }
    }

    public class ConditionEventCreator
    implements IElementCreator {
        protected IMInternalEvent model;
        protected RCondition cond;

        public ConditionEventCreator(IMInternalEvent model, RCondition cond) {
            this.model = model;
            this.cond = cond;
        }

        public RReferenceableElement create() {
            RInternalEvent ret = new RInternalEvent(null, this.model, null, (RElement)REventbase.this, null, null);
            ret.getParameter("condition").setValue(this.cond);
            return ret;
        }

        public RElementReference createReference(RReferenceableElement ref, RReferenceableElement creator) {
            IMInternalEventReference mevent = ((IMCapability)ref.getScope().getModelElement()).getEventbase().getInternalEventReference("InternalEvent_condition_triggered_reference");
            RInternalEventReference eventref = ref.getScope().getEventbase().createInternalEventReference(mevent, creator);
            eventref.setCondition((RConditionReference)ref);
            return eventref;
        }
    }
}

